<style type="text/css">
    .fc-grid {
        position: initial !important;
    }

    .popover-content {
        background: #E1E1E1;
    }

    .popover-title {
        background: rgb(1, 103, 177, 1);
    }
</style>
<div class="row-fluid">
    <div class="span12">
        <div class="box calendar">
            <div class="title">
                <h4>
                    <span class="icon16 icomoon-icon-calendar"></span>
                    <span>Calendario de Seguimientos</span>
                </h4>
            </div>
            <div class="content noPad" id="contenedorppal">
                <div id="calendar">
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('#calendar').fullCalendar({
            //isRTL: true,
            //theme: true,
            header: {
                left: 'title,today',
                center: 'prev,next',
                right: 'month,agendaWeek,agendaDay'
            },
            buttonText: {
                prev: '<span class="icon24 icomoon-icon-arrow-left-2"></span>',
                next: '<span class="icon24 icomoon-icon-arrow-right-2"></span>'
            },
            eventRender: function(eventObj, $el) {
                $el.popover({
                    title: '<b style="color: white;">' + eventObj.description + '</b>',
                    content: eventObj.concepto + '<br>' + eventObj.lugar,
                    trigger: 'hover',
                    placement: 'top',
                    container: 'body',
                    html: 'true'
                });
            },
            editable: false,
            droppable: false, // this allows things to be dropped onto the calendar !!!
            events: [<?php
                        foreach ($informacion as $key => $value) {
                        ?> {
                    title: '<?= $value['description'] ?>',
                    description: '<?= $value['description'] ?>',
                    concepto: '<?= trim($value['concepto']) ?>',
                    lugar: '<?= $value['lugar'] ?>',
                    start: '<?= $value['start'] ?>',
                    end: '<?= $value['end'] ?>',
                    color: '<?= $value['color'] ?>',
                    <?php if ($value['estado'] != 0 && $value['estado'] != 3) { ?>
                        url: '<?= $value['url'] ?>',
                    <?php } ?>
                    allDay: '<?= $value['allday'] ?>',
                }, <?php
                        } ?>]
        });


        $("body").on('click', '.fc-content a', function(event) {
            url_action = $(this).attr("href");
            id_evento = $(this).attr("href").split("/").pop();
            if (id_evento > 0) //preguntar si corresponde a evento 
            {
                event.preventDefault();
                $.fancybox({
                    'width': '90%',
                    'height': '80%',
                    'autoScale': true,
                    openEffect: 'elastic',
                    closeEffect: 'elastic',
                    'href': $(this).attr('href'),
                    'title': "DETALLE DE SEGUIMIENTO COTIZACION",
                    'type': 'iframe',
                    closeBtn: true,
                });
            }
        });
    });

    function verificar_eventos() {
        $(".fc-content a").addClass("ver_evento");
        $(".fc-content a").attr("target", "_blank");
    }
</script>
<script type="text/javascript" src="<?= base_url() ?>js/cotizaciones/procesos/cartelera_seguimiento.js"></script>