<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4><span>Agregar Producto a Lista</span></h4>
                <button url="<?= base_url("cotizaciones/cotizaciones/articulos_lista_precio/" . $tipo_lista) ?>" type="button" onclick="url=$('#back').attr('url'); location.href=url;" class="btn btn-info" id="back" style="position:absolute;top:7%;right: 1%;">
                    <span class="icon16 icomoon-icon-undo-2 white"> Regresar</span>
                </button>
            </div>
            <div class="content">
                <form method="POST" id="form_list_price" action="<?= base_url('cotizaciones/cotizaciones/add_article_list/' . $tipo_lista) ?>">
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3">Artículo: <b class="red">*</b></label>
                                    <div class="span7 controls">
                                        <input type="hidden" id="slcProducto" name="slcProducto" class="list" onchange="$('#slcProducto_error').html('');">
                                        <input type="hidden" name="txt_tipo_lista" id="txt_tipo_lista" value="<?= $tipo_lista ?>">
                                        <br><br>
                                        <div id="slcProducto_error" style="color:red;font-size:11px;"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3">Precio: <b class="red">*</b></label>
                                    <div class="span7 controls">
                                        <input type="text" id="txt_precio" name="txt_precio" class="soloDecimales" decimales="6" onchange="$('#txt_precio_error').html('');">
                                        <div id="txt_precio_error" style="color:red; font-size:11px;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3">Cantidad Desde:<b class="red">*</b></label>
                                    <div class="span7 controls">
                                        <input type="text" id="txt_desde_ctdad" name="txt_desde_ctdad" class="soloDecimales" onchange="$('#txt_desde_ctdad_error').html('');">
                                        <div id="txt_desde_ctdad_error" style="color:red;font-size:11px;"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3">Unidad: <b class="red">*</b></label>
                                    <div class="span7 controls">
                                        <select class="nostyle" name="slc_mep_art" id="slc_mep_art" onchange="$('#slc_mep_art_error').html('');" placeholder="Seleccione">
                                            <option></option>
                                        </select>
                                        <br><br>
                                        <div id="slc_mep_art_error" style="color:red; font-size:11px;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3">Cantidad Hasta:<b class="red">*</b></label>
                                    <div class="span7 controls">
                                        <input type="text" id="txt_hasta_ctdad" name="txt_hasta_ctdad" class="soloDecimales" onchange="$('#txt_hasta_ctdad_error').html('');">
                                        <div id="txt_hasta_ctdad_error" style="color:red;font-size:11px;"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3">Precio Última Compra:</label>
                                    <div class="span7 controls">
                                        <input id="prec_ultima_compra" name="prec_ultima_compra" type="text" value="" readonly>
                                        <div id="prec_ultima_compra_error" style="color:red; font-size:11px;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3">Porcentaje Mínimo: <b class="red">*</b></label>
                                    <div class="span7 controls">
                                        <input type="text" id="porc_min" name="porc_min" class="soloDecimales" onchange="$('#porc_min_error').html('');">
                                        <div id="porc_min_error" style="color:red;font-size:11px;"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3">% Variación Utilidad:</label>
                                    <div class="span7 controls">
                                        <input id="varia_utilidad" name="varia_utilidad" type="text" value="" readonly>
                                        <div id="varia_utilidad_error" style="color:red; font-size:11px;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3">Porcentaje Máximo: <b class="red">*</b></label>
                                    <div class="span7 controls">
                                        <input type="text" id="porc_max" name="porc_max" class="soloDecimales" onchange="$('#porc_max').html('');">
                                        <div id="porc_max" style="color:red;font-size:11px;"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3">Mínimo de Venta:</label>
                                    <div class="span7 controls">
                                        <input type="text" id="venta_min" name="venta_min" class="soloDecimales" onchange="$('#venta_min').html('');">
                                        <div id="venta_min_error" style="color:red; font-size:11px;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions">
                        <button type="submit" name="btnCrear" class="btn btn-success" value="0">
                            <span class="icon16 icomoon-icon-checkmark white"> Guardar</span>
                        </button>
                        <button type="submit" name="btnCrear" class="btn btn-success" value="1">
                            <span class="icomoon-icon-checkmark white"> Guardar y volver a la lista</span>
                        </button>
                        <a class="btn btn-danger btn-cancelar" href="<?= base_url("cotizaciones/cotizaciones/articulos_lista_precio/" . $tipo_lista) ?>">
                            <span class="icon16 icomoon-icon-cancel-2 white"> Cancelar</span>
                        </a>
                        <p>Campos con asterisco en <font color="FE2E2E">rojo</font> son requeridos</p>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("select").select2();
        var um_inicial = $("#slc_mep_art").val();

        $("#porc_min, #porc_max").keyup(function(event) {
            $(this).val(minmax($(this).val()));
        });

        $("#slc_mep_art").change(function(event) {
            var precio = $("#txt_precio").val();
            var precio_um = 0;
            if (um_inicial != $("#slc_mep_art").val()) {
                url_ajax = window.satelite.base_url('facturacion/entradas/get_valor_conversion');
                $.ajax({
                    url: url_ajax,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        id_unidad: parseInt($("#slc_mep_art").val()),
                        id_articulo: parseInt($("#slcProducto").val())
                    },
                    error: function(xhr, status, error) {
                        exportarError(xhr.responseText);
                    },
                    success: function(json) {
                        precio_um = json[0]['cva_conversion'];
                        precio = precio / precio_um;
                        $("#txt_precio").val(precio.toFixed(6));
                    }
                });
            }
            verificar_ultima_entrada();
        });

        $("#txt_precio").keyup(function(event) {
            verificar_ultima_entrada();
        });

        $("#venta_min").blur(function() {
            var desde = parseFloat($('#txt_desde_ctdad').val());
            var hasta = parseFloat($('#txt_hasta_ctdad').val());
            var minima = parseFloat($("#venta_min").val());
            if (!(minima >= desde && minima <= hasta)) {
                $("#venta_min").val('');
                crear_alerta('error', 'Validacion', 'Campo Minimo de Venta debe estar entre la cantidad desde hasta');
            }
        });

        $("#slcProducto").select2({
            placeholder: "Buscar Producto",
            minimumInputLength: 3,
            ajax: {
                url: urlj + 'facturacion/facturar/get_productos_like',
                dataType: 'json',
                type: 'POST',
                delay: 250,
                data: function(producto) {
                    return {
                        producto: producto
                    };
                },
                results: function(data) {
                    var myResults = [];
                    $.each(data, function(index, item) {
                        myResults.push({
                            'id': item.producto,
                            'text': item.codigo + ' - ' + item.prod_nombre,
                        });
                    });
                    return {
                        results: myResults
                    };
                }
            },
            initSelection: function(element, callback) {
                var idElemento = element[0].id;
                var valor = $("#" + idElemento).val();
                if (valor !== "") {
                    var texto = $("#" + idElemento).data('nombre');
                    callback({
                        id: valor,
                        text: texto
                    });
                }
            }
        });

        $("#slcProducto").change(function() {
            var art = $(this).val();
            if (art > 0) {
                $.ajax({
                    url: urlj + 'facturacion/entradas/get_meps_prod',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        id_articulo: art,
                        id_tipo_lis: $("#txt_tipo_lista").val()
                    },
                    beforeSend: function() {
                        wait.start();
                    },
                    error: function(xhr, status, error) {
                        exportarError(xhr.responseText);
                    },
                    success: function(data) {
                        if (data.cuantas > 0) {
                            crear_alerta('error', 'Artículo Ya Existe En Lista', 'Busque en la lista para gestionar precios');
                            $('#slcProducto').val(null).trigger('change');
                        } else {
                            $("#slc_mep_art").html(data.lista);
                            $("#slc_mep_art").select2();
                        }
                        wait.close();
                    }
                });
            } else {
                $("#slc_mep_art").html('<option></option>');
                $("#slc_mep_art").select2();
            }
        });

        $("#form_list_price").validate({
            rules: {
                slcProducto: {
                    required: true
                },
                txt_tipo_lista: {
                    required: true
                },
                txt_precio: {
                    required: true
                },
                txt_desde_ctdad: {
                    required: true
                },
                txt_hasta_ctdad: {
                    required: true
                },
                porc_min: {
                    required: true
                },
                porc_max: {
                    required: true
                },
                slc_mep_art: {
                    required: true
                }
            },
            ignore: ":disabled",
            errorPlacement: function(error, element) {
                var nombre = $(element).attr("id");
                $('#' + nombre + '_error').html(error);
            },
            submitHandler: function(form) {
                wait.start();
                form.submit();
            }
        });

    });

    function minmax(value) {
        if (parseFloat(value) < 0) {
            return 0;
        } else if (parseFloat(value) > 100) {
            return 100;
        } else {
            return value;
        }
    }

    function verificar_ultima_entrada() {
        id_articulo = $("#slcProducto").val();;
        precio_lista = $("#txt_precio").val();
        unidad_medida = $("#slc_mep_art").val();
        if (unidad_medida > 0 && id_articulo > 0 && precio_lista > 0) {
            url_ajax = window.satelite.base_url('facturacion/entradas/get_valor_ultima_entrada');
            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    precio_lista: precio_lista,
                    id_articulo: id_articulo,
                    unidad_medida: unidad_medida
                },
                error: function(xhr, status, error) {
                    exportarError(xhr.responseText);
                },
                success: function(json) {
                    $("#prec_ultima_compra").val(json.ultima_compra.toFixed(2));
                    $("#varia_utilidad").val(json.utilidad.toFixed(2));
                }
            });
        }
    }
</script>