<?php
header("Content-type: application/vnd.ms-excel; name='Reporte_Resumen_de_Ventas'");
header("Content-Disposition: filename=Reporte_Resumen_de_Ventas.xls");
header("Pragma: no-cache");
header("Expires: 0");
?>

<meta charset="utf-8" />
<style type='text/css'>
    body {
        font-family: Arial;
        font-size: 14px;
    }

    a {
        color: blue;
        text-decoration: none;
        font-size: 14px;
    }

    a:hover {
        text-decoration: underline;
    }

    .color {
        background: red;
    }
</style>
<?php if (!isset($accesoNo)) { ?>
    <div class="row-fluid principal">
        <div class="span12">
            <div class="box">
                <div class="content">
                    <div>
                        <?php if (isset($datosVen) and !isset($error)) {
                            //preguntar si existe la variable del reporte,  formatear las fechas
                            $f1 = explode("-", $fecha1);
                            $fecha1txt = "$f1[0]/$f1[1]/$f1[2]";
                            $f2 = explode("-", $fecha2);
                            $fecha2txt = "$f2[0]/$f2[1]/$f2[2]";
                        }
                        if (isset($datosVen)) {
                            //preguntar si existe la variable del reporte 
                            if (!isset($error)) {
                        ?>
                                <div align="center"> <b style="font-size: 14px;">Reporte de cumplimiento de metas</b></div>
                                <span><b>Periodo:</b> </span><span><?php echo "$fecha1txt";  ?></span><span> al </span><span><?php echo "$fecha2txt";  ?></span><br>
                                <span><b>Vendedor:</b> <?php
                                                        if (isset($todosSeleccionados)) {
                                                            echo $todosSeleccionados;
                                                        } else {
                                                            foreach ($datosVen->result() as $nombresVen) {
                                                                echo $nombresVen->ven_nombre . " " . $nombresVen->ven_apellidos . ". ";
                                                            }
                                                        } ?>
                                </span>
                                <br><br>
                                <div>
                                    <table class="responsive table table-bordered" align="center" border=1 width="100%">
                                        <tr style="font-size:12px;">
                                            <th> VENDEDOR </th>
                                            <th> META VENTAS </th>
                                            <th> VENTA ACTUAL </th>
                                            <th> PORCENTAJE </th>
                                        </tr>
                                        <?php
                                        $registros = $datosVen->result();
                                        if (isset($tambien_vendedor) && count($tambien_vendedor) > 0) {
                                            $idsv = array_unique(array_column($datosVen->result_array(), 'ven_id'));
                                            if (!(in_array($tambien_vendedor->ven_id, $idsv))) {
                                                array_push($registros, $tambien_vendedor);
                                            }
                                        }
                                        $totalM = 0;
                                        $totalV = 0;
                                        foreach ($registros as $FilaVen) {
                                            $meta_vendedor = $this->cotModel->get_metasXvendedor($FilaVen->ven_id, $fecha1, $fecha2);
                                        ?>
                                            <tr style="font-size:11px;">
                                                <td valign="top">
                                                    <?php echo $FilaVen->ven_nombre . " " . $FilaVen->ven_apellidos; ?>
                                                </td>
                                                <td valign="top">
                                                    <?php
                                                    if ($FilaVen->ven_meta_ventas == null) {
                                                        if (count($meta_vendedor) > 0) {
                                                            $FilaVen->ven_meta_ventas = number_format($meta_vendedor[0]['mtv_meta_venta'], 2, '.', '');
                                                        } else {
                                                            $FilaVen->ven_meta_ventas = '0.00';
                                                        }
                                                    }
                                                    echo $simbolo . number_format($FilaVen->ven_meta_ventas, 2);
                                                    $totalM += $FilaVen->ven_meta_ventas;
                                                    ?>
                                                </td>
                                                <td valign="top">
                                                    <?php
                                                    $totalvendido = $this->cotModel->totalCotizacionesGanadaxVen($FilaVen->ven_id, $fecha1, $fecha2);
                                                    if ($totalvendido == null) {
                                                        $totalvendido = '0.00';
                                                    }
                                                    echo $simbolo . number_format($totalvendido, 2);
                                                    $totalV += $totalvendido;
                                                    ?>
                                                </td>
                                                <td valign="top">
                                                    <?php
                                                    if ($FilaVen->ven_meta_ventas == 0) {
                                                        echo "0 %";
                                                    } else {
                                                        $por = ($totalvendido * 100) / $FilaVen->ven_meta_ventas;
                                                        echo number_format($por, 0) . " % ";
                                                    }
                                                    ?>
                                                </td>
                                            </tr>
                                        <?php
                                        } //FIN DE FOREACH 
                                        ?>
                                        <tr>
                                            <td>&nbsp;</td>
                                            <td><?= $simbolo ?> <?php echo number_format($totalM, 2); ?></td>
                                            <td><?= $simbolo ?> <?php echo number_format($totalV, 2); ?></td>
                                            <td>&nbsp;</td>
                                        </tr>
                                    </table>
                                    <br />
                                </div>
                        <?php
                            } else {
                                echo '<span style="color:red;">Error:</span> La <i>Fecha inicio</i> no puede ser mayor a la <i>Fecha fin</i>';
                            }
                        } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
} else {
    echo "<b>Nota: </b>ACCI&Oacute;N DE REPORTER&Iacute;A SOLO PARA SUPERVISORES";
}  ?>