<script type="text/javascript">
  jQuery(document).ready(function($) {
    $("#empleado").select2();
    $("#motivo_consulta").select2();
    $(".reporte").hide();
    $("input[id^='fecha']").mask('99-99-9999');
    $("input[id^='fecha']").datepicker({
      dateFormat: 'dd-mm-yy',
      changeMonth: true,
      changeYear: true
    });
    $('#form_reporte').validate({
      ignore: null,
      ignore: 'input[type="hidden"]', //errorElement: "",
      rules: {
        motivo_consulta: {
          required: true
        }
      },
      submitHandler: function(form) {
        cargar_resultados();
      }
    });

  });

  function cargar_resultados() {
    $(".reporte").hide('slow');
    wait.start();
    $("#resultados").hide("slide", {
      direction: 'right'
    }, 400, function() {
      $.ajax({
        url: window.gSateliteWhite.baseUrl('cotizaciones/consultas/get_reporte_tabla_llamadas'),
        type: 'post',
        data: {
          'desde': $("#fecha_desde").val(),
          'hasta': $("#fecha_hasta").val(),
          'motivo': $("#motivo_consulta").val()
        },
        success: function(data) {
          $("#desde").val($("#fecha_desde").val());
          $("#hasta").val($("#fecha_hasta").val());
          $("#motivo").val($("#motivo_consulta").val());
          $("#resultados").html(data);
          $(".reporte").show('slow');
          wait.close();
          $("#tabla_resultados").dataTable().css('margin-top', '5%');
          $("#resultados").show("slide", {
            direction: 'left'
          }, 500);
        }
      });
    });

  }
</script>
<style type="text/css">
  .span3 {
    min-width: 160px;
    max-width: 160px;
  }
</style>
<div class="row-fluid">
  <div class="span12">
    <div class="box">
      <div class="title">
        <h4>
          <span>Reporte de Tabla de Llamadas</span>
        </h4>
      </div>
      <div class="content">
        <form method="post" id="form_reporte" name="form_reporte">
          <div class="form-row row-fluid">
            <div class="span12">
              <div class="row-fluid">
                <label class="form-label span3">Motivo <b style="color:red;">*</b></label>
                <div class="span8 controls">
                  <select id="motivo_consulta" name="motivo_consulta" class="nostyle" style="width:100%;" placeholder='Seleccione'>
                    <?php echo   $motivos; ?>
                  </select>
                  <br />
                  <label for="motivo_consulta" style="padding-top: 15px" generated="true" class="error"></label>
                </div>
              </div>
            </div>
          </div>
          <div class="form-row row-fluid">
            <div class="span12">
              <div class="row-fluid">
                <label class="form-label span3">Desde <b style="color:red;">*</b></label>
                <div class="span8 controls">
                  <input type="text" required id="fecha_desde" placeholder="dd-mm-yyyy" name="fecha_desde" value="<?php echo ($this->input->post('fecha_desde')) ? $this->input->post('fecha_desde') : date('d-m-Y'); ?>">
                </div>
              </div>
            </div>
          </div>
          <div class="form-row row-fluid">
            <div class="span12">
              <div class="row-fluid">
                <label class="form-label span3">Hasta <b style="color:red;">*</b></label>
                <div class="span8 controls">
                  <input type="text" required id="fecha_hasta" placeholder="dd-mm-yyyy" name="fecha_hasta" value="<?php echo ($this->input->post('fecha_hasta')) ? $this->input->post('fecha_hasta') : date('d-m-Y'); ?>">
                </div>
              </div>
            </div>
          </div>
          <div class="form-row row-fluid">
            <div class="span12">
              <div class="row-fluid">
                <button class="btn btn-info" type="submit" id="ver">
                  <span class="icon16 icomoon-icon-search-3 white"></span>
                  <strong>Consultar</strong>
                </button>
              </div>
            </div>
          </div>
      </div>
      <div class="form-actions" style="text-align: right;">
        <!--<button class="btn btn-info" type="submit" id="ver">
              <span class="icon16 icomoon-icon-search-3 white"></span>
              <strong>Consultar</strong>
            </button>-->
        <button class="btn btn-info reporte" type="button" onclick="$('#tipo').val('1'); $('#print_reporte').submit();" id="excel">
          <span class="icon16 icomoon-icon-file-excel white"></span>
          <strong> Exportar a Excel</strong>
        </button>
        </a>
        <button class="btn btn-info reporte" type="button" onclick="$('#tipo').val('2'); $('#print_reporte').submit();" target="_blank" id="pdf">
          <span class="icon16 icomoon-icon-file-pdf white"></span>
          <strong> Exportar a PDF</strong>
        </button>
        <!--<a class="btn btn-info reporte" type="button"  onclick="$('#tipo').val('2'); $('#print_reporte').submit();" target="_blank" id="pdf"  >
              <span class="icon16 icomoon-icon-file-pdf white"></span>
              <strong> Exportar a PDF</strong>
            </a>-->
      </div>
      </form>
      <div id="resultados" style="max-width: 95%;overflow-x: scroll;">
        <!-- Reporte -->
      </div>
    </div>
  </div>
</div>
</div>
<form style="display:none;" id="print_reporte" method="post" target="_blank" action="<?php echo base_url('cotizaciones/consultas/get_reporte_tabla_llamadas'); ?>">
  <input type="text" id="desde" name="desde">
  <input type="text" id="hasta" name="hasta">
  <input type="text" id="tipo" name="tipo">
  <input type="text" id="motivo" name="motivo">
</form>