<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            padding: 15px 0px 0px 0px;
            font-size: 8px;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Proyección de Ventas
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
$periodo = "";
if ($fecha_inicio != null && $fecha_fin != null) {

    $fecha_inicio = $fecha_inicio;
    $fecha_fin = $fecha_fin;

    $periodo = $fecha_inicio . "/" . $fecha_fin;
}

//Si la variable tipo reporte existe se declara la tabla
$i = 1;
$registros = 1;
$pagina = null;
$noBr = ($tipo_reporte != '' && $tipo_reporte == 'pdf') ? 'nobr="true"' : '';
$totalHoras = 0;

foreach ($reporte as $row) :
    if ($tipo_reporte != '') {

        if ($registros == 1) {
?>
            <table class="">
                <tr>
                    <td></td>
                </tr>
                <tr>
                    <td style="width: 10%;"><b>Período:</b></td>
                    <td style="text-align: left;"><?php echo $periodo; ?></td>
                </tr>
            </table>
            <div></div>
        <?php } ?>
        <?php if ($i == 1) {
        ?>
            <table class="tabla">
                <thead>
                    <tr>
                        <th>Cotización</th>
                        <th>Ejecutivo de ventas</th>
                        <th>Cliente</th>
                        <th>Fecha posible cierre</th>
                        <th>Probabilidad de cierre</th>
                        <th>Categoría producto</th>
                        <th>Producto</th>
                        <th style="width:8%;">Monto</th>
                        <th>Fecha de presentación</th>
                        <th>Estado</th>
                        <th>Etapa</th>
                    </tr>
                </thead>
                <tbody>
            <?php
        }
    }

    $vendedor = ($row['emp_id'] != null) ? $row['ven_codigo'] . ' ' . trim($row['emp_nombre']) . ' ' . trim($row['emp_apellido']) : $row['ven_codigo'] . ' ' . trim($row['ven_nombre']) . ' ' . trim($row['ven_apellidos']);
    $cliente = ($row['cli_personeria'] == 1) ? $row['cli_codigo'] . ' - ' . trim($row['cli_nombre']) . ' ' . trim($row['cli_apellido']) : $row['ven_codigo'] . ' - ' . trim($row['emp_apellido']);
            ?>
            <tr <?php echo $noBr; ?>>
                <?php if ($tipo_reporte == '') : ?>
                    <td style="display:none;"><?php echo $registros; ?></td>
                <?php endif; ?>
                <td><?php echo $row['cot_codigo']; ?></td>
                <td><?php echo $vendedor; ?></td>
                <td><?php echo $cliente; ?></td>
                <td><?php echo formatear_fecha('d-m-Y', $row['cot_fecha_cierre']); ?></td>
                <td><?php echo number_format($row['cot_probabilidad_cierre']); ?>%</td>
                <td><?php echo $row['tia_nombre']; ?></td>
                <td><?php echo $row['art_nombre']; ?></td>
                <td style="width:8%;"><?= $simbolo ?><?php echo number_format($row['axc_total'], 2); ?></td>
                <td><?php echo formatear_fecha('d-m-Y', $row['cot_fecha_pres']); ?></td>
                <td><?php echo $row['est_nombre']; ?></td>
                <td><?php echo $row['etc_nombre']; ?></td>
            </tr>
            <?php
            $i++;
            ?>
        <?php
        $registros++;
    endforeach;
        ?>
        <?php if ($tipo_reporte != '') {
        ?>

                </tbody>
            </table>
        <?php }
        ?>