<script type="text/javascript">
    jQuery(document).ready(function($) {
        $("#empleado").select2();
        $("#slcVendedor").select2();
        $(".reporte").hide();
        $("input[id^='fecha']").mask('99-99-9999');
        $("input[id^='fecha']").datepicker({
            dateFormat: 'dd-mm-yy',
            changeMonth: true,
            changeYear: true
        });
        $('#form_reporte').validate({
            ignore: null,
            ignore: 'input[type="hidden"]', //errorElement: "",
            rules: {},
            submitHandler: function(form) {
                cargar_resultados();
            }
        });
    });

    function cargar_resultados() {
        $(".reporte").hide('slow');
        wait.start();
        $("#resultados").hide("slide", {
            direction: 'right'
        }, 400, function() {
            $.ajax({
                url: window.gSateliteWhite.baseUrl('cotizaciones/consultas/get_mejores_clientes'),
                type: 'post',
                data: {
                    'desde': $("#fecha_desde").val(),
                    'hasta': $("#fecha_hasta").val(),
                    'cantidad': $("#cantidad_cli").val(),
                    'vendedor': $("#slcVendedor").val()
                },
                success: function(data) {
                    $("#desde").val($("#fecha_desde").val());
                    $("#hasta").val($("#fecha_hasta").val());
                    $("#cantidad").val($("#cantidad_cli").val());
                    $("#vendedor").val($("#slcVendedor").val());
                    $("#resultados").html(data);
                    $(".reporte").show('slow');
                    wait.close();
                    $("#tabla_resultados tr").attr('style', 'font-size:12px;');
                    $("#resultados").show("slide", {
                        direction: 'left'
                    }, 500);
                }
            });
        });
    }
</script>
<style type="text/css">
    .span3 {
        min-width: 120px;
        max-width: 120px;
    }
</style>

<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>
                    <span>Reporte de mejores clientes</span>
                </h4>
            </div>
            <div class="content">
                <form method="post" id="form_reporte" name="form_reporte">
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Número Clientes:<b style="color:red;">*</b></label>
                                <div class="span8 controls">
                                    <input type="text" required id="cantidad_cli" maxlength="4" class="soloNumeros" name="cantidad_cli" value="10">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Desde <b style="color:red;">*</b></label>
                                <div class="span8 controls">
                                    <input type="text" required id="fecha_desde" name="fecha_desde" value="<?php echo ($this->input->post('fecha_desde')) ? $this->input->post('fecha_desde') : date('d-m-Y'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Hasta <b style="color:red;">*</b></label>
                                <div class="span8 controls">
                                    <input type="text" required id="fecha_hasta" name="fecha_hasta" value="<?php echo ($this->input->post('fecha_hasta')) ? $this->input->post('fecha_hasta') : date('d-m-Y'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Vendedor:</label>
                                <div class="span8 controls labels-info">
                                    <select class="nostyle" name="slcVendedor" id="slcVendedor" placeholder="Seleccione">
                                        <option value=""></option>
                                        <?php foreach ($vendedores as $fila) : ?>
                                            <option value="<?php echo $fila['ven_id']; ?>"><?php echo $fila['ven_codigo'] . ' - ' . $fila['ven_nombre'] . ' ' . $fila['ven_apellidos']; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <button class="btn btn-info" type="submit" id="ver">
                                    <span class="icon16 icomoon-icon-search-3 white">
                                        <strong>Consultar</strong>
                                    </span>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions" style="text-align: right;">
                        <!--<button class="btn btn-info" type="submit" id="ver">
                            <span class="icon16 icomoon-icon-search-3 white">
                                <strong>Consultar</strong>
                            </span>
                        </button>-->
                        <button class="btn btn-info reporte" type="button" onclick="$('#tipo').val('1'); $('#print_reporte').submit();" id="excel">
                            <span class="icon16 icomoon-icon-file-excel white">
                                <strong> Exportar a Excel</strong>
                            </span>
                        </button>
                        </a>
                        <button class="btn btn-info reporte" type="button" onclick="$('#tipo').val('2'); $('#print_reporte').submit();" target="_blank" id="pdf">
                            <span class="icon16 icomoon-icon-file-pdf white">
                                <strong> Exportar a PDF</strong>
                            </span>
                        </button>
                        <!--<a class="btn btn-info reporte" type="button"  onclick="$('#tipo').val('2'); $('#print_reporte').submit();" target="_blank" id="pdf"  >
                            <span class="icon16 icomoon-icon-file-pdf white"></span>
                            <strong> Exportar a PDF</strong>
                        </a>-->
                    </div>
                </form>
                <div id="resultados">
                    <!-- Reporte -->
                </div>
            </div>
        </div>
    </div>
</div>
<form style="display:none;" id="print_reporte" method="post" target="_blank" action="<?php echo base_url('cotizaciones/consultas/get_mejores_clientes'); ?>">
    <input type="text" id="desde" name="desde">
    <input type="text" id="hasta" name="hasta">
    <input type="text" id="cantidad" name="cantidad">
    <input type="text" id="vendedor" name="vendedor">
    <input type="tipo" id="tipo" name="tipo">
</form>