<?php
if ($tipo_reporte == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}
$tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
if ($tipo_reporte != 'grid') {
?>
    <style type="text/css">
        .tabla {
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }

        th {
            font-weight: bold !important;
        }

        td {
            font-family: arial;
        }

        .fuente_titulo {
            font-family: <?php echo $tipo_fuente; ?>;
        }
    </style>
    <?php if ($tipo_reporte == 'excel') {
    ?>
        <table>
            <thead>
                <tr>
                    <th colspan="10">Listado de proyectos</th>
                </tr>
            </thead>
        </table>
    <?php
    }
    ?>
    <table border="1" width="100%">
        <tr>
            <th width="5%">No.</th>
            <th>Fecha</th>
            <th>Cliente</th>
            <th>Proyecto</th>
            <th>Estado</th>
            <th>Cotizado</th>
            <th>OC</th>
            <th>DPV</th>
            <th>Facturado</th>
            <th>Cheques</th>
            <th>
                % Pendiente <br>de Facturar
            </th>
        </tr>
        <tbody>
            <?php
            if (count($proyectos) > 0) {

                $num_pro = 1;
                $registro = array();
                $total_cot = 0;
                $orden = 0;
                $documento_prv = 0;
                $facturado = 0;
                $cheque = 0;
                $pendiente_facturado = 0;

                foreach ($proyectos as $key) {
                    $fecha = formatear_fecha('d-m-Y', $key['pcl_fecha_creacion']);

                    $total_cot += ((trim($key['total_cot']) != '') ? $key['total_cot'] : 0);
                    $orden += $key['orden'];
                    $documento_prv += $key['documento_prv'];
                    $facturado += $key['facturado'];
                    $cheque += $key['cheque'];
                    $pendiente_facturado += ($key['total_cot'] > 0) ? number_format(100 - (100 * ($key['facturado'] / $key['total_cot'])), 2) : 0;
            ?>
                    <tr>
                        <td><?php echo $num_pro++; ?></td>
                        <td><?= $fecha ?></td>
                        <?php
                        if ($key['cli_personeria'] == 2) {
                        ?>
                            <td><?= $key['cli_codigo'] . '-' . $key['cli_apellido'] ?></td>
                        <?php
                        } else {
                        ?>
                            <td><?= $key['cli_codigo'] . '-' . $key['cli_nombre'] . ' ' . $key['cli_apellido'] ?></td>
                        <?php
                        }
                        ?>
                        <td><?= $key['pcl_codigo'] . '-' . $key['pcl_nombre'] ?></td>
                        <td><?= $key['epr_nombre'] ?></td>
                        <td><?= number_format($key['total_cot'], 2) ?></td>
                        <td><?= number_format($key['orden'], 2) ?></td>
                        <td><?= number_format($key['documento_prv'], 2) ?></td>
                        <td><?= number_format($key['facturado'], 2) ?></td>
                        <td><?= number_format($key['cheque'], 2) ?></td>
                        <td style="text-align: center;">
                            <?= ($key['total_cot'] > 0) ? number_format(100 - (100 * ($key['facturado'] / $key['total_cot'])), 2) : '0.00' ?>
                        </td>
                    </tr>
            <?php
                }
            }
            ?>
            <tr>
                <td colspan="5" style="text-align: right;">Totales</td>
                <td><?= number_format($total_cot, 2) ?></td>
                <td><?= number_format($orden, 2) ?></td>
                <td><?= number_format($documento_prv, 2) ?></td>
                <td><?= number_format($facturado, 2) ?></td>
                <td><?= number_format($cheque, 2) ?></td>
                <td style="text-align: center;">
                    <?= $pendiente_facturado ?>
                </td>
            </tr>
        </tbody>
    </table>
<?php
} else {

?>
    <!--Datos de la grid-->
    <table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
        <thead>
            <tr>
                <th>No.</th>
                <th>Fecha</th>
                <th>Cliente</th>
                <th>Proyecto</th>
                <th>Estado</th>
                <th>Cotizado</th>
                <th>OC</th>
                <th>DPV</th>
                <th>Facturado</th>
                <th>Cheques</th>
                <th>
                    % Pendiente <br>de Facturar
                </th>
            </tr>
        </thead>
        <tbody>
            <?php
            if (count($proyectos) > 0) {

                $num_pro = 1;
                $registro = array();
                $total_cot = 0;
                $orden = 0;
                $documento_prv = 0;
                $facturado = 0;
                $cheque = 0;
                $pendiente_facturado = 0;

                foreach ($proyectos as $key) {
                    $fecha = formatear_fecha('d-m-Y', $key['pcl_fecha_creacion']);

                    $total_cot += ((trim($key['total_cot']) != '') ? $key['total_cot'] : 0);
                    $orden += $key['orden'];
                    $documento_prv += $key['documento_prv'];
                    $facturado += $key['facturado'];
                    $cheque += $key['cheque'];
                    $pendiente_facturado += ($key['total_cot'] > 0) ? number_format(100 - (100 * ($key['facturado'] / $key['total_cot'])), 2) : 0;
            ?>
                    <tr>
                        <td><?php echo $num_pro++; ?></td>
                        <td><?= $fecha ?></td>
                        <?php
                        if ($key['cli_personeria'] == 2) {
                        ?>
                            <td><?= $key['cli_codigo'] . '-' . $key['cli_apellido'] ?></td>
                        <?php
                        } else {
                        ?>
                            <td><?= $key['cli_codigo'] . '-' . $key['cli_nombre'] . ' ' . $key['cli_apellido'] ?></td>
                        <?php
                        }
                        ?>
                        <td><?= $key['pcl_codigo'] . ' ' . $key['pcl_nombre'] ?></td>
                        <td><?= $key['epr_nombre'] ?></td>
                        <td><?= number_format($key['total_cot'], 2) ?></td>
                        <td><?= number_format($key['orden'], 2) ?></td>
                        <td><?= number_format($key['documento_prv'], 2) ?></td>
                        <td><?= number_format($key['facturado'], 2) ?></td>
                        <td><?= number_format($key['cheque'], 2) ?></td>
                        <td style="text-align: center;">
                            <?= ($key['total_cot'] > 0) ? number_format(100 - (100 * ($key['facturado'] / $key['total_cot'])), 2) : '0.00' ?>
                        </td>
                    </tr>
            <?php
                }
            }
            ?>
        </tbody>
        <tfoot>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td>Totales</td>
            <td><?= number_format($total_cot, 2) ?></td>
            <td><?= number_format($orden, 2) ?></td>
            <td><?= number_format($documento_prv, 2) ?></td>
            <td><?= number_format($facturado, 2) ?></td>
            <td><?= number_format($cheque, 2) ?></td>
            <td style="text-align: center;">
                <?= $pendiente_facturado ?>
            </td>
        </tfoot>
    </table>
<?php } ?>