<script type="text/javascript">
  jQuery(document).ready(function($) {
    $("#select_cliente").select2();
    $(".reporte").hide();
    $("input[id^='fecha']").mask('99-99-9999');
    $("input[id^='fecha']").datepicker({
      dateFormat: 'dd-mm-yy',
      changeMonth: true,
      changeYear: true
    });
    $('#form_reporte').validate({
      ignore: null,
      ignore: 'input[type="hidden"]', //errorElement: "",
      rules: {},
      errorPlacement: function(error, element) {
        if ($(element).is("select")) {
          $(element).next().append(error);
        } else {
          error.insertAfter(element);
        }
      },
      submitHandler: function(form) {
        cargar_resultados();
      }
    });

  });

  function cargar_resultados() {
    $(".reporte").hide('slow');
    wait.start();
    $("#resultados").hide("slide", {
      direction: 'right'
    }, 400, function() {
      $.ajax({
        url: window.gSateliteWhite.baseUrl('cotizaciones/consultas/get_detallecompra_cliente'),
        type: 'post',
        data: {
          'desde': $("#fecha_desde").val(),
          'hasta': $("#fecha_hasta").val(),
          'cliente': $("#select_cliente").val()
        },
        success: function(data) {
          $("#desde").val($("#fecha_desde").val());
          $("#hasta").val($("#fecha_hasta").val());
          $("#cliente").val($("#select_cliente").val());
          $("#resultados").html(data);
          $(".reporte").show('slow');
          wait.close();
          $("#tabla_resultados tr").attr('style', 'font-size:12px;');
          $("#resultados").show("slide", {
            direction: 'left'
          }, 500);
        }
      });
    });

  }
</script>
<style type="text/css">
  .client_sele label.error {
    margin-top: 0px !important;
  }

  .span3 {
    min-width: 120px;
    max-width: 120px;
  }
</style>
<div class="row-fluid">
  <div class="span12">
    <div class="box">
      <div class="title">
        <h4>
          <span>Reporte de Compra Clientes</span>
        </h4>
      </div>
      <div class="content">
        <form method="post" id="form_reporte" name="form_reporte">
          <div class="form-row row-fluid">
            <div class="span12">
              <div class="row-fluid">
                <label class="form-label span3">Cliente:<b style="color:red;">*</b></label>
                <div class="span8 controls client_sele">
                  <select id="select_cliente" required class="nostyle" style="width:100%" name="select_cliente" placeholder="Seleccione">
                    <option value=""></option>
                    <?php
                    $select = $this->gsatelite->get_dropdown('cli_cliente', '{cli_codigo} - {cli_nombre} {cli_apellido}', '', array('cli_estado' => '1'), null, '', 'cli_id', true);
                    echo str_replace('<option value="0">Seleccione</option>', '', $select);
                    ?>
                  </select>
                </div>
              </div>
            </div>
          </div>
          <div class="form-row row-fluid">
            <div class="span12">
              <div class="row-fluid">
                <label class="form-label span3">Desde: <b style="color:red;">*</b></label>
                <div class="span8 controls">
                  <input type="text" required id="fecha_desde" name="fecha_desde" value="<?php echo ($this->input->post('fecha_desde')) ? $this->input->post('fecha_desde') : date('d-m-Y'); ?>">
                </div>
              </div>
            </div>
          </div>
          <div class="form-row row-fluid">
            <div class="span12">
              <div class="row-fluid">
                <label class="form-label span3">Hasta: <b style="color:red;">*</b></label>
                <div class="span8 controls">
                  <input type="text" required id="fecha_hasta" name="fecha_hasta" value="<?php echo ($this->input->post('fecha_hasta')) ? $this->input->post('fecha_hasta') : date('d-m-Y'); ?>">
                </div>
              </div>
            </div>
          </div>
          <div class="form-row row-fluid">
            <div class="span12">
              <div class="row-fluid">
                <button class="btn btn-info" type="submit" id="ver">
                  <span class="icon16 icomoon-icon-search-3 white"></span>
                  <strong>Consultar</strong>
                </button>
              </div>
            </div>
          </div>
          <div class="form-actions" style="text-align: right;">
            <!--<button class="btn btn-info" type="submit" id="ver">
              <span class="icon16 icomoon-icon-search-3 white"></span>
              <strong>Consultar</strong>
            </button>-->
            <button class="btn btn-info reporte" type="button" onclick="$('#tipo').val('1'); $('#print_reporte').submit();" id="excel">
              <span class="icon16 icomoon-icon-file-excel white"></span>
              <strong> Exportar a Excel</strong>
            </button>
            </a>
            <button class="btn btn-info reporte" type="button" onclick="$('#tipo').val('2'); $('#print_reporte').submit();" target="_blank" id="pdf">
              <span class="icon16 icomoon-icon-file-pdf white"></span>
              <strong> Exportar a PDF</strong>
            </button>
            <!--<a class="btn btn-info reporte" type="button"  onclick="$('#tipo').val('2'); $('#print_reporte').submit();" target="_blank" id="pdf"  >
              <span class="icon16 icomoon-icon-file-pdf white"></span>
              <strong> Exportar a PDF</strong>
            </a>-->
          </div>
        </form>
        <div id="resultados">
          <!-- Reporte -->
        </div>
      </div>
    </div>
  </div>
</div>
<form style="display:none;" id="print_reporte" method="post" target="_blank" action="<?php echo base_url('cotizaciones/consultas/get_detallecompra_cliente'); ?>">
  <input type="text" id="desde" name="desde">
  <input type="text" id="hasta" name="hasta">
  <input type="text" id="cliente" name="cliente">
  <input type="tipo" id="tipo" name="tipo">
</form>