<?php
if ($tipo_reporte == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
?>
    <table>
        <thead>
            <tr>
                <th colspan="9" rowspan="2" style="font-size: 15px">Detallado de cotizaciones por proyecto</th>
            </tr>
        </thead>
    </table>
    <br>
<?php
}
$tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
if ($tipo_reporte != 'grid') {
    $periodo = formatear_fecha('d-m-Y', $fecha_ini) . " / " . formatear_fecha('d-m-Y', $fecha_fin);
?>
    <style type="text/css">
        .tabla {
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }

        th {
            font-weight: bold !important;
        }

        td {
            font-family: arial;
        }

        .fuente_titulo {
            font-family: <?php echo $tipo_fuente; ?>;
        }
    </style>
    <table>
        <tr>
            <td style="text-align: left;" colspan="2"><b>Período:</b></td>
            <td style="text-align: left;" colspan="3"><?php echo $periodo; ?></td>
            <td style="text-align: left;" colspan="2"><b>Cliente:</b></td>
            <td style="text-align: left;" colspan="2"><?php echo $cliente; ?></td>
        </tr>
        <tr>
            <td style="text-align: left;" colspan="2"><b>Proyecto:</b></td>
            <td style="text-align: left;" colspan="3"><?php echo $pro; ?></td>
        </tr>
    </table>
    <br><br>
    <table border="1" width="100%">
        <tr>
            <th width="3%">No.</th>
            <th width="8%">Cotización</th>
            <th>Cod. Producto</th>
            <th width="19%">Producto</th>
            <th>Cantidad</th>
            <th>Precio Unitario</th>
            <th>Sub-total</th>
            <th>Descuentos</th>
            <th>Impuestos</th>
            <th>Total</th>
        </tr>
        <tbody>
            <?php
            $i = 1;
            $subtotal_global = 0.00;
            $descuento_global = 0.00;
            $impuesto_global = 0.00;
            $total_global = 0.00;
            if (count($proyectos) > 0) {
                $num_pro = 1;
                $registro = array();
                foreach ($proyectos as $key) {
            ?>
                    <tr>
                        <td><?php echo $num_pro++; ?></td>
                        <td><?= $key['cot_codigo'] ?></td>
                        <td><?= $key['art_codigo'] ?></td>
                        <td><?= $key['art_nombre'] ?></td>
                        <td><?= number_format($key['axc_cantidad'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['axc_precio'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['axc_subtotal'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['descuento'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['axc_impuesto'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['axc_total'], 2) ?></td>
                    </tr>
                <?php
                    $subtotal_global = $subtotal_global + $key['axc_subtotal'];
                    $descuento_global = $descuento_global + $key['descuento'];
                    $impuesto_global = $impuesto_global + $key['axc_impuesto'];
                    $total_global = $total_global + $key['axc_total'];
                    $i++;
                }
            } else {
                ?>
                <tr>
                    <td colspan="10" style="text-align: center">No se encontraron registros</td>
                </tr>
            <?php
            }
            ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="6" style="text-align: center"><strong>Totales</strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($subtotal_global, 2); ?></strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($descuento_global, 2); ?></strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($impuesto_global, 2); ?></strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($total_global, 2); ?></strong></td>
            </tr>
        </tfoot>
    </table>
<?php
} else {

?>
    <!--Datos de la grid-->
    <table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
        <thead>
            <tr>
                <th>No.</th>
                <th>Cotización</th>
                <th>Cod. Producto</th>
                <th>Producto</th>
                <th>Cantidad</th>
                <th>Precio unitario</th>
                <th>Sub-total</th>
                <th>Descuentos</th>
                <th>Impuestos</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $i = 1;
            $subtotal_global = 0.00;
            $descuento_global = 0.00;
            $impuesto_global = 0.00;
            $total_global = 0.00;
            if (count($proyectos) > 0) {
                $num_pro = 1;
                $registro = array();
                foreach ($proyectos as $key) {
                    $fecha = formatear_fecha('d-m-Y', $key['cot_fecha']);
            ?>
                    <tr>
                        <td><?php echo $num_pro++; ?></td>
                        <td><?= $key['cot_codigo'] ?></td>
                        <td><?= $key['art_codigo'] ?></td>
                        <td><?= $key['art_nombre'] ?></td>
                        <td><?= number_format($key['axc_cantidad'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['axc_precio'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['axc_subtotal'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['descuento'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['axc_impuesto'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['axc_total'], 2) ?></td>
                    </tr>
            <?php
                    $subtotal_global = $subtotal_global + $key['axc_subtotal'];
                    $descuento_global = $descuento_global + $key['descuento'];
                    $impuesto_global = $impuesto_global + $key['axc_impuesto'];
                    $total_global = $total_global + $key['axc_total'];
                    $i++;
                }
            }
            ?>
        </tbody>
        <tfoot>
            <tr>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td style="text-align: center"><strong>Totales</strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($subtotal_global, 2); ?></strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($descuento_global, 2); ?></strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($impuesto_global, 2); ?></strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($total_global, 2); ?></strong></td>
            </tr>
        </tfoot>
    </table>
<?php } ?>