<?php
if ($tipo_reporte == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}

$tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
if ($tipo_reporte != 'grid') {
?>
    <style type="text/css">
        .tabla {
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }

        th {
            font-weight: bold !important;
        }

        td {
            font-family: arial;
        }

        .fuente_titulo {
            font-family: <?php echo $tipo_fuente; ?>;
        }
    </style>
    <?php if ($tipo_reporte == 'excel') {
    ?>
        <table>
            <thead>
                <tr>
                    <th colspan="11">Consolidado de cotizaciones por proyecto</th>
                </tr>
            </thead>
        </table>
        <br>
    <?php
    }
    ?>
    <table border="1" width="100%">
        <tr>
            <th width="3%">No.</th>
            <th width="8%">Cotizaci&oacute;n</th>
            <th width="8%">Fecha</th>
            <th>Estado de cotizaci&oacute;n</th>
            <th width="15%">Cliente</th>
            <th width="16%">Proyecto</th>
            <th>Estado de proyecto</th>
            <th width="8%">Sub-total</th>
            <th width="8%">Descuentos</th>
            <th width="8%">Impuestos</th>
            <th width="8%">Total</th>
        </tr>
        <tbody>
            <?php
            $i = 1;
            $subtotal_global = 0.00;
            $descuento_global = 0.00;
            $impuesto_global = 0.00;
            $total_global = 0.00;
            if (count($proyectos) > 0) {
                $num_pro = 1;
                $registro = array();
                foreach ($proyectos as $key) {
                    $fecha = formatear_fecha('d-m-Y', $key['cot_fecha']);
            ?>
                    <tr>
                        <td><?php echo $num_pro++; ?></td>
                        <td><?= $key['cot_codigo'] ?></td>
                        <td><?= $fecha ?></td>
                        <td><?= $key['est_nombre'] ?></td>
                        <?php
                        if ($key['cli_personeria'] == 2) {
                        ?>
                            <td><?= $key['cli_codigo'] . '-' . $key['cli_apellido'] ?></td>
                        <?php
                        } else {
                        ?>
                            <td><?= $key['cli_codigo'] . '-' . $key['cli_nombre'] . ' ' . $key['cli_apellido'] ?></td>
                        <?php
                        }
                        ?>
                        <td><?= $key['pcl_codigo'] . '-' . $key['pcl_nombre'] ?></td>
                        <td><?= $key['epr_nombre'] ?></td>
                        <td><?= $simbolo ?><?= number_format($key['subtotal'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['descuento'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['impuesto'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['total'], 2) ?></td>
                    </tr>
                <?php
                    $subtotal_global = $subtotal_global + $key['subtotal'];
                    $descuento_global = $descuento_global + $key['descuento'];
                    $impuesto_global = $impuesto_global + $key['impuesto'];
                    $total_global = $total_global + $key['total'];
                    $i++;
                }
            } else {
                ?>
                <tr>
                    <td colspan="11" style="text-align: center">No se encontraron registros</td>
                </tr>
            <?php
            }
            ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="7" style="text-align: center"><strong>Totales</strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($subtotal_global, 2); ?></strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($descuento_global, 2); ?></strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($impuesto_global, 2); ?></strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($total_global, 2); ?></strong></td>
            </tr>
        </tfoot>
    </table>
<?php
} else {

?>
    <!--Datos de la grid-->
    <table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
        <thead>
            <tr>
                <th>No.</th>
                <th>Cotizaci&oacute;n</th>
                <th>Fecha</th>
                <th>Estado de cotizaci&oacute;n</th>
                <th>Cliente</th>
                <th>Proyecto</th>
                <th>Estado de proyecto</th>
                <th>Sub-total</th>
                <th>Descuentos</th>
                <th>Impuestos</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $i = 1;
            $subtotal_global = 0.00;
            $descuento_global = 0.00;
            $impuesto_global = 0.00;
            $total_global = 0.00;
            if (count($proyectos) > 0) {
                $num_pro = 1;
                $registro = array();
                foreach ($proyectos as $key) {
                    $fecha = formatear_fecha('d-m-Y', $key['cot_fecha']);
            ?>
                    <tr>
                        <td><?php echo $num_pro++; ?></td>
                        <td><?= $key['cot_codigo'] ?></td>
                        <td><?= $fecha ?></td>
                        <td><?= $key['est_nombre'] ?></td>
                        <?php
                        if ($key['cli_personeria'] == 2) {
                        ?>
                            <td><?= $key['cli_codigo'] . '-' . $key['cli_apellido'] ?></td>
                        <?php
                        } else {
                        ?>
                            <td><?= $key['cli_codigo'] . '-' . $key['cli_nombre'] . ' ' . $key['cli_apellido'] ?></td>
                        <?php
                        }
                        ?>
                        <td><?= $key['pcl_codigo'] . '-' . $key['pcl_nombre'] ?></td>
                        <td><?= $key['epr_nombre'] ?></td>
                        <td><?= $simbolo ?><?= number_format($key['subtotal'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['descuento'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['impuesto'], 2) ?></td>
                        <td><?= $simbolo ?><?= number_format($key['total'], 2) ?></td>
                    </tr>
            <?php
                    $subtotal_global = $subtotal_global + $key['subtotal'];
                    $descuento_global = $descuento_global + $key['descuento'];
                    $impuesto_global = $impuesto_global + $key['impuesto'];
                    $total_global = $total_global + $key['total'];
                    $i++;
                }
            }
            ?>
        </tbody>
        <tfoot>
            <tr>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td style="text-align: center"><strong>Totales</strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($subtotal_global, 2); ?></strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($descuento_global, 2); ?></strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($impuesto_global, 2); ?></strong></td>
                <td><strong><?= $simbolo ?><?php echo number_format($total_global, 2); ?></strong></td>
            </tr>
        </tfoot>
    </table>
<?php } ?>