<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

$cliente = "";
if ($cotizacion['cli_personeria'] == 1) {
    $cliente = $cotizacion['cli_nombre'] . " " . $cotizacion['cli_apellido'];
} else {
    $cliente = $cotizacion['cli_nombre'];
}
?>
<table border="0">
    <tr>
        <th width="14%"><b>Cliente:</b></th>
        <th width="45%"><?= $cliente ?></th>
        <th width="11%"><b>Cotizacion:</b></th>
        <th width="30%"><?= $cotizacion['cot_codigo'] ?></th>
    </tr>
    <tr>
        <th><b>Producto:</b></th>
        <th><?php echo $producto['art_codigo'] . ' - ' . $producto['art_nombre']; ?></th>
        <th><b>Fecha:</b></th>
        <th><?php echo formatear_fecha("d-m-Y H:i:s", $cotizacion['cot_fecha']); ?></th>
    </tr>
    <tr>
        <th><b>Cantidad Artículos:</b></th>
        <th><?php echo number_format($producto['axc_cantidad'], 2); ?></th>
        <th><b>Presentación:</b></th>
        <th><?php echo $producto['mep_nombre']; ?></th>
    </tr>
    <tr>
        <th colspan="4"></th>
    </tr>
</table>
<br>
<br>
<table width="100%" border="1">
    <thead style="text-align:center">
        <tr>
            <td colspan="8"><b>MATERIA PRIMA</b></td>
        </tr>
        <tr>
            <th>Descripcion del producto</th>
            <th>Unidad de Medida</th>
            <th>Cantidad Unitaria</th>
            <th>Cantidad Articulos</th>
            <th>Cantidad Total</th>
            <th>Proveedor</th>
            <th>Precio Unitario</th>
            <th>Total</th>
        </tr>
    </thead>
    <tbody>
        <?php
        if (count($materia_prima_prod) > 0) :
            foreach ($materia_prima_prod as $axr) :
                $cantidadMateria = (isset($axr['axr_id']) && $axr['axr_id'] != null) ? ($axr['axr_cantidad'] / $producto['axc_cantidad']) : $axr['mpa_cantidad'];
                $nombre_proveedor = ($axr['prv_nombre'] != "") ? $axr['prv_nombre'] : '---';
                $nombre_proveedor .= ($axr['prv_tipo_pers'] == 1) ? ' ' . $axr['prv_apellido'] : "";
                if (isset($axr['axr_precio']) && $axr['axr_precio'] != '' && $axr['axr_precio'] > 0) {
                    $valor = $axr['axr_precio'];
                } elseif ($axr['tipos_precio'] != '' && $axr['tipos_precio'] > 0) {
                    $valor = $axr['tipos_precio'];
                } else {
                    $valor = $axr['mpa_precio'];
                }
                $precioMateria = $valor;
                $ctdad_total = $cantidadMateria * $producto['axc_cantidad'];
                $subtotalMateriaPrima = (($cantidadMateria * $precioMateria) > 0) ? $ctdad_total * $precioMateria : 0.00;
                $totalMateriaPrima += $subtotalMateriaPrima;
        ?>
                <tr>
                    <td><?php echo $axr['art_codigo'] . ' - ' . $axr['art_nombre']; ?></td>
                    <td><?php echo $axr['mep_nombre']; ?></td>
                    <td style="text-align: right;"><?php echo number_format($cantidadMateria, 6, '.', ''); ?></td>
                    <td style="text-align: right;"><?php echo $producto['axc_cantidad']; ?></td>
                    <td style="text-align: right;"><?php echo number_format($ctdad_total, 6, '.', ''); ?></td>
                    <td><?php echo $nombre_proveedor; ?></td>
                    <td style="text-align: right;"><?php echo $imbolo . number_format((($precioMateria > 0) ? $precioMateria : 0), 6, '.', ','); ?></td>
                    <td style="text-align: right;"><?php echo $imbolo . number_format($subtotalMateriaPrima, 6, '.', ','); ?></td>
                </tr>
        <?php
            endforeach;
        endif;
        ?>
    </tbody>
    <tfoot>
        <tr>
            <td colspan="7">Subtotal</td>
            <td style="text-align: right;"><?= $simbolo ?><?php echo number_format($totalMateriaPrima, 6, '.', ','); ?></td>
        </tr>
    </tfoot>
</table>
<br>
<br>
<br>
<table width="100%" border="1">
    <thead style="text-align:center">
        <tr>
            <td colspan="6"><b>MANO DE OBRA</b></td>
        </tr>
        <tr>
            <td>Descripcion</td>
            <td>Cantidad por Artículo</td>
            <td>Costo Unitario</td>
            <td>Costo por Artículo</td>
            <td>Cantidad Artículos</td>
            <td>Costo Total</td>
        </tr>
    </thead>
    <tbody>
        <?php
        if (count($mano_obra_prod) > 0) :
            foreach ($mano_obra_prod as $mxa) :
                $mano_obra_nombre = $mxa['mob_codigo'] . ' - ' . $mxa['mob_nombre'];
                $cantidadMob = (isset($mxa['mxa_id']) && $mxa['mxa_id'] != null) ? ($mxa['mxa_cantidad'] / $producto['axc_cantidad']) : $mxa['moa_cantidad'];
                $precioMob = (isset($mxa['mxa_id']) && $mxa['mxa_id'] != null) ? $mxa['mxa_precio'] : $mxa['mob_precio'];
                $subtotalMob = ($precioMob * $cantidadMob);
                $total_art = ($subtotalMob * $producto['axc_cantidad']);
                $totalMob += $total_art;
        ?>
                <tr>
                    <td><?php echo $mano_obra_nombre; ?></td>
                    <td style="text-align: right;"><?php echo $cantidadMob; ?></td>
                    <td style="text-align: right;"><?= $simbolo ?><?php echo number_format($precioMob, 6, '.', ','); ?></td>
                    <td style="text-align: right;"><?= $simbolo ?><?php echo number_format($subtotalMob, 6, '.', ','); ?></td>
                    <td style="text-align: right;"><?php echo $producto['axc_cantidad']; ?></td>
                    <td style="text-align: right;"><?= $simbolo ?><?php echo number_format($total_art, 6, '.', ','); ?></td>
                </tr>
        <?php
            endforeach;
        endif;
        ?>
    </tbody>
    <tfoot>
        <tr>
            <td colspan="5">Subtotal</td>
            <td style="text-align: right;"><?= $simbolo ?><?php echo number_format($totalMob, 6, '.', ','); ?></td>
        </tr>
    </tfoot>
</table>
<br>
<br>
<br>
<table width="100%" border="1">
    <thead style="text-align:center">
        <tr>
            <td colspan="5"><b>GASTOS INDIRECTOS DE FABRICACIÓN</b></td>
        </tr>
        <tr>
            <th>Descripcion</th>
            <th>Tipo de Calculo</th>
            <th>Cantidad</th>
            <th>Costo Unitario</th>
            <th>Costo Total</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $sumas_otros = 0;
        if (count($gastos_indirectos) > 0) :
            foreach ($gastos_indirectos as $exa) :
                $nombre_estimacion = $exa['esm_codigo'] . ' - ' . $exa['esm_nombre'];
                $precio_gasto = (isset($exa['exa_id']) && $exa['exa_id'] != null) ? $exa['exa_precio'] : $exa['esr_precio'];
                $gastos_indirectos_n = $exa['esm_tipo_calculo'];
                $gastos_indi = ($exa['esm_tipo_calculo'] == 0) ? 'Porcentaje' : 'Monto';
                $signo = "";
                if ($gastos_indirectos_n == 1) :
                    $cantidad_gasto = (isset($exa['exa_id']) && $exa['exa_id'] != null) ? $exa['exa_cantidad'] : ($exa['esr_cantidad'] * $producto['axc_cantidad']);
                    $signo = "$";
                    $subtotalGasto = ($cantidad_gasto * $precio_gasto);
                else :
                    if (!(isset($exa['exa_id']) && $exa['exa_id'] != null) && $exa['art_total_gastos'] != "") {
                        $gif_rcta = ($exa['art_total_gastos'] * $producto['axc_cantidad']);
                    } elseif (!(isset($exa['exa_id']) && $exa['exa_id'] != null) && $exa['esr_monto_calculo'] != "") {
                        $gif_rcta = ($exa['esr_monto_calculo'] * $producto['axc_cantidad']);
                    } else {
                        $gif_rcta = ($exa['esr_precio'] * $producto['axc_cantidad']);
                    }
                    $cantidad_gasto = (isset($exa['exa_id']) && $exa['exa_id'] != null) ? $exa['exa_cantidad'] : ($exa['esr_cantidad'] * $producto['axc_cantidad']);
                    $subtotalGasto = (isset($exa['exa_id']) && $exa['exa_id'] != null) ? $exa['exa_monto_calculo'] : $gif_rcta;
                    $signo = "%";
                endif;
                $precio  = ($signo == "$") ? $signo : "";
                $precio .= $precio_gasto;
                $precio .= ($signo == "%") ? $signo : "";
        ?>
                <tr>
                    <td><?php echo $nombre_estimacion; ?></td>
                    <td><?php echo $gastos_indi; ?></td>
                    <td style="text-align: right;"><?php echo $cantidad_gasto; ?></td>
                    <td style="text-align: right;"><?php echo $precio; ?></td>
                    <td style="text-align: right;"><?= $simbolo ?><?php $sumas_otros += $subtotalGasto;
                                                                    echo number_format($subtotalGasto, 6, ".", ","); ?></td>
                </tr>
        <?php
            endforeach;
        endif;
        ?>
    </tbody>
    <tfoot>
        <tr>
            <td colspan="4">Subtotal</td>
            <td style="text-align: right;"><?= $simbolo ?><?php echo number_format($sumas_otros, 6, ".", ","); ?></td>
        </tr>
    </tfoot>
</table>
<br>
<br>
<br>
<table border="0" style="text-align: right;">
    <tr>
        <td width="60%"></td>
        <td width="40%" style="border: 1px solid black; text-align: left;"><b>TOTAL</b></td>
    </tr>
    <tr>
        <td width="60%"></td>
        <td width="20%" style="border: 1px solid black;">Materia Prima:</td>
        <td width="20%" style="border: 1px solid black;"><?= $simbolo ?><?php echo  number_format($totalMateriaPrima, 2, '.', ',');  ?></td>
    </tr>
    <tr>
        <td width="60%"></td>
        <td width="20%" style="border: 1px solid black;">Mano de Obra:</td>
        <td width="20%" style="border: 1px solid black;"><?= $simbolo ?><?php echo number_format($totalMob, 2, '.', ','); ?></td>
    </tr>
    <tr>
        <td width="60%"></td>
        <td width="20%" style="border: 1px solid black;">Gastos Indirectos:</td>
        <td width="20%" style="border: 1px solid black;"><?= $simbolo ?><?php echo number_format($sumas_otros, 2, ".", ","); ?></td>
    </tr>
    <?php $totaCot = $totalMateriaPrima + $totalMob + $sumas_otros; ?>
    <tr>
        <td width="60%"></td>
        <td width="20%" style="border: 1px solid black;"><b>Total:</b></td>
        <td width="20%" style="border: 1px solid black;"><b><?= $simbolo ?><?php echo number_format($totaCot, 2, ".", ","); ?></b></td>
    </tr>
    <tr>
        <td width="60%"></td>
        <td width="20%" style="border: 1px solid black;">Costo Unitario:</td>
        <td width="20%" style="border: 1px solid black;"><?= $simbolo ?><?php echo number_format(($totaCot / $producto['axc_cantidad']), 2, ".", ",");  ?> </td>
    </tr>
</table>