<?php

header("Content-type: application/vnd.ms-excel; name='Reporte_General_de_Cotizaciones'");
header("Content-Disposition: filename=Reporte_General_de_Cotizaciones.xls");
header("Pragma: no-cache");
header("Expires: 0");

?>
<meta charset="utf-8" />
<style type='text/css'>
  body {
    font-family: Arial;
    font-size: 14px;
  }

  a {
    color: blue;
    text-decoration: none;
    font-size: 14px;
  }

  a:hover {
    text-decoration: underline;
  }
</style>
<div class="row-fluid principal">
  <div class="span12">
    <div class="box">
      <div class="title">

        <h4>
          Reporte General de Cotizaciones
        </h4>

      </div>

      <div class="content">

        <div>

          <?php if (isset($datosCotizaciones)) { //preguntar si existe la variable del reporte 
            $meses = array(" ", "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");

            if (!isset($error)) {     ?>

              <div>
                <table style="border-bottom:10px double #9BBB59;border-top:1px solid #9BBB59;border-left:1px solid #9BBB59;border-right:1px solid #9BBB59;" border=1 width=100%>
                  <tr style="font-size:12px; background:#9BBB59;">
                    <th style="border:1px solid #9BBB59; color:white">A&Ntilde;O</th>
                    <th style="border:1px solid #9BBB59; color:white">MES</th>
                    <th style="border:1px solid #9BBB59; color:white">VENDEDOR</th>
                    <th style="border:1px solid #9BBB59; color:white">FECHA CREACIÓN</th>
                    <th style="border:1px solid #9BBB59; color:white">FECHA PRESENTACIÓN COTIZACIÓN</th>
                    <th style="border:1px solid #9BBB59; color:white">FECHA ÚLTIMO CONTACTO</th>
                    <th style="border:1px solid #9BBB59; color:white">CLIENTE</th>
                    <th style="border:1px solid #9BBB59; color:white">PRODUCTO</th>
                    <th style="border:1px solid #9BBB59; color:white">SEGMENTO</th>
                    <th style="border:1px solid #9BBB59; color:white">COTIZADO NETO</th>
                    <th style="border:1px solid #9BBB59; color:white">CERRADO</th>
                    <th style="border:1px solid #9BBB59; color:white">% COMISI&Oacute;N</th>
                    <th style="border:1px solid #9BBB59; color:white">COMISI&Oacute;N APROX.</th>
                    <th style="border:1px solid #9BBB59; color:white">ETAPA</th>
                    <th style="border:1px solid #9BBB59; color:white">ESTADO</th>
                    <th style="border:1px solid #9BBB59; color:white">PRECIO PERDIDO</th>
                    <th style="border:1px solid #9BBB59; color:white">EMPRESA GANO</th>
                    <th style="border:1px solid #9BBB59; color:white">FECHA CIERRE</th>
                    <th style="border:1px solid #9BBB59; color:white">CONTACTOS</th>
                    <th style="border:1px solid #9BBB59; color:white">DIAS TRANSCURRIDOS</th>
                    <th style="border:1px solid #9BBB59; color:white">LINK COMPRASAL</th>
                    <th style="border:1px solid #9BBB59; color:white"> % PROBABILIDAD CIERRE </th>
                    <th style="border:1px solid #9BBB59; color:white"> FECHA POSIBLE CIERRE </th>
                    <th style="border:1px solid #9BBB59; color:white"> PLAN ACCIÓN</th>
                    <th style="border:1px solid #9BBB59; color:white;padding-left:90px;padding-right:90px;">COMENTARIOS</th>
                  </tr>

                  <?php $k = 1;
                  foreach ($datosCotizaciones->result() as $FilaCot) {
                    $fp = explode("-", $FilaCot->cot_fecha_pres);
                    $conta = $this->cotModel->contactosxCotizacion($FilaCot->cot_id);
                    $contactosC = "";

                    foreach ($conta->result() as $con) { //obtener los contactos de la cotizacion
                      $contactosC .= $con->con_nombre . " " . $con->con_apellidos . " - " . $con->con_cargo . " <br />";
                    }

                    //Obtener los seguimientos de la cotizacion
                    $seguimientoC = "-";
                    $seg = $this->cotModel->get_tabla("seg_seguimiento", "seg_id_cot", $FilaCot->cot_id, "seg_id", "ASC");
                    foreach ($seg->result() as $filaSeguimiento) {
                      $seguimientoC .= formatear_fecha('d-m-Y', $filaSeguimiento->seg_fecha) . ' / ' . $filaSeguimiento->seg_comentario . "";
                    }

                    $ganadaPerdida =  $this->cotModel->cotizacionGanadaPerdida($FilaCot->cot_id);
                    //variables que se imprimiran en el reporte
                    $porcentajeComision = "-";
                    $comisionAprox = "-";
                    $precioPer = "-";
                    $empresaGano = "-";
                    $fechaCierre = "-";

                    if ($ganadaPerdida[0] == 1) { // preguntar si es ganada
                      foreach ($ganadaPerdida[1]->result() as $g) {
                        $porcentajeComision = $g->cog_comision_real_p;
                        $comisionAprox = $g->cog_comision_real_d;
                        $fechaCierre = $g->cog_fecha_cierre;
                      }
                    } else if ($ganadaPerdida[0] == 2) { // preguntar si es perdida
                      foreach ($ganadaPerdida[1]->result() as $p) {
                        $precioPer = $p->per_precio;
                        $empresaGano = $p->per_empresa;
                        $fechaCierre = $p->per_fecha_perdido;
                      }
                    }


                    $diaTranscurridos = "0";
                    //preguntar por el estado de la cotizacion y saber si se le debe dar o no seguimiento
                    $seguir = $this->gsatelite->get_campo('est_estado_cotizacion', 'est_seguimiento', array('est_id' => $FilaCot->cot_id_est));
                    if ($seguir > 0) {
                      $date1 = date('Y-m-d H:i:s');
                      $date2 = $FilaCot->cot_ult_fecha_cont; //ultima fecha de contacto

                      $dias = (strtotime($date1) - strtotime($date2)) / 86400;
                      $ndias = floor($dias);

                      if ($ndias < 1) {
                        $diaTranscurridos = "0";
                      } else {
                        $diaTranscurridos = $ndias;
                      }
                    } else { //si el estado en que se encuentra no es de seguimiento retornar cero
                      $diaTranscurridos = "0";
                    }


                    $linkComprasal = "-";



                    //colorear los tr
                    $estilo = "font-size:11px; background: #EBF1DE; height:20px;";
                    if (($k % 2) == 0) {
                      $estilo = "font-size:11px; background: white; height:30px;";
                    }
                  ?>
                    <tr style="<?php echo $estilo; ?>">
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $fp[0]; ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $meses[intval(($fp[1]))]; ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $FilaCot->ven_nombre . " " . $FilaCot->ven_apellidos; ?>
                      </td>
                      <td valign="top">
                        <?php
                        echo date('d/m/Y H:i:s', strtotime($FilaCot->cot_fecha));
                        //echo substr($FilaCot->cot_fecha_pres,0,11);
                        ?>
                      </td>

                      <td valign="top" style="border:1px solid #9BBB59;">&nbsp;
                        <?php
                        echo date('d/m/Y H:i:s', strtotime($FilaCot->cot_fecha_pres));
                        //$f = explode("-", (substr($FilaCot->cot_fecha_pres,0,11)));
                        //$f = "$f[2]/$f[1]/$f[0]";
                        //echo $f ; 
                        ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">&nbsp;
                        <?php
                        $f = explode("-", (substr($FilaCot->cot_ult_fecha_cont, 0, 11)));
                        $f = "$f[2]/$f[1]/$f[0]";
                        echo $f;
                        ?>
                      </td>

                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $FilaCot->cli_nombre . " " . $FilaCot->cli_apellido; ?>
                      </td>

                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php /*echo str_replace(',', '<br />', $FilaCot->productos);*/ ?>
                        <?php echo $FilaCot->producto_nombre; ?>
                      </td>

                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $FilaCot->cac_nombre; ?>
                      </td>

                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $FilaCot->cot_total; ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php
                        $var = ($FilaCot->est_cerrada == 0) ? "No" : "Si";
                        echo $var; ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $porcentajeComision; ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $comisionAprox; ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $FilaCot->etp_nombre; ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $FilaCot->est_nombre; ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $precioPer; ?>

                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $empresaGano; ?>

                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php
                        if (strlen($fechaCierre) > 8) {
                          $f = explode("-", (substr($fechaCierre, 0, 11)));
                          $f = "$f[2]/$f[1]/$f[0]";
                          echo $f;
                        } else {
                          echo $fechaCierre;
                        }

                        ?>

                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $contactosC; ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $diaTranscurridos; ?>

                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $linkComprasal; ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $FilaCot->cot_probabilidad_cierre; ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo formatear_fecha('Y-m-d', $FilaCot->cot_fecha_cierre); ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $FilaCot->cot_plan_accion; ?>
                      </td>
                      <td valign="top" style="border:1px solid #9BBB59;">
                        <?php echo $seguimientoC; ?>

                      </td>
                    </tr>

                  <?php $k++;
                  } //FIN DE FOREACH 
                  ?>



                </table>
                <br />
              </div>
          <?php } else {
              echo '<span style="color:red;">Error:</span> La <i>Fecha inicio</i> no puede ser mayor a la <i>Fecha fin</i>';
            }
          } //fin condicion para preguntar si existe la variable para el reporte 
          ?>

        </div>
      </div>

    </div><!-- End .box -->


  </div>

</div>