<?php

/**
 * @author Elman Ortiz
 * @copyright 2017
 */
?>

<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="8" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de empleados por tipo de vivienda
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php if($tipo_reporte == 'pdf'):?>
<style type="text/css">
td { font-family: courier; font-size: 9px; }
</style>
<?php endif;?>

<?php if($tipo_reporte == 'pdf' OR $tipo_reporte == 'excel'):?>
<table border="0" width="100%">
  <tr>    
    <td><?php echo $hslcClientetext;?></td>
    <td><?php echo $hslcSeguimientoPortext;?></td>
    <!-- <td><?php echo $municipiotext;?></td> -->
  </tr>
</table>
<?php endif;?>

<table border="1px" id="tblListado" class="dynamicTable responsive display table table-bordered"  aria-describedby="table_2_info">
  <thead >
    <tr>        
      <th>COD. COTIZACION</th>
      <th>CLIENTE</th>
      <th>CONTACTO</th>
      <th>TEL. CONTACTO</th>
      <th>FECHA SEG.</th>
      <th>COMENTARIO</th>                        
      <th>PROX. SEG</th>                                    
      <th>TIPO SEG.</th>                                                                    
      <th>PRODUCTO</th>                                                                    
      <th>CANTIDAD</th>                                                                    
      <th>MONTO</th>                                                                            
    </tr>
  </thead>
  <tbody>
    <?php if(count($reporte) > 0){?>
      <?php foreach ($reporte as $key => $rep) { ?>
        <tr nobr="true">                          
            <td><?php echo $rep['codigo_cotizacion']?></td>
            <td><?php echo $rep['cli_nombre']?></td>
            <td><?php echo $rep['nombre_contacto']?></td>
            <td><?php echo $rep['telefono_contacto']?></td>
            <td><?php echo $rep['fecha_seguimiento']?></td>
            <td><?php echo $rep['comentario']?></td>
            <td><?php echo $rep['fecha_proximo_seguimiento']?></td>
            <td><?php echo $rep['tipo_seguimiento']?></td>
            <td><?php echo ($rep['producto'] != '')?'--'.$rep['producto']: '';?></td>
            <td><?php echo ($rep['producto'] != '')?'--'.$rep['cantidad']: '';?></td>
            <td><?php echo $rep['monto']?></td>                                          
        </tr>
      <?php }?>
    <?php }else{?>
      <?php if($tipo_reporte == 'pdf' || $tipo_reporte == 'excel'){?>
        <tr nobr="true">
          <td colspan="11" align="center">No se encontraron registros</td>
        </tr>
      <?php }?>
    <?php }?>
  </tbody> 
</table>