<meta charset="utf-8" />
<script type="text/javascript">
    jQuery(document).ready(function($) {
        $("#accion_botones").hide();
        $("#fecha1, #fecha2").keypress(function(event) {
            key = event.keyCode || event.which;
            if (key == 13) {
                $("#consultar_datos").trigger("click");
            }
        });

        window.gSateliteWhite.jsSelect();
        $(".fecha_filtro").datepicker({
            dateFormat: 'dd-mm-yy',
            changeMonth: true,
            changeYear: true
        });
        $(".fecha_filtro").mask('99-99-9999');
        $("#tipo_filtro").change(function(event) {
            mostrarElemento($(this).val());
        });

        $(".fecha_filtro").change(function(event) {
            tipo = $("#tipo_filtro").val();
            if (tipo == 'cot_fecha_pres') {
                fini = $("#fecha1").val();
                ffin = $("#fecha2").val();
            } else {
                fini = $("#" + tipo + "f1").val();
                ffin = $("#" + tipo + "f2").val();
            }
            if (fini != "" && ffin != "") {
                let pasa = verifica_fechas(fini, ffin);
                if (!pasa && tipo != 'cot_fecha_pres') {
                    $("#" + tipo + "f2").val("");
                }
            }
        });

        $("#consultar_datos").click(function(event) {
            if ($("#tipo_filtro").val() != "" && $("#tipo_filtro").val() != null) {
                tipo = $("#tipo_filtro").val();
                if ($("#" + tipo).is("input")) {
                    /* 99.99% FALSE */
                    if ($("#" + tipo).val() != "") {
                        consultarAjax(tipo, $("#" + tipo).val(), null);
                    } else {
                        $("#validar_valor").text('Campo requerido');
                    }
                } else {
                    if (tipo == 'cot_fecha_pres') {
                        if ($("#fecha1").val() != "" && $("#fecha2").val() != "") {
                            if (verifica_fechas($("#fecha1").val(), $("#fecha2").val())) {
                                var fechas = $("#fecha1").val() + "#" + $("#fecha2").val();
                                consultarAjax(tipo, fechas, null);
                            }
                        } else {
                            $("#validar_valor").text('Campo requerido');
                        }
                    } else {
                        //es un div con select
                        if ($("#select_" + tipo).val() != "") {
                            let fc1 = ($("#" + tipo + "f1").val() != undefined) ? $("#" + tipo + "f1").val() : "";
                            let fc2 = ($("#" + tipo + "f2").val() != undefined) ? $("#" + tipo + "f2").val() : "";
                            var data_fechas = fc1 + "#" + fc2;
                            consultarAjax(tipo, $("#select_" + tipo).val(), data_fechas);
                        } else {
                            $("#validar_valor").text('Campo requerido');
                        }
                    }
                }
            } else {
                $("#validar_filtro").text('Campo requerido');
            }
        });

    });

    function mostrarElemento(id_element) {
        if (id_element != "") {
            id_elemento = id_element;
        } else {
            id_elemento = 'nada';
        }
        var mostrar = "#" + id_elemento;
        var elementos = "#nada,#cot_fecha_pres,#cot_id_ven,#cot_id_cli, #cli_id_sec, #cli_id_cac, #cli_id_cfc,#categorias,#todos_los_registros";
        var excluir = elementos.replace(mostrar, "#noexiste");
        if (id_elemento == 'nada' || id_elemento == 'todos_los_registros') {
            $('#validar_valor').text('');
        }
        $(excluir).hide('slow');
        $(mostrar).show('slow');
    }

    function consultarAjax(filtro, valor, otra_data) {
        wait.start();
        otra_data = (otra_data != null) ? otra_data : "#";
        $("#consultar_datos").attr('disabled', 'disabled');
        $("#accion_botones").hide('slow');
        $("#contenedorTabla").hide("slide", {
            direction: 'right'
        }, 400, function() { //despues de ocultar div enviar el ajax
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('cotizaciones/consultas/filtro_reporte_cotizaciones'),
                data: {
                    'filtro': filtro,
                    'valor': valor,
                    'extra': otra_data
                },
                success: function(data) {
                    $("#filtro_hidden").val(filtro); //valor que será utilizado para el print y export
                    $("#filtro_valor_hidden").val(valor); // valor que será utilizado para el print y export
                    $("#filtro_extra_hidden").val(otra_data); // valor que será utilizado para el print y export
                    $("#contenedorTabla").html(data.resultado);
                    $("#consultar_datos").removeAttr('disabled');
                    $("#tabla_consulta").dataTable();
                    $("#accion_botones").show('slow');
                    wait.close(); ///////////////////////////////
                    // $(".edit_ficha").tooltip();
                    $("#contenedorTabla").show("slide", {
                        direction: 'left'
                    }, 500);
                }
            });
        });
    }

    function verifica_fechas(fecha_ini, fecha_fin) {
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
            crear_alerta("error", "Verifique las fechas del período");
            return false;
        } else {
            return true;
        }
    }
</script>

<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4 style="text-align:center;">FILTRO PARA CONSULTAR COTIZACIONES</h4>
            </div>
            <div class="content clearfix">
                <form style="overflow-y: auto;" method="post" id="consultaform" name="consultaform">
                    <table class="table table-bordered">
                        <thead>
                            <tr style="font-size:13px;">
                                <th id="tdFiltro" width="32%">Buscar por</th>
                                <th>Criterio de Búsqueda</th>
                                <th width="25%">&nbsp;</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="vertical-align: top !important;">
                                    <div>
                                        <select name="tipo_filtro" id="tipo_filtro" onchange="$('#validar_filtro').text('');" class="nostyle" style="width:300px;" placeholder="Seleccionar filtro">
                                            <option value=""></option>
                                            <option value="todos_los_registros">Todas las Cotizaciones</option>
                                            <option value="cot_fecha_pres">Por Fecha de Presentación</option>
                                            <option value="cot_id_ven">Por Vendedor</option>
                                            <option value="cot_id_cli">Por Cliente</option>
                                            <option value="categorias">Por Categoría</option>
                                            <option value="cli_id_sec">Sector Cliente</option>
                                            <option value="cli_id_cac">Segmento Cliente</option>
                                            <option value="cli_id_cfc">Clasificación Cliente</option>
                                        </select>
                                    </div>
                                    <span id="validar_filtro" style="color:red;font-size:11px;"></span>
                                </td>
                                <td style="vertical-align: top !important;">
                                    <div id="nada" style="width:100%;"><?php //OPTION VACIA 
                                                                        ?>
                                        <input style="width:100%;" id="inada" name="inada" placeholder="Seleccione filtro" readonly type="text">
                                    </div>
                                    <div>
                                        <input style="display:none; width:89%;" onkeyup="$('#validar_valor').text('');" id="clc_nit" name="clc_nit" placeholder="NIT" type="text">
                                        <input style="display:none; width:89%;" onkeyup="$('#validar_valor').text('');" id="clc_dui" name="clc_dui" placeholder="DUI" type="text">
                                        <input style="display:none; width:89%;" onkeyup="$('#validar_valor').text('');" id="clc_nombre" name="clc_nombre" placeholder="Nombre" type="text">
                                        <input style="display:none; width:89%;" onkeyup="$('#validar_valor').text('');" id="clc_apellido" name="clc_apellido" placeholder="Apellido" type="text">
                                    </div>
                                    <div style="display:none;" id="cot_fecha_pres" style="width:100%;"><?php //POR FECHA DE PRESENTACION 
                                                                                                        ?>
                                        <div style="width:100%; padding: 1px;">
                                            <input id="fecha1" name="fecha1" class="fecha_filtro" onchange="$('#validar_valor').text('');" style="width:44%;" placeholder="Fecha desde" type="text" value="<?php echo date('d-m-Y'); ?>">
                                            <input id="fecha2" name="fecha2" class="fecha_filtro" onchange="$('#validar_valor').text('');" style="width:44%;" placeholder="Fecha hasta" type="text" value="<?php echo date('d-m-Y'); ?>">
                                        </div>
                                    </div>
                                    <div id="cot_id_ven" style="display:none; width:100%;"><?php //POR VENDEDOR 
                                                                                            ?>
                                        <div style="width:100%; padding: 1px;">
                                            <select name="select_cot_id_ven" id="select_cot_id_ven" onchange="$('#validar_valor').text('');" class="nostyle" style="width:90%;" placeholder="Seleccione">
                                                <option value=""></option>
                                                <?php echo  $select_cot_id_ven; ?>
                                            </select>
                                        </div>
                                        <div style="width:100%; padding: 1px;">
                                            <input id="cot_id_venf1" name="cot_id_venf1" class="fecha_filtro" style="width:44%;" placeholder="Fecha Desde" type="text">
                                            <input id="cot_id_venf2" name="cot_id_venf2" class="fecha_filtro" style="width:44%;" placeholder="Fecha Hasta" type="text">
                                        </div>
                                    </div>
                                    <div id="cot_id_cli" style="display:none; width:100%;"><?php //POR CLIENTE 
                                                                                            ?>
                                        <div style="width:100%; padding: 1px;">
                                            <select name="select_cot_id_cli" id="select_cot_id_cli" onchange="$('#validar_valor').text('');" class="nostyle" style="width:90%;" placeholder="Seleccione">
                                                <option value=""></option>
                                                <?php echo  $select_cot_id_cli; ?>
                                            </select>
                                        </div>
                                        <div style="width:100%; padding: 1px;">
                                            <input id="cot_id_clif1" name="cot_id_clif1" class="fecha_filtro" style="width:44%;" placeholder="Fecha Desde" type="text">
                                            <input id="cot_id_clif2" name="cot_id_clif2" class="fecha_filtro" style="width:44%;" placeholder="Fecha Hasta" type="text">
                                        </div>
                                    </div>
                                    <div id="categorias" style="display:none; width:100%;"><?php //POR CATEGORIA 
                                                                                            ?>
                                        <div style="width:100%; padding: 1px;">
                                            <select name="select_categorias" id="select_categorias" onchange="$('#validar_valor').text('');" class="nostyle" style="width:90%;" placeholder="Seleccione">
                                                <option value=""></option>
                                                <?php echo  $select_categorias; ?>
                                            </select>
                                        </div>
                                        <div style="width:100%; padding: 1px;">
                                            <input id="categoriasf1" name="categoriasf1" class="fecha_filtro" style="width:44%;" placeholder="Fecha Desde" type="text">
                                            <input id="categoriasf2" name="categoriasf2" class="fecha_filtro" style="width:44%;" placeholder="Fecha Hasta" type="text">
                                        </div>
                                    </div>
                                    <div id="cli_id_sec" style="display:none; width:100%;"><?php //POR SECTOR - CLIENTE 
                                                                                            ?>
                                        <div style="width:100%; padding: 1px;">
                                            <select name="select_cli_id_sec" id="select_cli_id_sec" onchange="$('#validar_valor').text('');" class="nostyle" style="width:90%;" placeholder="Seleccione">
                                                <option value=""></option>
                                                <?php echo  $select_cli_id_sec; ?>
                                            </select>
                                        </div>
                                        <div style="width:100%; padding: 1px;">
                                            <input id="cli_id_secf1" name="cli_id_secf1" class="fecha_filtro" style="width:44%;" placeholder="Fecha Desde" type="text">
                                            <input id="cli_id_secf2" name="cli_id_secf2" class="fecha_filtro" style="width:44%;" placeholder="Fecha Hasta" type="text">
                                        </div>
                                    </div>
                                    <div id="cli_id_cac" style="display:none; width:100%;"><?php //POR SEGMENTO - CLIENTE (CARTERA_CLIENTE) 
                                                                                            ?>
                                        <div style="width:100%; padding: 1px;">
                                            <select name="select_cli_id_cac" id="select_cli_id_cac" onchange="$('#validar_valor').text('');" class="nostyle" style="width:90%;" placeholder="Seleccione">
                                                <option value=""></option>
                                                <?php echo  $select_cli_id_cac; ?>
                                            </select>
                                        </div>
                                        <div style="width:100%; padding: 1px;">
                                            <input id="cli_id_cacf1" name="cli_id_cacf1" class="fecha_filtro" style="width:44%;" placeholder="Fecha Desde" type="text">
                                            <input id="cli_id_cacf2" name="cli_id_cacf2" class="fecha_filtro" style="width:44%;" placeholder="Fecha Hasta" type="text">
                                        </div>
                                    </div>
                                    <div id="cli_id_cfc" style="display:none; width:100%;"><?php //POR CLASIFICACION - CLIENTE  
                                                                                            ?>
                                        <div style="width:100%; padding: 1px;">
                                            <select name="select_cli_id_cfc" id="select_cli_id_cfc" onchange="$('#validar_valor').text('');" class="nostyle" style="width:90%;" placeholder="Seleccione">
                                                <option value=""></option>
                                                <?php echo  $select_cli_id_cfc; ?>
                                            </select>
                                        </div>
                                        <div style="width:100%; padding: 1px;">
                                            <input id="cli_id_cfcf1" name="cli_id_cfcf1" class="fecha_filtro" style="width:44%;" placeholder="Fecha Desde" type="text">
                                            <input id="cli_id_cfcf2" name="cli_id_cfcf2" class="fecha_filtro" style="width:44%;" placeholder="Fecha Hasta" type="text">
                                        </div>
                                    </div>
                                    <div id="todos_los_registros" style="display:none; width:100%;"><?php //TODAS LAS COTIZACIONES 
                                                                                                    ?>
                                        Mostrar todas las cotizaciones de todos los clientes
                                    </div>
                                    <br>
                                    <span id="validar_valor" style="color:red;font-size:11px; position: absolute;top: 73%"></span>
                                </td>
                                <td style="vertical-align: top !important;">
                                    <button class="btn btn-success" type="button" id="consultar_datos">
                                        <span class="icomoon-icon-checkmark white"></span>
                                        Consultar
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </form>
                <div id="accion_botones" style="float: right;margin-top: -33px; margin-right: 4px;">
                    <button onclick="$('#tipo_accion').val('excel'); $('#print_export').submit();" class="btn btn-info" type="button" id="consultar_datos1">
                        <span class="entypo-icon-export white"></span>
                        Exportar a Excel
                    </button>
                    <button onclick="$('#tipo_accion').val('pdf'); $('#print_export').submit();" class="btn btn-info" type="button" id="consultar_datos2">
                        <span class="icomoon-icon-printer white"></span>
                        Imprimir
                    </button>
                </div>
                <div class="box gradient">
                    <div class="title">
                        <h4>
                            <span>Cotizaciones</span>
                        </h4>
                    </div>
                    <form method="post" id="print_export" name="print_export" target="_blank">
                        <div class="content noPad clearfix">
                            <!--  overflow-x: scroll; style="overflow: auto; overflow-y:hidden;padding-top:1px;padding-left:1px;"  -->
                            <div id="contenedorTabla">
                                <?php
                                if (isset($html_consulta)) {
                                    echo $html_consulta;
                                } ?>
                            </div>
                        </div>
                        <input type="hidden" name="filtro_hidden" id="filtro_hidden" />
                        <input type="hidden" name="filtro_valor_hidden" id="filtro_valor_hidden" />
                        <input type="hidden" name="filtro_extra_hidden" id="filtro_extra_hidden" />
                        <input type="hidden" name="tipo_accion" id="tipo_accion" />
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>