<?php 
$dia = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30);
$hora = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA', 8);
$pdf = false;
if ($reporte != "") { 
    $pdf = ($reporte == 'pdf') ? true : false;
    if ($reporte == 'excel'){
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("content-disposition: attachment;filename=Reporte_consumo_permisos.xls");
        header("Pragma: no-cache");
        header("Expires: 0");
        ?>
        <meta charset="utf-8" />
        <div class="head">
            <table>
                <tr><td align="center" colspan="4" ><h4><?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?></h4></td></tr>
                <tr><td align="center" colspan="4" ><h4>Reporte De Permisos Consumidos Período <?php echo $periodo ?></h4></td></tr>
            </table>
        </div>
        <?php 
    } 
} ?>
<table border="1" id="detalles" class="responsive table table-bordered table-condensed">
    <thead>
        <tr style="font-weight:bold; text-align: center;">
            <th <?= ($pdf) ? 'width="58%"' : ''; ?>>Tipo Permiso</th>
            <th <?= ($pdf) ? 'width="14%"' : ''; ?>>Horas Configuradas</th>
            <th <?= ($pdf) ? 'width="14%"' : ''; ?>>Horas Utilizadas</th>
            <th <?= ($pdf) ? 'width="14%"' : ''; ?>>Disponibles</th>            
        </tr>
    </thead>
    <tbody>
        <?php 
        if (count($registros) > 0) {
            foreach ($registros as $key => $val) {
                $limite = ($val['thf_horas_ley'] > 0) ? $val['thf_horas_ley'] : $val['limite'];
                $usados = $val['usado'];
                $restan = (($limite - $usados) < 0) ? 0 : ($limite - $usados);
                $colors = ($limite > 0 && $usados > 0 && $usados > $limite) ? 'style="background: #f18383;"' : '';
                ?>
                <tr <?= $colors ?>>
                    <td <?= ($pdf) ? 'width="58%"' : ''; ?>><?php echo $val['thf_nombre']; ?></td>
                    <td <?= ($pdf) ? 'width="14%"' : ''; ?> style="text-align: right;"><?php echo number_format($limite, 2); ?></td>
                    <td <?= ($pdf) ? 'width="14%"' : ''; ?> style="text-align: right;"><?php echo number_format($usados, 2); ?></td>
                    <td <?= ($pdf) ? 'width="14%"' : ''; ?> style="text-align: right;"><?php echo number_format($restan, 2); ?></td>
                </tr>
                <?php
            }
        }
        ?>
    </tbody>
</table>
