<div style="height:20px;"></div>
<div>
    <?php if ($permisos['permite_agregar']) { ?>
        <a  href="<?= base_url("auto_gestion/acciones/agregar_tiempo_compensatorio/$id_empleado"); ?>" class="btn btn-large" >
            <span class="icon16 icomoon-icon-plus-3 white"> Agregar Tiempo Compensatorio</span>
        </a>
    <?php } ?>
</div>
<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4><span>Tiempo compensatorio de: <i><?= ucwords($info_empleado['emp_nombre'])." ".ucwords($info_empleado['emp_apellido']) . " (" . $info_empleado['emp_codigo'] . ")"; ?></i></span></h4>
            </div>
            <div class="content">
                <table style="font-size:12px;" class="responsive display table table-bordered" id="datagried" >
                    <thead>
                        <tr>
                            <th>Fecha Inicio</th>
                            <th>Fecha Fin</th>
                            <th>Hora Inicio</th>
                            <th>Hora Fin</th>
                            <th>Motivo</th>
                            <th>Num. Horas</th>
                            <th>Disponibilidad</th>
                            <th>Vigencia</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $tce_total_num_hora = 0;
                        $tce_total_disponible = 0;
                        foreach ($tiempos_compensatorios_empleado as $fila) {

                            $tiempo_comp_id = $fila["tce_id"];
                            $tce_disponible = ($fila["tce_disponible"] != "") ? $fila["tce_disponible"] : 0.00; 
                            $tce_total_num_hora += $fila["tce_num_hora"];
                            if ($fila["tce_fecha_vencimiento"] != "") {
                                $hoy = date('Ymd');
                                $vnc = formatear_fecha('Ymd', $fila["tce_fecha_vencimiento"]);
                                $tce_total_disponible += ($tce_disponible > 0 && $hoy <= $vnc) ? $tce_disponible : 0;
                            } else {
                                $tce_total_disponible += ($tce_disponible > 0) ? $tce_disponible : 0;
                            }
                            if ($fila["tce_estado"] == 2) {
                                $estado = 'Autorizado';
                            } elseif ($fila["tce_estado"] == 1) {
                                $estado = 'Activo';
                            } else {
                                $estado = 'Rechazado';
                            }
                            ?>
                            <tr>
                                <td><?php echo ($fila["tce_fecha_desde"] != "" ) ? formatear_fecha('d-m-Y', $fila["tce_fecha_desde"]) : ''; ?></td>
                                <td><?php echo ($fila["tce_fecha_hasta"] != "") ? formatear_fecha('d-m-Y', $fila["tce_fecha_hasta"]) : ''; ?></td>
                                <td><?php echo ($fila["tce_hora_inicio"] != "") ? formatear_fecha('H:i', $fila["tce_hora_inicio"]) : ''; ?></td>
                                <td><?php echo ($fila["tce_hora_final"] != "") ? formatear_fecha('H:i', $fila["tce_hora_final"]) : ''; ?></td>
                                <td><?php echo $fila["tce_motivo"]; ?></td>
                                <td><?php echo $fila["tce_num_hora"]; ?></td>
                                <td><?php echo $tce_disponible; ?></td>
                                <td><?php echo formatear_fecha('d-m-Y', $fila["tce_fecha_vencimiento"]); ?></td>
                                <td><?php echo $estado; ?></td>
                                <td style="text-align:center;">
                                    <?php 
                                    if ($permisos['permite_editar'] && $fila["tce_estado"] == 1) { 
                                        ?>
                                        <a class="tip" title="Editar registro" href="<?= base_url("auto_gestion/acciones/editar_tiempo_compensatorio/$tiempo_comp_id"); ?>" >
                                            <span style="font-size:15px;" class="icomoon-icon-pencil-2"></span>
                                        </a>
                                        <?php
                                    }
                                    if ($permisos['permite_eliminar'] && $fila["tce_estado"] < 2) {
                                        ?>
                                        <a class="tip anular" title="Anular registro" href="<?= base_url("acciones_personal/principal/anular_compensatorio/$tiempo_comp_id/1") ?>" >
                                            <span style="font-size:15px;" class="icomoon-icon-remove-5"></span>
                                        </a>
                                        <?php
                                    }
                                    ?>
                                    <a class="tip" title="Ver registro" href="<?= base_url("auto_gestion/acciones/ver_compensatorio/$tiempo_comp_id"); ?>" >
                                        <span style="font-size:15px;" class="icomoon-icon-eye-3"></span>
                                    </a>
                                </td>
                            </tr>
                        <?php } ?>                        
                    </tbody>
                    <?php if (count($tiempos_compensatorios_empleado) > 0) { ?>
                        <tfoot>
                            <tr>
                                <td colspan="5">TOTAL</td>
                                <td><?php echo number_format($tce_total_num_hora, 2, '.', ','); ?></td>
                                <td><?php echo number_format($tce_total_disponible, 2, '.', ','); ?></td>
                                <td colspan="3"></td>
                            </tr>
                        </tfoot>
                    <?php } ?>
                </table>
                <br />
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function(){
        $.extend( $.fn.dataTableExt.oSort, {
            "date-uk-pre": function ( a ) {
                var svDatea = a.split('-');
                return (svDatea[2] + svDatea[1] + svDatea[0]) * 1;
            },
            "date-uk-asc": function ( a, b ) {
                return ((a < b) ? -1 : ((a > b) ? 1 : 0));
            },
            "date-uk-desc": function ( a, b ) {
                return ((a < b) ? 1 : ((a > b) ? -1 : 0));
            }
        });
        $('#datagried').dataTable({
            "sPaginationType": "full_numbers",
            "aoColumns": [ 
                { "sType": "date-uk" },
                { "sType": "date-uk" },
                null,
                null,
                null,
                null,
                null,
                { "sType": "date-uk" },
                null,
                null
            ]
        });

        $('body').on('click', '.anular', function(e){
            e.preventDefault();
            var url = $(this).attr('href');
            var stado = $(this).data('estado');
            $alerta = '<b>¿Está seguro que desea eliminar este registro?</b><br>';
            $alerta += 'Esta acción no se podrá deshacer.';
            alerta_confirm_ajax(anular_tiempo, url, "Alerta confirmación", $alerta); 
        });
    });

    function anular_tiempo(url = "") {
        if (url != "") {
            wait.start();
            window.open(url, '_self');
        }
    }
</script>