<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>
                    <span>Evaluaciones Empleada/o: <i><?= ucwords($empleado['emp_nombre']) . " " . ucwords($empleado['emp_apellido']) . " (" . $empleado['emp_codigo'] . ")"; ?></i></span>
                </h4>
            </div>
            <div class="content">
                <table style="font-size:12px;" class="responsive dynamicTable display table table-bordered dataTable" id="datagried" >
                    <thead>
                        <tr>
                            <th>Período</th>
                            <th>Fecha Evaluación</th>
                            <th>Resultado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($consulta as $fila) {
                            ?>
                            <tr>
                                <td>
                                    <span><?= $fila["pde_codigo"] ?> ( <?= formatear_fecha('d-m-Y', $fila["pde_fecha_inicio"]) ?> / <?= formatear_fecha('d-m-Y', $fila["pde_fecha_fin"]) ?> )</span>
                                </td>
                                <td>
                                    <span style="display: none;"><?php echo formatear_fecha('YmdHis', $fila["eve_fecha_evaluacion"]); ?></span>
                                    <span><?php echo formatear_fecha('d-m-Y', $fila["eve_fecha_evaluacion"]); ?></span>
                                </td>
                                <td>
                                    <span><?php echo $fila["eve_calificacion"]; ?></span>
                                </td>
                                <td>
                                    <div class="tools">
                                        <div class="btn-group">
                                            <button class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>
                                            <button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button>
                                            <ul class="dropdown-menu">
                                                <li>
                                                    <a href="<?=base_url('auto_gestion/acciones/ver_evaluacion/' . $fila['eve_id'])?>">
                                                        <span class="minia-icon-search"> Ver</span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="<?=base_url('modulo_evaluacion_desempeno/reportes/evaluacion_empleado/' . $fila['eve_id'])?>" target="_blank">
                                                        <span class="entypo-icon-printer"> Imprimir</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        $('#datagried').dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 10,
            "bLengthChange": false,
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    });
</script>