<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
$meses = array('','Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
$yHasta = formatear_fecha("Y", $fec_hasta);
if ($tipo_repo == 'exc') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=bienes_capitalizables.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="4">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br />
                        Cuadro de Bienes Capitalizables <?= ($fec_hasta != "") ? 'a ' . $meses[formatear_fecha('n',$fec_hasta)] . ' ' . formatear_fecha('Y',$fec_hasta) : ""; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <?php 
}
?>
<table border="1" id="datagried" class="responsive table table-bordered" width="100%" aria-describedby="table_2_info" style="font-size: 10pt;">
    <thead>
        <tr style="font-weight: bold;">
            <th >Código</th>
            <th >Nombre o Descripción</th>
            <th >Fecha Adquisición</th>
            <th >Valor de Adquisición</th>
            <th >Valor Residual</th>
            <th >Valor a Depreciar</th>
            <th >Meses Vida Útil</th>
            <th >Depreciación Mensual</th>
            <th >Depreciación Anual</th>
            <th >Hasta <?= ($yHasta - 3) ?></th>
            <th ><?= ($yHasta - 2) ?></th>
            <th ><?= ($yHasta - 1) ?></th>
            <th ><?= ($yHasta) ?></th>
            <th >Total Depreciado</th>
            <th >Importe en Libros</th>
        </tr>
        <?php if (count($registros['activos']) > 0) {
            ?>
            <tr style="font-weight: bold;"><th colspan="15"><?= $registros['activos'][0]['nombre_orden'] ?></th></tr>
            <?php
        } ?>
    </thead>
    <tbody>
        <?php
        $subtotales = array();
        $total_adq_act = $total_resid_act = $total_aDepre_act = $total_depMens_act = $total_depAnual = 0;
        $total_dep_menos3 = $total_dep_menos2 = $total_dep_menos1 = $total_dep_thisYr = $total_depGnal = $total_vLibros = 0;
        if (count($registros['activos']) > 0) {
            $arrayActivos = $registros['activos'];
            $agractual = $registros['activos'][0]['id_orden'];
            $agrnombre = $registros['activos'][0]['nombre_orden'];
            $subtotales[$agractual] = array("vCompra" => 0,"vResidu" => 0,"vAdepre" => 0,"vCuDepA" => 0,"vCuDepM" => 0,"vDviene" => 0,"vD2yAgo" => 0,"vDlYear" => 0,"vDyearF" => 0,"vDpalaF" => 0,"vLibros" => 0);
            foreach ($arrayActivos as $k => $v) {
                $vAdepreciar = ($v['act_valor_compra'] - $v['act_valor_residual']);
                $deprAnual = ($vAdepreciar / $v['act_vida_util']);
                $deprMensual = ($vAdepreciar / ($v['act_vida_util'] * 12));
                $valorlibros = ($v['act_valor_compra'] - $v['depreciacion_acumulada']);
                if ($v['id_orden'] == $agractual) {
                    $subtotales[$agractual]['vCompra'] += number_format($v['act_valor_compra'], 2, '.', '');
                    $subtotales[$agractual]['vResidu'] += number_format($v['act_valor_residual'], 2, '.', '');
                    $subtotales[$agractual]['vAdepre'] += number_format($vAdepreciar, 2, '.', '');
                    $subtotales[$agractual]['vCuDepA'] += $deprAnual;
                    $subtotales[$agractual]['vCuDepM'] += $deprMensual;
                    $subtotales[$agractual]['vDviene'] += number_format($v['saldo_depreciacion_vienen'], 2, '.', '');
                    $subtotales[$agractual]['vD2yAgo'] += number_format($v['saldo_dep_two_year_ago'], 2, '.', '');
                    $subtotales[$agractual]['vDlYear'] += number_format($v['saldo_depreciacion_last_year'], 2, '.', '');
                    $subtotales[$agractual]['vDyearF'] += number_format($v['depreciacion_anio_filtro'], 2, '.', '');
                    $subtotales[$agractual]['vDpalaF'] += $v['depreciacion_acumulada'];
                    $subtotales[$agractual]['vLibros'] += $valorlibros;
                    ?>
                    <tr >
                        <td style='mso-number-format:"\@";' ><?= $v['act_codigo'] ?></td>
                        <td  ><?= $v['act_nombre'] ?></td>
                        <td  ><?= formatear_fecha('d-m-Y', $v['act_fecha_adq']) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['act_valor_compra'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['act_valor_residual'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($vAdepreciar, 2) ?></td>
                        <td  style="text-align: right;"><?= number_format(($v['act_vida_util'] * 12)) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($deprMensual, 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($deprAnual, 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['saldo_depreciacion_vienen'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['saldo_dep_two_year_ago'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['saldo_depreciacion_last_year'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['depreciacion_anio_filtro'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['depreciacion_acumulada'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($valorlibros, 2) ?></td>
                    </tr>
                    <?php 
                } else {
                    ?>
                    <tr >
                        <td colspan="3">Subtotal <?= $agrnombre?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vCompra'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vResidu'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vAdepre'], 2) ?></td>
                        <td></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vCuDepM'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vCuDepA'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vDviene'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vD2yAgo'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vDlYear'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vDyearF'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vDpalaF'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vLibros'], 2) ?></td>
                    </tr>
                    <?php
                    $total_depAnual += $subtotales[$agractual]['vCuDepA'];
                    $total_depMens_act += $subtotales[$agractual]['vCuDepM'];
                    $total_depGnal += number_format($subtotales[$agractual]['vDpalaF'], 2, '.','');
                    $total_vLibros += number_format($subtotales[$agractual]['vLibros'], 2, '.','');
                    $total_adq_act += number_format($subtotales[$agractual]['vCompra'], 2, '.','');
                    $total_resid_act += number_format($subtotales[$agractual]['vResidu'], 2, '.','');
                    $total_aDepre_act += number_format($subtotales[$agractual]['vAdepre'], 2, '.','');
                    $total_dep_menos3 += number_format($subtotales[$agractual]['vDviene'], 2, '.','');
                    $total_dep_menos2 += number_format($subtotales[$agractual]['vD2yAgo'], 2, '.','');
                    $total_dep_menos1 += number_format($subtotales[$agractual]['vDlYear'], 2, '.','');
                    $total_dep_thisYr += number_format($subtotales[$agractual]['vDyearF'], 2, '.','');
                    $agractual = $v['id_orden'];
                    $agrnombre = $v['nombre_orden'];
                    $subtotales[$agractual] = array("vCompra" => 0,"vResidu" => 0,"vAdepre" => 0,"vCuDepA" => 0,"vCuDepM" => 0,"vDviene" => 0,"vD2yAgo" => 0,"vDlYear" => 0,"vDyearF" => 0,"vDpalaF" => 0,"vLibros" => 0);
                    $subtotales[$agractual]['vCompra'] += number_format($v['act_valor_compra'], 2, '.', '');
                    $subtotales[$agractual]['vResidu'] += number_format($v['act_valor_residual'], 2, '.', '');
                    $subtotales[$agractual]['vAdepre'] += number_format($vAdepreciar, 2, '.', '');
                    $subtotales[$agractual]['vCuDepA'] += $deprAnual;
                    $subtotales[$agractual]['vCuDepM'] += $deprMensual;
                    $subtotales[$agractual]['vDviene'] += number_format($v['saldo_depreciacion_vienen'], 2, '.', '');
                    $subtotales[$agractual]['vD2yAgo'] += number_format($v['saldo_dep_two_year_ago'], 2, '.', '');
                    $subtotales[$agractual]['vDlYear'] += number_format($v['saldo_depreciacion_last_year'], 2, '.', '');
                    $subtotales[$agractual]['vDyearF'] += number_format($v['depreciacion_anio_filtro'], 2, '.', '');
                    $subtotales[$agractual]['vDpalaF'] += $v['depreciacion_acumulada'];
                    $subtotales[$agractual]['vLibros'] += $valorlibros;
                    ?>
                    <tr style="font-weight: bold;"><th colspan="15"><?= $agrnombre ?></th></tr>
                    <tr >
                        <td style='mso-number-format:"\@";' ><?= $v['act_codigo'] ?></td>
                        <td  ><?= $v['act_nombre'] ?></td>
                        <td  ><?= formatear_fecha('d-m-Y', $v['act_fecha_adq']) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['act_valor_compra'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['act_valor_residual'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($vAdepreciar, 2) ?></td>
                        <td  style="text-align: right;"><?= number_format(($v['act_vida_util'] * 12)) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($deprMensual, 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($deprAnual, 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['saldo_depreciacion_vienen'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['saldo_dep_two_year_ago'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['saldo_depreciacion_last_year'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['depreciacion_anio_filtro'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['depreciacion_acumulada'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($valorlibros, 2) ?></td>
                    </tr>
                    <?php
                }                
            }
            ?>
            <tr >
                <td colspan="3">Subtotal <?= $agrnombre?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vCompra'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vResidu'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vAdepre'], 2) ?></td>
                <td></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vCuDepM'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vCuDepA'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vDviene'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vD2yAgo'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vDlYear'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vDyearF'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vDpalaF'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vLibros'], 2) ?></td>
            </tr>
            <?php
            $total_depAnual += $subtotales[$agractual]['vCuDepA'];
            $total_depMens_act += $subtotales[$agractual]['vCuDepM'];
            $total_depGnal += number_format($subtotales[$agractual]['vDpalaF'], 2, '.','');
            $total_vLibros += number_format($subtotales[$agractual]['vLibros'], 2, '.','');
            $total_adq_act += number_format($subtotales[$agractual]['vCompra'], 2, '.','');
            $total_resid_act += number_format($subtotales[$agractual]['vResidu'], 2, '.','');
            $total_aDepre_act += number_format($subtotales[$agractual]['vAdepre'], 2, '.','');
            $total_dep_menos3 += number_format($subtotales[$agractual]['vDviene'], 2, '.','');
            $total_dep_menos2 += number_format($subtotales[$agractual]['vD2yAgo'], 2, '.','');
            $total_dep_menos1 += number_format($subtotales[$agractual]['vDlYear'], 2, '.','');
            $total_dep_thisYr += number_format($subtotales[$agractual]['vDyearF'], 2, '.','');
        } else {
            ?>
            <tr><td colspan="15" style="text-align:center;">No se encontraron registros</td></tr>
            <?php 
        } ?>
    </tbody>
    <tfoot>
        <tr>
            <td colspan="3" style="text-align: right;">Totales</td>
            <td style="text-align: right;"><?= $simbolo . number_format($total_adq_act, 2) ?></td>
            <td style="text-align: right;"><?= $simbolo . number_format($total_resid_act, 2) ?></td>
            <td style="text-align: right;"><?= $simbolo . number_format($total_aDepre_act, 2) ?></td>
            <td></td>
            <td style="text-align: right;"><?= $simbolo . number_format($total_depMens_act, 2) ?></td>
            <td style="text-align: right;"><?= $simbolo . number_format($total_depAnual, 2) ?></td>
            <td style="text-align: right;"><?= $simbolo . number_format($total_dep_menos3, 2) ?></td>
            <td style="text-align: right;"><?= $simbolo . number_format($total_dep_menos2, 2) ?></td>
            <td style="text-align: right;"><?= $simbolo . number_format($total_dep_menos1, 2) ?></td>
            <td style="text-align: right;"><?= $simbolo . number_format($total_dep_thisYr, 2) ?></td>
            <td style="text-align: right;"><?= $simbolo . number_format($total_depGnal, 2) ?></td>
            <td style="text-align: right;"><?= $simbolo . number_format($total_vLibros, 2) ?></td>
        </tr>
    </tfoot>
</table>