<?php
$colmns = 0;
$clspan = 0;
$subtotales = $stYear = array();
$yHasta = formatear_fecha("Y", $fec_hasta);
$yDesde = ($registros['minimo'] > 0) ? $registros['minimo'] : $yHasta;
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
$meses = array('','Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("content-disposition: attachment;filename=listado_bienes_capitalizables.xls");
header("Pragma: no-cache");
header("Expires: 0");
?>
<meta charset="utf-8" />
<div class="head">
    <table>
        <tr>
            <td align="center" colspan="4">
                <h4>
                    <?php
                    echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br />
                    Cuadro de Bienes Capitalizables <?= ($fec_hasta != "") ? 'a ' . $meses[formatear_fecha('n',$fec_hasta)] . ' ' . formatear_fecha('Y',$fec_hasta) : ""; ?>
                </h4>
            </td>
        </tr>
    </table>
</div>
<table border="1" id="datagried" class="table" width="100%" aria-describedby="table_2_info" style="font-size: 9pt;">
    <thead>
        <tr style="font-weight: bold;">
            <th >Código</th>
            <th >Nombre o Descripción</th>
            <th >Fecha Adquisición</th>
            <th >Valor de Adquisición</th>
            <th >Valor Residual</th>
            <th >Valor a Depreciar</th>
            <th >Meses Vida Útil</th>
            <th >Depreciación Mensual</th>
            <th >Depreciación Anual</th>
            <?php for ($i = $yDesde; $i <= $yHasta; $i++) {
                $colmns++;
                $stYear[$i] = array();
                $subtotales['total_anual'][$i] = 0;
                ?>
                <th ><?= $i ?></th>
                <?php
                
            } ?>
            <th >Total Depreciado</th>
            <th >Importe en Libros</th>
        </tr>
        <?php if (count($registros['activos']) > 0) {
            $clspan = $colmns + 11;
            ?>
            <tr style="font-weight: bold;"><th colspan="<?=$clspan?>"><?= $registros['activos'][0]['nombre_orden'] ?></th></tr>
            <?php
        } ?>
    </thead>
    <tbody>
        <?php
        $total_adqui_act = $total_resid_act = $total_dprec_act = $total_dpMes_act = $total_deprAnual = $total_dpGnalAll = $total_valLibros = 0;
        if (count($registros['activos']) > 0) {
            $arrayActivos = $registros['activos'];
            $arrayDeprecs = $registros['historico'];
            $agractual = $registros['activos'][0]['id_orden'];
            $agrnombre = $registros['activos'][0]['nombre_orden'];            
            $subtotales[$agractual] = array("vCompra"=> 0,"vResidu"=> 0,"vAdepre"=> 0,"vCuDepA"=> 0,"vCuDepM"=> 0, "vDpalaF"=> 0,"vLibros"=> 0);
            foreach ($arrayActivos as $k => $v) {
                $vAdepreciar = ($v['act_valor_compra'] - $v['act_valor_residual']);
                $deprAnual = ($vAdepreciar / $v['act_vida_util']);
                $deprMensual = ($vAdepreciar / ($v['act_vida_util'] * 12));
                $valorlibros = ($v['act_valor_compra'] - $v['depreciacion_acumulada']);
                if ($v['id_orden'] == $agractual) {
                    $subtotales[$agractual]['vCompra'] += number_format($v['act_valor_compra'], 2, '.', '');
                    $subtotales[$agractual]['vResidu'] += number_format($v['act_valor_residual'], 2, '.', '');
                    $subtotales[$agractual]['vAdepre'] += number_format($vAdepreciar, 2, '.', '');
                    $subtotales[$agractual]['vCuDepA'] += number_format($deprAnual, 2, '.', '');
                    $subtotales[$agractual]['vCuDepM'] += number_format($deprMensual, 2, '.', '');
                    $subtotales[$agractual]['vDpalaF'] += $v['depreciacion_acumulada'];
                    $subtotales[$agractual]['vLibros'] += $valorlibros;
                    ?>
                    <tr >
                        <td style='mso-number-format:"\@";' ><?= $v['act_codigo'] ?></td>
                        <td  ><?= $v['act_nombre'] ?></td>
                        <td  ><?= formatear_fecha('d-m-Y', $v['act_fecha_adq']) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['act_valor_compra'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['act_valor_residual'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($vAdepreciar, 2) ?></td>
                        <td  style="text-align: right;"><?= number_format(($v['act_vida_util'] * 12)) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($deprMensual, 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($deprAnual, 2) ?></td>
                        <?php for ($i = $yDesde; $i <= $yHasta; $i++) {
                            if (isset($arrayDeprecs[$v['act_id']][$i])) {
                                $stYear[$i][$agractual][] = number_format($arrayDeprecs[$v['act_id']][$i], 2,'.','');
                                ?>
                                <td ><?= number_format($arrayDeprecs[$v['act_id']][$i], 2) ?></td>
                                <?php
                            } else {
                                $stYear[$i][$agractual][] = 0;
                                ?>
                                <td ><?= number_format(0, 2) ?></td>
                                <?php
                            }
                        } ?>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['depreciacion_acumulada'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($valorlibros, 2) ?></td>
                    </tr>
                    <?php
                } else {
                    ?>
                    <tr >
                        <td colspan="3">Subtotal <?= $agrnombre?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vCompra'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vResidu'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vAdepre'], 2) ?></td>
                        <td></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vCuDepM'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vCuDepA'], 2) ?></td>
                        <?php for ($i = $yDesde; $i <= $yHasta; $i++) {
                            $sum = array_sum($stYear[$i][$agractual]);
                            $subtotales['total_anual'][$i] += number_format($sum, 2,'.','');
                            ?>
                            <td ><?= number_format($sum, 2) ?></td>
                            <?php
                        } ?>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vDpalaF'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vLibros'], 2) ?></td>
                    </tr>
                    <?php
                    $total_adqui_act += number_format($subtotales[$agractual]['vCompra'], 2, '.','');
                    $total_resid_act += number_format($subtotales[$agractual]['vResidu'], 2, '.','');
                    $total_dprec_act += number_format($subtotales[$agractual]['vAdepre'], 2, '.','');
                    $total_dpMes_act += $subtotales[$agractual]['vCuDepM'];
                    $total_deprAnual += $subtotales[$agractual]['vCuDepA'];
                    $total_dpGnalAll += number_format($subtotales[$agractual]['vDpalaF'], 2, '.','');
                    $total_valLibros += number_format($subtotales[$agractual]['vLibros'], 2, '.','');
                    $agractual = $v['id_orden'];
                    $agrnombre = $v['nombre_orden'];
                    $subtotales[$agractual] = array("vCompra"=> 0,"vResidu"=> 0,"vAdepre"=> 0,"vCuDepA"=> 0,"vCuDepM"=> 0, "vDpalaF"=> 0,"vLibros"=> 0);

                    $subtotales[$agractual]['vCompra'] += number_format($v['act_valor_compra'], 2, '.', '');
                    $subtotales[$agractual]['vResidu'] += number_format($v['act_valor_residual'], 2, '.', '');
                    $subtotales[$agractual]['vAdepre'] += number_format($vAdepreciar, 2, '.', '');
                    $subtotales[$agractual]['vCuDepA'] += number_format($deprAnual, 2, '.', '');
                    $subtotales[$agractual]['vCuDepM'] += number_format($deprMensual, 2, '.', '');
                    $subtotales[$agractual]['vDpalaF'] += $v['depreciacion_acumulada'];
                    $subtotales[$agractual]['vLibros'] += $valorlibros;
                    ?>
                    <tr style="font-weight: bold;"><th colspan="<?=$clspan?>"><?= $agrnombre ?></th></tr>
                    <tr >
                        <td style='mso-number-format:"\@";' ><?= $v['act_codigo'] ?></td>
                        <td  ><?= $v['act_nombre'] ?></td>
                        <td  ><?= formatear_fecha('d-m-Y', $v['act_fecha_adq']) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['act_valor_compra'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['act_valor_residual'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($vAdepreciar, 2) ?></td>
                        <td  style="text-align: right;"><?= number_format(($v['act_vida_util'] * 12)) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($deprMensual, 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($deprAnual, 2) ?></td>
                        <?php for ($i = $yDesde; $i <= $yHasta; $i++) {
                            if (isset($arrayDeprecs[$v['act_id']][$i])) {
                                $stYear[$i][$agractual][] = number_format($arrayDeprecs[$v['act_id']][$i], 2,'.','');
                                ?>
                                <td ><?= number_format($arrayDeprecs[$v['act_id']][$i], 2) ?></td>
                                <?php
                            } else {
                                $stYear[$i][$agractual][] = 0;
                                ?>
                                <td ><?= number_format(0, 2) ?></td>
                                <?php
                            }
                        } ?>
                        <td  style="text-align: right;"><?= $simbolo . number_format($v['depreciacion_acumulada'], 2) ?></td>
                        <td  style="text-align: right;"><?= $simbolo . number_format($valorlibros, 2) ?></td>
                    </tr>
                    <?php
                }
            }
            ?>
            <tr >
                <td colspan="3">Subtotal <?= $agrnombre?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vCompra'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vResidu'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vAdepre'], 2) ?></td>
                <td></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vCuDepM'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vCuDepA'], 2) ?></td>
                <?php for ($i = $yDesde; $i <= $yHasta; $i++) {
                    $sum = array_sum($stYear[$i][$agractual]);
                    $subtotales['total_anual'][$i] += number_format($sum, 2,'.','');
                    ?>
                    <td ><?= number_format($sum, 2) ?></td>
                    <?php
                } ?>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vDpalaF'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($subtotales[$agractual]['vLibros'], 2) ?></td>
            </tr>
            <?php
            $total_adqui_act += number_format($subtotales[$agractual]['vCompra'], 2, '.','');
            $total_resid_act += number_format($subtotales[$agractual]['vResidu'], 2, '.','');
            $total_dprec_act += number_format($subtotales[$agractual]['vAdepre'], 2, '.','');
            $total_dpMes_act += $subtotales[$agractual]['vCuDepM'];
            $total_deprAnual += $subtotales[$agractual]['vCuDepA'];            
            $total_dpGnalAll += number_format($subtotales[$agractual]['vDpalaF'], 2, '.','');
            $total_valLibros += number_format($subtotales[$agractual]['vLibros'], 2, '.','');
        } else {
            ?>
            <tr><td colspan="<?=$clspan?>" style="text-align:left;">No se encontraron registros</td></tr>
            <?php 
        } ?>
    </tbody>
    <tfoot>
        <tr>
            <th colspan="3" style="text-align: right;">Totales</th>
            <th style="text-align: right;"><?= $simbolo . number_format($total_adqui_act, 2) ?></th>
            <th style="text-align: right;"><?= $simbolo . number_format($total_resid_act, 2) ?></th>
            <th style="text-align: right;"><?= $simbolo . number_format($total_dprec_act, 2) ?></th>
            <th></th>
            <th style="text-align: right;"><?= $simbolo . number_format($total_dpMes_act, 2) ?></th>
            <th style="text-align: right;"><?= $simbolo . number_format($total_deprAnual, 2) ?></th>
            <?php for ($i = $yDesde; $i <= $yHasta; $i++) {
                ?>
                <th ><?= number_format($subtotales['total_anual'][$i], 2) ?></th>
                <?php
            } ?>
            <th style="text-align: right;"><?= $simbolo . number_format($total_dpGnalAll, 2) ?></th>
            <th style="text-align: right;"><?= $simbolo . number_format($total_valLibros, 2) ?></th>
        </tr>
    </tfoot>
</table>