<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));

if ($tipo_reporte == 'excel') {
	header("Content-type: application/vnd.ms-excel; name='Reporte_activo_fijo'");
	header("Content-Disposition: filename=Reporte_activo_fijo.xls");
	header("Pragma: no-cache");
	header("Expires: 0");
?>
	<meta charset="utf-8" />
	<div class="head">
		<table>
			<tr>
				<td align="center" colspan="8">
					<h4>
						<?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br />
						Reporte de Activos Fijos
					</h4>
				</td>
				<td style="text-align: right;" colspan="2">
					<span style="font-size: 8pt;"><?php echo $this->tank_auth->get_username() ?></span><br>
					<span style="font-size: 8pt;"><?php echo $this->gsatelite->get_parametro('SYS_DEPARTAMENTO') . ', ' . date('d-m-Y H:i:s a'); ?></span>
				</td>
			</tr>
		</table>
	</div>
<?php
}
?>
<style>
	th {
		background-color: #49afcd;
		text-align: center;
	}
</style>
<table border="1" cellpadding="9">
	<thead>
		<tr nobr="true">
			<th colspan="1">Correlativo </th>
			<th colspan="1">Codigo</th>
			<th colspan="1">Nombre</th>
			<th colspan="1">Fecha Adquisicion</th>
			<th colspan="1">Condicion <br>del bien</th>
			<th colspan="2">Caracteristicas</th>
			<th colspan="1">Precio Compra</th>
			<th colspan="1">Responsable</th>
			<th colspan="1">Estado</th>
		</tr>
	</thead>
	<tbody id="contenedor">
		<?php
		if (count($activos) > 0) {
			for ($i = 0; $i < count($activos); $i++) {
				$caracteristicas = "";
				$cxc = $this->gsatelite->get_tabla('cxc_caracterxactivo', array('cxc_id_act' => $activos[$i]['act_id']));
				for ($m = 0; $m < count($cxc); $m++) {
					$cxi = $this->gsatelite->get_tabla('cxi_caracteristicaxtipo', array('cxi_id' => $cxc[$m]['cxc_id_cxi']));
					for ($k = 0; $k < count($cxi); $k++) {
						$car = $this->gsatelite->get_tabla('car_caracteristica', array('car_id' => $cxi[$k]['cxi_id_car']));
						$caracteristicas .= '<b>' . $car[$k]['car_nombre'] . ": </b>" . $cxc[$m]['cxc_valor'] . ", ";
					}
				}
				$caracteristicas = substr($caracteristicas, 0, -2);
		?>
				<tr nobr="true">
					<td colspan="1" style="text-align: center;"><?php echo $i + 1; ?></td>
					<td colspan="1"><?php echo $activos[$i]['act_codigo']; ?></td>
					<td colspan="1"><?php echo $activos[$i]['act_nombre']; ?></td>
					<td colspan="1" style="text-align: center;"><?php echo explode(' ', $activos[$i]['act_fecha_adq'])[0]; ?></td>
					<td colspan="1"><?php echo $activos[$i]['act_descripcion']; ?></td>
					<td colspan="2"><?php echo $caracteristicas; ?></td>
					<td colspan="1" style="text-align: center;"><?php echo $simbolo . number_format($activos[$i]['act_valor_compra'], 2); ?></td>
					<td colspan="1" style="text-align: center;">
						<?php
						$actempleado = $this->gsatelite->get_tabla('axe_activoxempleado', array('axe_id_act' => $activos[$i]['act_id'], 'axe_id_are' => $activos[$i]['act_id_are']));
						if (count($actempleado) > 0) {
							$empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $actempleado[0]['axe_id_emp']));
							$nombre_emp = $empleado[0]['emp_nombre'] . ' ' . $empleado[0]['emp_apellido'];
							echo $nombre_emp;
						} else {
							echo '-';
						}
						?>
					</td>
					<td colspan="1">
						<?php
						$estado = $activos[$i]['act_estado'];
						echo $estado == '-1' ? "Inactivo" : $estado == '0' ? "Dado Baja" : "Activo";
						?>
					</td>
				</tr>
			<?php
			}
		} else { ?>
			<tr>
				<td style="text-align: center;" colspan="10">No hay datos que mostrar</td>
			</tr>
		<?php
		} ?>
	</tbody>
</table>
<?php if ($tipo_reporte != '' && $sig_emp == 'isdemu' ) {
    ?>
    <div class="clear"><br></div>
    <table border="0" align="left">
        <tr>
            <td colspan="3" align="center">F:________________________________________________</td>
            <td></td>
            <td colspan="3" align="center"><?= (false && $sig_emp != "isdemu") ? 'F:________________________________________________' : ''; ?></td>
        </tr>
        <tr>
            <?php
            $f1 = $this->gsatelite->get_parametro_emp('SYS_TESORERO_EMPRESA');
            $firma1 = explode(',', $f1);
            $nombre1 = (isset($firma1[0])) ? $firma1[0] : "";
            $cargo1  = (isset($firma1[1])) ? $firma1[1] : "";
            $f2 = $this->gsatelite->get_parametro('SYS_ENCARGADO_ACTIVO_FIJO');
            $firma2 = explode(',', $f2);
            $nombre2 = (isset($firma2[0])) ? $firma2[0] : "";
            $cargo2  = (isset($firma2[1])) ? $firma2[1] : "";
            ?>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre1 : $nombre2; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo1 : $cargo2; ?></td>
            <td></td>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre2 : ''; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo2 : ''; ?></td>
        </tr>
    </table>
    <?php 
} ?>