<?php
$sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }

        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Activos por área
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {
        
    ?>
    <table class="tabla">
        <thead>
            <thead>
                <tr>
                    <th>Código administrativo</th>
                    <th>Descripción</th>
                    <th>Fecha de compra</th>
                    <th>Valor de compra</th>
                    <th>Depreciación acumulada</th>
                </tr>
            </thead>
        </thead>
        <tbody>
            <?php 
                if ( is_object( $act_opciones ) && $act_opciones->num_rows() > 0 ):
                    foreach ( $act_opciones->result() as $row ):
                ?>
                <tr>
                    <td><?php echo $row->act_codigo; ?></td>
                    <td><?php echo $row->act_nombre; ?></td>
                    <td><?php echo ($row->fecha_adquisicion)? date_format(date_create($row->fecha_adquisicion), 'd-m-Y'):''; ?></td>
                    <td><?php echo number_format( $row->act_valor_compra, 2 ); ?></td>
                    <td><?php echo number_format( $row->depreciacion_acumulada, 2); ?></td>
                </tr>
                <?php endforeach; else: ?>
                <tr class="odd"><td valign="top" colspan="6" class="dataTables_empty">No se encontraron registros</td></tr>
                <?php endif; ?>
        </tbody> 
    </table>
<?php } ?>

<?php if ($tipo_reporte != '' && $sig_emp == 'isdemu' ) {
    ?>
    <div class="clear"><br></div>
    <table border="0">
        <tr>
            <td colspan="3" align="center">F:________________________________________________</td>
            <td></td>
            <td colspan="3" align="center"><?= (false && $sig_emp != "isdemu") ? 'F:________________________________________________' : ''; ?></td>
        </tr>
        <tr>
            <?php
            $f1 = $this->gsatelite->get_parametro_emp('SYS_TESORERO_EMPRESA');
            $firma1 = explode(',', $f1);
            $nombre1 = (isset($firma1[0])) ? $firma1[0] : "";
            $cargo1  = (isset($firma1[1])) ? $firma1[1] : "";
            $f2 = $this->gsatelite->get_parametro('SYS_ENCARGADO_ACTIVO_FIJO');
            $firma2 = explode(',', $f2);
            $nombre2 = (isset($firma2[0])) ? $firma2[0] : "";
            $cargo2  = (isset($firma2[1])) ? $firma2[1] : "";
            ?>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre1 : $nombre2; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo1 : $cargo2; ?></td>
            <td></td>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre2 : ''; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo2 : ''; ?></td>
        </tr>
    </table>
    <?php 
} ?>