<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
$espdf = ($tipo == 'pdf') ? true : false; ?>
<style type="text/css">
    .tabla {
        font-weight: normal !important;
    }

    .tabla th {
        border: 1px solid black;
        vertical-align: middle;
    }

    .tabla td {
        border: 1px solid black;
        vertical-align: middle;
    }

    .tabla {
        border: 1px solid black;
    }

    .num {
        mso-number-format: General;
    }

    .text {
        mso-number-format: "\@";
        /*force text*/
    }
</style>
<table border="1" id="datagried" class="responsive display table table-bordered" width="100%" aria-describedby="table_2_info" style="font-size: <?= ($espdf) ? '9pt' : '11pt'; ?>;">
    <thead>
        <tr style="text-align: left;">
            <th>Cod. Activo</th>
            <th>Nombre</th>
            <th>Fecha de Adquisición</th>
            <th>Valor de Adquisición</th>
            <th>Proveedor</th>
            <th>Sucursal</th>
            <th>Área</th>
            <th>Responsable</th>
            <th>Estado del activo</th>
            <th>Tipo de activo</th>
            <th>Descripción</th>
            <th>Tipo de Adquisición</th>
            <th>Centro de costo</th>
            <th>Características</th>
        </tr>
    </thead>
    <tbody>
        <?php
        while (list($key, $val) = each($info)) {
            $nombre = ($val['prv_tipo_pers'] == 2) ? $val['prv_apellido'] : $val['prv_nombre'] . ' ' . $val['prv_apellido'];
            $est    = (int) $val['act_estado'];
            $estado = $est;
            $depto = $filtros_titulo;
            switch ($estado) {
                case 0:
                    $estado = 'Baja';
                    break;
                case 1:
                    $estado = 'Activo';
                    break;
                case 2:
                    $estado = 'Depreciado';
                    break;
                case 2:
                    $estado = 'No depreciable';
                    break;
            }
            echo '<tr nobr="true">
    <td class="text" style="mso-number-format:\'@\'" >' . $val['act_codigo'] . '</td>
    <td>' . $val['act_nombre'] . '</td>
    <td>' . $val['act_fecha_adq'] . '</td>
    <td>' . $simbolo . number_format($val['act_valor_compra'], 2) . '</td>
    <td>' . $nombre . '</td>
    <td>' . $val['sucursal_nombre'] . '</td>
    <td>' . $val['area_nombre'] . '</td>
    <td>' . $val['responsables'] . '</td>
    <td>' . $estado . '</td>
    <td>' . $val['tipo_activo_nombre'] . '</td>
    <td>' . $val['act_descripcion'] . '</td>
    <td>' . $val['tipo_adquisicion_nombre'] . '</td>
    <td>' . $val['centro_costo_nombre'] . '</td>
    <td>' . $val['caracteristicas'] . '</td>
</tr>';
        } ?>
    </tbody>
</table>
<?php if ($tipo != '' && $sig_emp == 'isdemu' ) {
    ?>
    <div class="clear"><br></div>
    <table border="0" align="left">
        <tr>
            <td colspan="3" align="center">F:________________________________________________</td>
            <td></td>
            <td colspan="3" align="center"><?= (false && $sig_emp != "isdemu") ? 'F:________________________________________________' : ''; ?></td>
        </tr>
        <tr>
            <?php
            $f1 = $this->gsatelite->get_parametro_emp('SYS_TESORERO_EMPRESA');
            $firma1 = explode(',', $f1);
            $nombre1 = (isset($firma1[0])) ? $firma1[0] : "";
            $cargo1  = (isset($firma1[1])) ? $firma1[1] : "";
            $f2 = $this->gsatelite->get_parametro('SYS_ENCARGADO_ACTIVO_FIJO');
            $firma2 = explode(',', $f2);
            $nombre2 = (isset($firma2[0])) ? $firma2[0] : "";
            $cargo2  = (isset($firma2[1])) ? $firma2[1] : "";
            ?>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre1 : $nombre2; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo1 : $cargo2; ?></td>
            <td></td>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre2 : ''; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo2 : ''; ?></td>
        </tr>
    </table>
    <?php 
} ?>