<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="5">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de depreciación por cuenta contable
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {
?>
    <table>
        <tr>
            <td colspan="4">
                <h3>
                    <center>Depreciación por cuenta contable periodo <?php echo $periodo; ?></center>
                </h3>
            </td>
        </tr>
    </table>
    <br><br>
    <table class="tabla" cellpadding="2" width="100%">
        <thead>
            <thead>
                <tr>
                    <th style="display: none;"></th>
                    <th style="font-weight:bold !important;" width="30%">Código de cuenta</th>
                    <th style="font-weight:bold !important;" width="30%">Nombre de cuenta</th>
                    <th style="font-weight:bold !important;">Tipo de cuenta</th>
                    <th style="font-weight:bold !important;">Depreciación periodo</th>
                </tr>
            </thead>
        </thead>
        <tbody>
            <?php
            if (count($reporte) > 0) {
                $i = 0;
                $total = 0.00;
                foreach ($reporte as $row) :

            ?>
                    <tr>
                        <th style="display: none;"><?= $i ?></th>
                        <td width="30%"><?php echo $row['cnt_cuenta']; ?></td>
                        <td width="30%"><?php echo $row['cnt_nombre']; ?></td>
                        <td><?php echo $row['tcn_nombre']; ?></td>
                        <td style="text-align:center;"><?php echo $simbolo . number_format($row['monto'], 2);
                                                        $total += $row['monto']; ?>&nbsp;&nbsp;&nbsp;</td>
                    </tr>
                <?php $i++;
                endforeach; ?>
                <tr>
                    <td style="display: none;"><?= $i + 1 ?></td>
                    <td width="30%"></td>
                    <td width="30%"></td>
                    <td>Total</td>
                    <td><?= $simbolo . number_format($total, 2, '.', '') ?></td>
                </tr>
            <?php } else { ?>
                <tr>
                    <td colspan="4">No se enontraron registros</td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
<?php } ?>


<?php if ($tipo_reporte != '' && $sig_emp == 'isdemu' ) {
    ?>
    <div class="clear"><br></div>
    <table border="0">
        <tr>
            <td colspan="3" align="center">F:________________________________________________</td>
            <td></td>
            <td colspan="3" align="center"><?= (false && $sig_emp != "isdemu") ? 'F:________________________________________________' : ''; ?></td>
        </tr>
        <tr>
            <?php
            $f1 = $this->gsatelite->get_parametro_emp('SYS_TESORERO_EMPRESA');
            $firma1 = explode(',', $f1);
            $nombre1 = (isset($firma1[0])) ? $firma1[0] : "";
            $cargo1  = (isset($firma1[1])) ? $firma1[1] : "";
            $f2 = $this->gsatelite->get_parametro('SYS_ENCARGADO_ACTIVO_FIJO');
            $firma2 = explode(',', $f2);
            $nombre2 = (isset($firma2[0])) ? $firma2[0] : "";
            $cargo2  = (isset($firma2[1])) ? $firma2[1] : "";
            ?>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre1 : $nombre2; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo1 : $cargo2; ?></td>
            <td></td>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre2 : ''; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo2 : ''; ?></td>
        </tr>
    </table>
    <?php 
} ?>