<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment;filename=caracteristicas" . date('d-m-Y_His') . ".xls");
header("Pragma: no-cache");
header("Expires: 0");
?>

<?= $html_header ?>
<div class="content noPad clearfix">
	<table name="activo_traslado" id="activo_traslado" style="border:1px solid black;" class="responsive dynamicTable display table table-bordered" border="1">
		<thead>
			<tr style="background-color: #C0C0C0;">
				<th><span>Activo Fijo</span></th>
				<th><span>Fecha de Activo</span></th>
				<th>valor de reevaluación </th>
				<th><span>Detalles</span></th>
			</tr>
		</thead>
		<tbody class="activos">
			<?php
			if (is_object($activos) && $activos->num_rows() > 0) :
				foreach ($activos->result() as $row) :
			?>
					<tr>
						<td><?php echo $row->nombre_activo; ?></td>
						<td style="text-align:left"><?php echo $row->fecha_adquisicion; ?></td>

						<td>
							<?php echo $row->total_mej; ?>
						</td>
						<td>
							<ul>
								<li><?php echo "<strong>Costo:</strong> " . $simbolo . number_format($row->costo, 2); ?></li>
								<li><?php echo "<strong>Acumulado:</strong> " . $simbolo . number_format($row->depreciacion_acumulada, 2); ?></li>
								<li><?php echo "<strong>Valor en Libro:</strong> " . $simbolo . number_format(($row->costo - $row->depreciacion_acumulada), 2); ?></li>
								<li><?php echo "<strong>Meses Depreciados:</strong> " . $row->meses_depreciados; ?></li>
							</ul>
						</td>
					</tr>
				<?php endforeach;
			else : ?>
				<tr>
					<td colspan="4" style="text-align: center;">0 Registros Encontrados</td>
				</tr>
			<?php endif; ?>

		</tbody>
	</table>
</div>

<?php if ($sig_emp == 'isdemu' ) {
    ?>
    <div class="clear"><br></div>
    <table border="0">
        <tr>
            <td colspan="3" align="center">F:________________________________________________</td>
            <td></td>
            <td colspan="3" align="center"><?= (false && $sig_emp != "isdemu") ? 'F:________________________________________________' : ''; ?></td>
        </tr>
        <tr>
            <?php
            $f1 = $this->gsatelite->get_parametro_emp('SYS_TESORERO_EMPRESA');
            $firma1 = explode(',', $f1);
            $nombre1 = (isset($firma1[0])) ? $firma1[0] : "";
            $cargo1  = (isset($firma1[1])) ? $firma1[1] : "";
            $f2 = $this->gsatelite->get_parametro('SYS_ENCARGADO_ACTIVO_FIJO');
            $firma2 = explode(',', $f2);
            $nombre2 = (isset($firma2[0])) ? $firma2[0] : "";
            $cargo2  = (isset($firma2[1])) ? $firma2[1] : "";
            ?>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre1 : $nombre2; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo1 : $cargo2; ?></td>
            <td></td>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre2 : ''; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo2 : ''; ?></td>
        </tr>
    </table>
    <?php 
} ?>