<?php
$p = ($tiporepo == 'pdf') ? true : false;
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
?>
<style>
	td {
		justify-content: center;
		align-items: center;
	}
	.td_val {
		font-size: <?= ($p) ? '7px' : '10px';//  ?>;
	}
	h3 {
		text-align: center;
	}
	table {
		border-collapse: collapse;
	}
</style>
<table cellpadding="1" border="1" style="table-layout:fixed;">
	<thead>
		<tr>
			<th class="td_val" ><b>Código</b></th>
			<th class="td_val" ><b>Descripción del Activo</b></th>
			<th class="td_val" ><b>Área</b></th>
			<th class="td_val" ><b>Fecha Adquisición</b></th>
			<th class="td_val" ><b>Fecha Retiro</b></th>
			<th class="td_val" ><b>Valor de Adquisición</b></th>
			<th class="td_val" ><b>Valor Residual</b></th>
			<th class="td_val" ><b>Monto Depreciar</b></th>
			<th class="td_val" ><b>Depreciación a la fecha</b></th>
			<th class="td_val" ><b>Valor Contable</b></th>
			<th class="td_val" ><b>Motivo Baja</b></th>
			<th class="td_val" ><b>Observaciones</b></th>
		</tr>
	</thead>
	<tbody>
		<?php
		if (count($activos) > 0) {
			foreach ($activos as $k => $val) {
				$descripcion = (trim($val["act_descripcion"]) != "") ? " (".trim($val["act_descripcion"]).")" : "";
				$area = ($val["act_id_are"]) ? $this->gsatelite->get_campo('are_area','are_nombre',array('are_id'=>$val["act_id_are"])) : '';
				$motivo = ($val["act_id_mba"]) ? $this->gsatelite->get_campo('mba_motivo_baja_activo','mba_nombre',array('mba_id'=>$val["act_id_mba"])) : '';
				?>
				<tr nobr="true">
					<td class="td_val"><?= $val["act_codigo"]; ?></td>
					<td class="td_val"><?= $val['act_nombre'] . $descripcion; ?></td>
					<td class="td_val"><?= $area ?></td>
					<td class="td_val"><?= formatear_fecha("d-m-Y", $val['act_fecha_adq']); ?></td>
					<td class="td_val"><?= formatear_fecha("d-m-Y", $val['act_fecha_desact']); ?></td>
					<td class="td_val" style="text-align:right;"><?= $simbolo . number_format($val['act_valor_compra'], 2); ?></td>
					<td class="td_val" style="text-align:right;"><?= $simbolo . number_format($val['act_valor_residual'], 2); ?></td>
					<td class="td_val" style="text-align:right;"><?= $simbolo . number_format(($val['act_valor_compra'] - $val['act_valor_dep']), 2); ?></td>
					<td class="td_val" style="text-align:right;"><?= $simbolo . number_format($val['act_valor_dep'], 2); ?></td>
					<td class="td_val" style="text-align:right;"><?= $simbolo . number_format($val['act_valor_residual'], 2); ?></td>
					<td class="td_val"><?= $motivo ?></td>
					<td class="td_val"><?= $val['act_obs_desact'] ?></td>
				</tr>
				<?php
			}
		} else {
			?>
			<tr>
				<td colspan="11">
					<h5 style="text-align: center">No hay datos que mostrar</h5>
				</td>
			</tr>
			<?php
		}
		?>
	</tbody>
</table>
<?php if ($tiporepo != '' && $sig_emp == 'isdemu' ) {
    ?>
    <div class="clear"><br></div>
    <table border="0">
        <tr>
            <td colspan="3" align="center">F:________________________________________________</td>
            <td></td>
            <td colspan="3" align="center"><?= (false && $sig_emp != "isdemu") ? 'F:________________________________________________' : ''; ?></td>
        </tr>
        <tr>
            <?php
            $f1 = $this->gsatelite->get_parametro_emp('SYS_TESORERO_EMPRESA');
            $firma1 = explode(',', $f1);
            $nombre1 = (isset($firma1[0])) ? $firma1[0] : "";
            $cargo1  = (isset($firma1[1])) ? $firma1[1] : "";
            $f2 = $this->gsatelite->get_parametro('SYS_ENCARGADO_ACTIVO_FIJO');
            $firma2 = explode(',', $f2);
            $nombre2 = (isset($firma2[0])) ? $firma2[0] : "";
            $cargo2  = (isset($firma2[1])) ? $firma2[1] : "";
            ?>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre1 : $nombre2; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo1 : $cargo2; ?></td>
            <td></td>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre2 : ''; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo2 : ''; ?></td>
        </tr>
    </table>
    <?php 
} ?>