<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
if (count($registros) > 0) {
    ?>
    <style type="text/css">
        .text {
            mso-number-format: "\@";
        }
    </style>
    <table class="responsive dynamicTable display table table-bordered dataTable" id="datagried" name="datagried" border="1" style="margin-left: 4px; width: 99%; font-size:12px;">
        <thead id="cabezera">
            <tr style="font-weight: bold; text-align: center; color:width; background-color: ">
                <th>#</th>
                <th>Cód. Tipo</th>
                <th>Tipo Activo</th>
                <th>Código Activo</th>
                <th>Nombre Activo</th>
                <th>Fecha<br />Adquisición</th>
                <th>Fecha Fin<br />Depreciación</th>
                <th>Vida Útil</th>
                <th>% dep. Anual</th>
                <th>Costo <br />Adquisición</th>
                <th>Depreciación <br />Mensual</th>
                <th>Depreciación <br />Acumulada</th>
                <th>Depreciación <br /><?php echo $anio_hasta; ?></th>
                <th>Valor en Libros</th>
                <th>Última<br />Depreciación</th>
            </tr>
        </thead>
        <tbody id="contenedor">
            <?php
            $i = 0;
            $area = 0;
            $total = 0;
            $total_valor_compra = 0;
            $total_valor_residual = 0;
            $total_valor_depreciar = 0;
            $total_cuota_anual = 0;
            $total_cuota_mensual = 0;
            $total_valor_mensual = 0;
            $total_valor_anual = 0;
            $total_valor_acumulada = 0;
            $total_valor_conta = 0;
            $total_depreciacion_acumulada_anio_hasta = 0;
            $proporcion_dep = formatear_fecha('n', $fecha_hasta) / 12;
            foreach ($registros as $f) {
                $i++;
                $aDepreciar = $f['act_valor_compra'] - $f['act_valor_residual'];

                if ($f['act_depreciable']) {
                    $total10 = ($f['act_cuota_mensual'] > 0 && $anio_hasta == 2021) ? $f['act_cuota_mensual'] : ($aDepreciar * ($f['act_porcentaje_dep'] / 100)) / 12;
                    if ($anio_hasta > 2021) {
                        $dep_hasta_hoy = ($proporcion_dep * ($aDepreciar * ($f['act_porcentaje_dep'] / 100)));
                        $dep_yhasta = ($dep_hasta_hoy > $f['depreciacion_anio_filtro']) ? $f['depreciacion_anio_filtro'] : $dep_hasta_hoy;
                    } else {
                        if (trim($f['act_depreciacion_anual']) != "") {
                            $dep_yhasta = $f['act_depreciacion_anual'];
                        } elseif (formatear_fecha('Y', $f['act_fecha_inicia_dep']) == $anio_hasta) {
                            $mes_ini = formatear_fecha('n', $f['act_fecha_inicia_dep']);
                            $mes_fin = formatear_fecha('n', $fecha_hasta);
                            $meses = ($mes_fin - $mes_ini) + 1;
                            $dep_yhasta = ((($aDepreciar * ($f['act_porcentaje_dep'] / 100)) / 12) * $meses);
                        } else {
                            $dep_yhasta = $aDepreciar * ($f['act_porcentaje_dep'] / 100);
                        }
                    }
                } else {
                    $total10 = 0;
                    $dep_yhasta = 0;
                }

                $total_valor_compra += $f['act_valor_compra'];
                $total_valor_acumulada += $f['depreciacion_acumulada'];
                $total_cuota_anual += ($f['act_depreciable']) ? $aDepreciar * ($f['act_porcentaje_dep'] / 100) : 0;
                $total_valor_mensual += $total10;
                $total_depreciacion_acumulada_anio_hasta += $dep_yhasta;
                $en_libro = $f['act_valor_compra'] - $f['depreciacion_acumulada'];
                $total_valor_conta += $en_libro; // (round($aDepreciar,8) - round($f['depreciacion_acumulada'],8));
            ?>
                <tr nobr="true">
                    <td><?php echo $i; ?></td>
                    <td class="text"><?php echo $f['tac_codigo']; ?></td>
                    <td><?php echo $f['tac_nombre']; ?></td>
                    <td class="text"><?php echo $f['act_codigo']; ?></td>
                    <td><?php echo $f['act_nombre']; ?></td>
                    <td><?php echo $f['fecha_adquisicion']; ?></td>
                    <td><?php echo $f['fecha_fin_dep']; ?></td>
                    <td><?php echo number_format($f['act_vida_util'], $dec); ?></td>
                    <td><?php echo number_format($f['porcentaje_anual_dep'], $dec) ; ?></td>
                    <td><?= $simbolo ?><?php echo number_format($f['act_valor_compra'], 2); ?></td>
                    <td><?= $simbolo ?><?php echo number_format($total10, $dec); ?></td>
                    <td><?= $simbolo ?><?php echo number_format($f['depreciacion_acumulada'], $dec); ?></td>
                    <td><?= $simbolo ?><?php echo number_format($dep_yhasta, $dec); ?></td>
                    <td><?= $simbolo ?><?php echo number_format($en_libro, $dec); ?></td>
                    <td><?php echo $f['ultima_depreciacion']; ?></td>
                </tr>
            <?php } ?>
        </tbody>
        <?php if ($total_valor_compra > 0) { ?>
            <tfoot>
                <tr nobr="true" style="font-weight: bold;">
                    <td colspan="9">TOTALES</td>
                    <td><?= $simbolo ?><?php echo number_format($total_valor_compra, 2, '.', ','); ?></td>
                    <td><?= $simbolo ?><?php echo number_format($total_valor_mensual, $dec); ?></td>
                    <td><?= $simbolo ?><?php echo number_format($total_valor_acumulada, $dec); ?></td>
                    <td><?= $simbolo ?><?php echo number_format($total_depreciacion_acumulada_anio_hasta, $dec); ?></td>
                    <td><?= $simbolo ?><?php echo number_format($total_valor_conta, $dec); ?></td>
                    <td><?php //FECHA ULTIMA DEPRECIACION  ?></td>
                </tr>
            </tfoot>
        <?php } ?>
    </table>
<?php } else { ?>
    <table class="responsive dynamicTable display table table-bordered dataTable" id="datagried" name="datagried" border="1" style="margin-left: 4px; width: 99%; font-size:12px;">
        <thead id="cabezera">
            <tr style="font-weight: bold; text-align: center;">
                <th>#</th>
                <th>Cód. Tipo</th>
                <th>Tipo Activo</th>
                <th>Código Activo</th>
                <th>Nombre Activo</th>
                <th>Fecha<br />Adquisición</th>
                <th>Fecha Fin<br />Depreciación</th>
                <th>Vida Útil</th>
                <th>% dep. Anual</th>
                <th>Costo <br />Adquisición</th>
                <!-- <th >Valor <br />Residual</th> -->
                <th>Valor <br />Depreciar</th>
                <!-- <th >Cuota <br />Anual</th> -->
                <!-- <th >Depreciación <br />Mensual</th> -->
                <!-- <th >Depreciación <br />Anual</th> -->
                <th>Depreciación <br />Acumulada</th>
                <th>Depreciación <br />1er A&ntilde;o</th>
                <th>Valor<br />Contable</th>
                <th>Última<br />Depreciación</th>
            </tr>
        </thead>
        <tbody id="contenedor">
            <?php echo ($es_reporte == 1) ? '<tr><td colspan="15" align="center">No se encontraron registros</td></tr>' : ''; ?>
        </tbody>
    </table>
<?php } ?>
<?php if ($es_reporte != 1) { ?>
    <div style="display:none;">
        <form action="<?php echo base_url('activo/reportes/filtrar_depreciacion_activo/1'); ?>" method="POST" id="exportar_imprimir" target="_blank">
            <input type="hidden" id="slcTipoActivo" name="slcTipoActivo" value="<?php echo $slcTipoActivo; ?>">>
            <input type="hidden" id="slcArea" name="slcArea" value="<?php echo $slcArea; ?>">
            <input type="hidden" id="txtFecha_desde" name="txtFecha_desde" value="<?php echo $txtFecha_desde; ?>">
            <input type="hidden" id="txtFecha_hasta" name="txtFecha_hasta" value="<?php echo $txtFecha_hasta; ?>">
            <input type="hidden" id="tipo_accion" name="tipo_accion" value="0">
            <input type="hidden" id="txt_estado" name="txt_estado" value="<?php echo $txt_estado; ?>">
            <input type="hidden" id="slcCosto" name="slcCosto" value="<?php echo $costo; ?>">
        </form>
    </div>
    <script>
        $(document).ready(function() {
            $('#exportar, #imprimir_pdf').show();
            $('#datagried').dataTable({
                "bAutoWidth": false,
                "aLengthMenu": [
                    [10, 25, 50, -1],
                    [10, 25, 50, "Todos"]
                ]
            });
            if ($("#datagried tr").length > 1) {
                $("#contenedorTabla").css({
                    'height': 'auto',
                    'width': 'auto',
                    'padding-bottom': '120px'
                });
                $("html, body").animate({
                    scrollTop: $(document).height() - $(window).height()
                });
            }
        });
    </script>
<?php } ?>