<?php
$dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="5">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Activos dados de Baja <?php echo (isset($subtitulo)) ? '<br />' . $subtitulo : ""; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<div>
    <table class="dynamicTable responsive table table-bordered" cellpadding="1" width="100%" border="<?php echo ($tipo_reporte == 'excel') ? 1 : 0; ?>">
        <thead>
            <tr>
                <th><b>Unidad</b></th>
                <th><b>Código</b></th>
                <th><b>Nombre</b></th>
                <th><b>Descripción</b></th>
                <?php
                foreach ($tabla_car as $key => $value) {
                    ?>
                    <th><b><?= $value['car_nombre'] ?></b></th>
                    <?php
                }
                ?>
                <th><b>Fecha Adquisición</b></th>
                <th><b>Fecha de Baja</b></th>
                <th><b>Motivo Baja</b></th>
                <th><b>Observaciones</b></th>
                <th><b>Valor Adquisición</b></th>
                <th><b>Valor Residual</b></th>
                <th><b>Depreciación Acumulada</b></th>
                <th><b>Valor en Libros</b></th>
            </tr>
        </thead>
        <tbody>
            <?php
            $clsp = (12 + count($tabla_car));
            if (count($detalles) > 0) {
                $total_costo = $total_depre = $total_libro = $tl_residual = 0;
                foreach ($detalles as $key => $val) {
                    $car_valor = array();
                    $car_act = (trim($val['caracteristics']) != "") ? explode('@#@', $val['caracteristics']) : array();
                    foreach ($car_act as $k => $vl) {
                        $vlr = explode('#', $vl);
                        $car_valor[$vlr[0]] = $vlr[1];
                    }
                    $total_costo += number_format($val['act_valor_compra'], 2, '.', '');
                    $total_depre += number_format($val['depreciacion'], 2, '.', '');
                    $total_libro += number_format($val['act_valor_cont'], 2, '.', '');
                    $tl_residual += number_format($val['act_valor_residual'], 2, '.', '');
                    ?>
                    <tr>
                        <td><?= $val['are_nombre'] ?></td>
                        <td><?= $val['act_codigo'] ?></td>
                        <td><?= $val['act_nombre'] ?></td>
                        <td><?= $val['act_descripcion'] ?></td>
                        <?php
                        foreach ($tabla_car as $ky => $car) {
                            if (isset($car_valor[$car['car_id']])) {
                                ?>
                                <td><?= $car_valor[$car['car_id']] ?></td>
                                <?php
                            } else {
                                ?>
                                <td>---</td>
                                <?php
                            }
                        }
                        ?>
                        <td><?= formatear_fecha('d-m-Y', $val['act_fecha_adq']) ?></td>
                        <td><?= formatear_fecha('d-m-Y', $val['act_fecha_desact']) ?></td>
                        <td><?= $val['mba_nombre'] ?></td>
                        <td><?= $val['act_obs_desact'] ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($val['act_valor_compra'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($val['act_valor_residual'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($val['depreciacion'], 2) ?></td>
                        <td style="text-align: right;"><?= $simbolo . number_format($val['act_valor_cont'], 2) ?></td>
                    </tr>
                <?php
                }
            } else {
                ?>
                <tr>
                    <th style="text-align: center;" colspan="<?= $clsp ?>"><b>No se encontraron registros con los filtros aplicados.</b></th>
                </tr>
            <?php
            }
            ?>
        </tbody>
        <?php if (count($detalles) > 0) {
        ?>
            <tfoot>
                <tr>
                    <th style="text-align: right;" colspan="<?= ($clsp - 4) ?>"><b>Total:</b></th>
                    <th style="text-align: right;"><b><?= $simbolo . number_format($total_costo, 2) ?></b></th>
                    <th style="text-align: right;"><b><?= $simbolo . number_format($tl_residual, 2) ?></b></th>
                    <th style="text-align: right;"><b><?= $simbolo . number_format($total_depre, 2) ?></b></th>
                    <th style="text-align: right;"><b><?= $simbolo . number_format($total_libro, 2) ?></b></th>
                </tr>
            </tfoot>
        <?php
        }
        ?>
    </table>
</div>
<?php if ($tipo_reporte == 'excel' && $sig_emp == 'isdemu' ) {
    ?>
    <div class="clear"><br></div>
    <table border="0">
        <tr>
            <td colspan="3" align="center">F:________________________________________________</td>
            <td></td>
            <td colspan="3" align="center"><?= (false && $sig_emp != "isdemu") ? 'F:________________________________________________' : ''; ?></td>
        </tr>
        <tr>
            <?php
            $f1 = $this->gsatelite->get_parametro_emp('SYS_TESORERO_EMPRESA');
            $firma1 = explode(',', $f1);
            $nombre1 = (isset($firma1[0])) ? $firma1[0] : "";
            $cargo1  = (isset($firma1[1])) ? $firma1[1] : "";
            $f2 = $this->gsatelite->get_parametro('SYS_ENCARGADO_ACTIVO_FIJO');
            $firma2 = explode(',', $f2);
            $nombre2 = (isset($firma2[0])) ? $firma2[0] : "";
            $cargo2  = (isset($firma2[1])) ? $firma2[1] : "";
            ?>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre1 : $nombre2; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo1 : $cargo2; ?></td>
            <td></td>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre2 : ''; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo2 : ''; ?></td>
        </tr>
    </table>
    <?php 
} ?>