<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
$meses = array('','Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
$espdf = ($tipo_repo == 'pdf') ? true : false; 
if ($tipo_repo == 'exc') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=bienes_capitalizables.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="4">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br />
                        Cuadro de Bienes Capitalizables <?= (false && $fec_hasta != "") ? 'a ' . $meses[formatear_fecha('n',$fec_hasta)] . ' ' . formatear_fecha('Y',$fec_hasta) : ""; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <?php 
} ?>
<table border="1" id="datagried" class="responsive display table table-bordered" width="100%" aria-describedby="table_2_info" style="font-size: <?= ($espdf) ? '9pt' : '11pt'; ?>;">
    <thead>
        <tr style="font-weight: bold;">
            <th <?= ($espdf)?'width="3%"':'';?> >#</th>
            <th <?= ($espdf)?'width="37%"':'';?> >Nombre o Concepto</th>
            <th <?= ($espdf)?'width="20%"':'';?> >Valor de Adquisición</th>
            <th <?= ($espdf)?'width="20%"':'';?> >Depreciacion Acumulada <?= ($fec_hasta) ? "a ".formatear_fecha("m-Y",$fec_hasta) : ""; ?></th>
            <th <?= ($espdf)?'width="20%"':'';?> >Importe en Libros</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $total_adq = $total_dep = $total_act = 0;
        if (count($registros) > 0) {
            foreach ($registros as $k => $val) {
                $dif_act = ($val['vCompra'] - $val['tDeph']);
                $total_adq += $val['vCompra'];
                $total_dep += $val['tDeph'];
                $total_act += $dif_act;
                ?>
                <tr nobr="true">
                    <td <?= ($espdf)?'width="3%"':'';?> ><?= ($k + 1) ?></td>
                    <td <?= ($espdf)?'width="37%"':'';?> ><?= ($val['agr_nombre'] != "") ? $val['agr_nombre'] : "No Clasificados" ?></td>
                    <td <?= ($espdf)?'width="20%"':'';?> style="text-align: right;"><?= $simbolo . number_format($val['vCompra'], 2) ?></td>
                    <td <?= ($espdf)?'width="20%"':'';?> style="text-align: right;"><?= $simbolo . number_format($val['tDeph'], 2) ?></td>
                    <td <?= ($espdf)?'width="20%"':'';?> style="text-align: right;"><?= $simbolo . number_format($dif_act, 2) ?></td>
                </tr>
                <?php 
            }
        } else {
            if ($tipo_repo != "") {
                ?>
                <tr><td style="text-align:center;">No se encontraron registros</td></tr>
                <?php 
            }
        } ?>
    </tbody>
    <tfoot>
        <tr>
            <th colspan="2" style="text-align: right;">Totales</th>
            <th style="text-align: right;"><?= $simbolo . number_format($total_adq, 2) ?></th>
            <th style="text-align: right;"><?= $simbolo . number_format($total_dep, 2) ?></th>
            <th style="text-align: right;"><?= $simbolo . number_format($total_act, 2) ?></th>
        </tr>
    </tfoot>
</table>