<?php
$dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="5">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Activos por Cuenta de Adquisición <?php echo (isset($subtitulo)) ? '<br />' . $subtitulo : ""; ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
$gran_total_costo = $gran_total_depre = $gran_total_libro = 0;
$total_costo_depr = $total_depre_depr = $total_libro_depr = 0;
$mostrar_dep = true;
$titulo = ($detalles[0]['act_depreciable'] > 0) ? "Activos Depreciables" : "Activos No Depreciables";
?>
<div>
    <table class="dynamicTable responsive table table-bordered" cellpadding="1" width="100%" border="<?php echo ($tipo_reporte == 'excel') ? 1 : 0; ?>">
        <thead>
            <?php
            $clsp = (6 + count($tabla_car));
            if (count($detalles) > 0) {
                if ($mostrar_dep) {
            ?>
                    <tr>
                        <th style="border-bottom: solid 1px black;" colspan="<?= $clsp ?>"><b>
                                <h3><?= $titulo ?></h3>
                            </b></th>
                    </tr>
                <?php
                }
                ?>
                <tr>
                    <th colspan="<?= $clsp ?>"><?php echo ($detalles[0]['cnt_cuenta'] != "") ? $detalles[0]['cnt_cuenta'] . ' - ' . $detalles[0]['cnt_nombre'] : ''; ?></th>
                </tr>
            <?php
                $mostrar_dep = false;
            }
            ?>
            <tr>
                <th><b>Código</b></th>
                <th><b>Nombre</b></th>
                <?php
                foreach ($tabla_car as $key => $value) {
                ?>
                    <th><b><?= $value['car_nombre'] ?></b></th>
                <?php
                }
                ?>
                <th><b>Adquisición</b></th>
                <th><b>Costo</b></th>
                <th><b>Depreciación Acumulada</b></th>
                <th><b>Valor en Libros</b></th>
            </tr>
        </thead>
        <tbody>
            <?php
            if (count($detalles) > 0) {
                $depreciable = $detalles[0]['act_depreciable'];
                $cta_actual = $detalles[0]['cnt_id'];
                $cta_nombre = ($detalles[0]['cnt_cuenta'] != "") ? $detalles[0]['cnt_cuenta'] . ' - ' . $detalles[0]['cnt_nombre'] : 'Cuenta No definida';
                $total_costo_cta = $total_depre_cta = $total_libro_cta = 0;
                foreach ($detalles as $key => $val) {
                    $car_valor = array();
                    $car_act = (trim($val['caracteristics']) != "") ? explode('@#@', $val['caracteristics']) : array();
                    foreach ($car_act as $k => $vl) {
                        $vlr = explode('#', $vl);
                        $car_valor[$vlr[0]] = $vlr[1];
                    }
                    if ($val['act_depreciable'] == $depreciable) {
                        //dep=1 & cta= 1////////////////////////////////////////////////////////////////////////////////////////////////////////////
                        if ($val['cnt_id'] == $cta_actual) {
                            $total_costo_cta += number_format($val['act_valor_compra'], 2, '.', '');
                            $total_depre_cta += number_format($val['depreciacion'], 2, '.', '');
                            $total_libro_cta += number_format($val['act_valor_cont'], 2, '.', '');
            ?>
                            <tr>
                                <td><?= $val['act_codigo'] ?></td>
                                <td><?= $val['act_nombre'] ?></td>
                                <?php
                                foreach ($tabla_car as $ky => $car) {
                                    if (isset($car_valor[$car['car_id']])) {
                                ?>
                                        <td><?= $car_valor[$car['car_id']] ?></td>
                                    <?php
                                    } else {
                                    ?>
                                        <td>---</td>
                                <?php
                                    }
                                }
                                ?>
                                <td><?php echo formatear_fecha('d-m-Y', $val['act_fecha_adq']) . $val['tipo_compra']; ?></td>
                                <td style="text-align: right;"><?= $simbolo . number_format($val['act_valor_compra'], 2) ?></td>
                                <td style="text-align: right;"><?= $simbolo . number_format($val['depreciacion'], 2) ?></td>
                                <td style="text-align: right;"><?= $simbolo . number_format($val['act_valor_cont'], 2) ?></td>
                            </tr>
                        <?php
                        } else {
                            //dep=1 & cta= 2////////////////////////////////////////////////////////////////////////////////////////////////////////
                        ?>
        </tbody>
        <tfoot>
            <tr>
                <th style="text-align: right;" colspan="<?= ($clsp - 3) ?>"><b>Total <?= $cta_nombre ?>:</b></th>
                <th style="text-align: right;"><b><?= $simbolo . number_format($total_costo_cta, 2) ?></b></th>
                <th style="text-align: right;"><b><?= $simbolo . number_format($total_depre_cta, 2) ?></b></th>
                <th style="text-align: right;"><b><?= $simbolo . number_format($total_libro_cta, 2) ?></b></th>
            </tr>
        </tfoot>
    </table>
</div><br>
<div>
    <?php
                            $cta_actual = $val['cnt_id'];
                            $cta_nombre = ($val['cnt_cuenta'] != "") ? $val['cnt_cuenta'] . ' - ' . $val['cnt_nombre'] : 'Cuenta No definida';
                            $total_costo_depr += $total_costo_cta;
                            $total_depre_depr += $total_depre_cta;
                            $total_libro_depr += $total_libro_cta;
                            $total_costo_cta = $total_depre_cta = $total_libro_cta = 0;
                            $total_costo_cta += number_format($val['act_valor_compra'], 2, '.', '');
                            $total_depre_cta += number_format($val['depreciacion'], 2, '.', '');
                            $total_libro_cta += number_format($val['act_valor_cont'], 2, '.', '');
    ?>
    <table class="dynamicTable responsive table table-bordered" cellpadding="1" width="100%" border="<?php echo ($tipo_reporte == 'excel') ? 1 : 0; ?>">
        <thead>
            <tr>
                <th colspan="<?= $clsp ?>"><?php echo $cta_nombre; ?></th>
            </tr>
            <tr>
                <th><b>Código</b></th>
                <th><b>Nombre</b></th>
                <?php
                            foreach ($tabla_car as $key => $value) {
                ?>
                    <th><b><?= $value['car_nombre'] ?></b></th>
                <?php
                            }
                ?>
                <th><b>Adquisición</b></th>
                <th><b>Costo</b></th>
                <th><b>Depreciación Acumulada</b></th>
                <th><b>Valor en Libros</b></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?= $val['act_codigo'] ?></td>
                <td><?= $val['act_nombre'] ?></td>
                <?php
                            foreach ($tabla_car as $ky => $car) {
                                if (isset($car_valor[$car['car_id']])) {
                ?>
                        <td><?= $car_valor[$car['car_id']] ?></td>
                    <?php
                                } else {
                    ?>
                        <td>---</td>
                <?php
                                }
                            }
                ?>
                <td><?php echo formatear_fecha('d-m-Y', $val['act_fecha_adq']) . $val['tipo_compra']; ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($val['act_valor_compra'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($val['depreciacion'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($val['act_valor_cont'], 2) ?></td>
            </tr>
        <?php
                        }
                    } else {
                        //dep 2 cta 1/////////////////////////////////////////////////////////////////////////////////////////////////////////
        ?>
        </tbody>
        <tfoot>
            <tr>
                <th style="text-align: right;" colspan="<?= ($clsp - 3) ?>"><b>Total <?= $cta_nombre ?>:</b></th>
                <th style="text-align: right;"><b><?= $simbolo . number_format($total_costo_cta, 2) ?></b></th>
                <th style="text-align: right;"><b><?= $simbolo . number_format($total_depre_cta, 2) ?></b></th>
                <th style="text-align: right;"><b><?= $simbolo . number_format($total_libro_cta, 2) ?></b></th>
            </tr>
        </tfoot>
    </table>
</div><br>
<div>
    <?php
                        $cta_actual = $val['cnt_id'];
                        $cta_nombre = ($val['cnt_cuenta'] != "") ? $val['cnt_cuenta'] . ' - ' . $val['cnt_nombre'] : 'Cuenta No definida';
                        $depreciable = $val['act_depreciable'];
                        $total_costo_depr += $total_costo_cta;
                        $total_depre_depr += $total_depre_cta;
                        $total_libro_depr += $total_libro_cta;
                        $gran_total_costo += $total_costo_depr;
                        $gran_total_depre += $total_depre_depr;
                        $gran_total_libro += $total_libro_depr;
                        $total_costo_cta = $total_depre_cta = $total_libro_cta = 0;
                        $total_costo_cta += number_format($val['act_valor_compra'], 2, '.', '');
                        $total_depre_cta += number_format($val['depreciacion'], 2, '.', '');
                        $total_libro_cta += number_format($val['act_valor_cont'], 2, '.', '');
    ?>
    <table class="dynamicTable responsive table table-bordered" cellpadding="1" width="100%" border="<?php echo ($tipo_reporte == 'excel') ? 1 : 0; ?>">
        <tr>
            <th style="text-align: right; vertical-align: middle;" rowspan="2" colspan="<?= ($clsp - 3) ?>"><b>Total <?= $titulo ?>:</b></th>
            <th style="text-align: center;"><b>Costo</b></th>
            <th style="text-align: center;"><b>Depreciación Acumulada</b></th>
            <th style="text-align: center;"><b>Valor en Libros</b></th>
        </tr>
        <tr>
            <th style="text-align: right;"><b><?= $simbolo . number_format($total_costo_depr, 2) ?></b></th>
            <th style="text-align: right;"><b><?= $simbolo . number_format($total_depre_depr, 2) ?></b></th>
            <th style="text-align: right;"><b><?= $simbolo . number_format($total_libro_depr, 2) ?></b></th>
        </tr>
    </table>
</div><br>
<div>
    <?php
                        $titulo = ($val['act_depreciable'] > 0) ? "Activos Depreciables" : "Activos No Depreciables";
                        $total_costo_depr = $total_depre_depr = $total_libro_depr = 0;
    ?>
    <table class="dynamicTable responsive table table-bordered" cellpadding="1" width="100%" border="<?php echo ($tipo_reporte == 'excel') ? 1 : 0; ?>">
        <thead>
            <tr>
                <th style="border-bottom: solid 1px black;" colspan="<?= $clsp ?>"><b>
                        <h3><?= $titulo ?></h3>
                    </b></th>
            </tr>
            <tr>
                <th colspan="<?= $clsp ?>"><?php echo $cta_nombre; ?></th>
            </tr>
            <tr>
                <th><b>Código</b></th>
                <th><b>Nombre</b></th>
                <?php
                        foreach ($tabla_car as $key => $value) {
                ?>
                    <th><b><?= $value['car_nombre'] ?></b></th>
                <?php
                        }
                ?>
                <th><b>Adquisición</b></th>
                <th><b>Costo</b></th>
                <th><b>Depreciación Acumulada</b></th>
                <th><b>Valor en Libros</b></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?= $val['act_codigo'] ?></td>
                <td><?= $val['act_nombre'] ?></td>
                <?php
                        foreach ($tabla_car as $ky => $car) {
                            if (isset($car_valor[$car['car_id']])) {
                ?>
                        <td><?= $car_valor[$car['car_id']] ?></td>
                    <?php
                            } else {
                    ?>
                        <td>---</td>
                <?php
                            }
                        }
                ?>
                <td><?php echo formatear_fecha('d-m-Y', $val['act_fecha_adq']) . $val['tipo_compra']; ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($val['act_valor_compra'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($val['depreciacion'], 2) ?></td>
                <td style="text-align: right;"><?= $simbolo . number_format($val['act_valor_cont'], 2) ?></td>
            </tr>
    <?php
                    }
                } //end foreach
            } else {
    ?>
    <tr>
        <th style="text-align: center;" colspan="<?= $clsp ?>"><b>No se encontraron registros con los filtros aplicados.</b></th>
    </tr>
<?php
            }
?>
        </tbody>
        <?php if (count($detalles) > 0) {
            $total_costo_depr += $total_costo_cta;
            $total_depre_depr += $total_depre_cta;
            $total_libro_depr += $total_libro_cta;
            $gran_total_costo += $total_costo_depr;
            $gran_total_depre += $total_depre_depr;
            $gran_total_libro += $total_libro_depr;
        ?>
            <tfoot>
                <tr>
                    <th style="text-align: right;" colspan="<?= ($clsp - 3) ?>"><b>Total <?= $cta_nombre ?>:</b></th>
                    <th style="text-align: right;"><b><?= $simbolo . number_format($total_costo_cta, 2) ?></b></th>
                    <th style="text-align: right;"><b><?= $simbolo . number_format($total_depre_cta, 2) ?></b></th>
                    <th style="text-align: right;"><b><?= $simbolo . number_format($total_libro_cta, 2) ?></b></th>
                </tr>
            </tfoot>
        <?php
        }
        ?>
    </table>
</div><br>
<div>
    <table class="dynamicTable responsive table table-bordered" cellpadding="1" width="100%" border="<?php echo ($tipo_reporte == 'excel') ? 1 : 0; ?>">
        <tr>
            <th style="text-align: right; vertical-align: middle;" rowspan="2" colspan="<?= ($clsp - 3) ?>"><b>Total <?= $titulo ?>:</b></th>
            <th style="text-align: center;"><b>Costo</b></th>
            <th style="text-align: center;"><b>Depreciación Acumulada</b></th>
            <th style="text-align: center;"><b>Valor en Libros</b></th>
        </tr>
        <tr>
            <th style="text-align: right;"><b><?= $simbolo . number_format($total_costo_depr, 2) ?></b></th>
            <th style="text-align: right;"><b><?= $simbolo . number_format($total_depre_depr, 2) ?></b></th>
            <th style="text-align: right;"><b><?= $simbolo . number_format($total_libro_depr, 2) ?></b></th>
        </tr>
    </table>
</div><br>
<div>
    <table class="dynamicTable responsive table table-bordered" cellpadding="1" width="100%" border="<?php echo ($tipo_reporte == 'excel') ? 1 : 0; ?>">
        <tr>
            <th style="text-align: right; vertical-align: middle;" rowspan="2" colspan="<?= ($clsp - 3) ?>"><b>
                    <h3>Total General:</h3>
                </b></th>
            <th style="text-align: center;"><b>Costo</b></th>
            <th style="text-align: center;"><b>Depreciación Acumulada</b></th>
            <th style="text-align: center;"><b>Valor en Libros</b></th>
        </tr>
        <tr>
            <th style="text-align: right;"><b><?= $simbolo . number_format($gran_total_costo, 2) ?></b></th>
            <th style="text-align: right;"><b><?= $simbolo . number_format($gran_total_depre, 2) ?></b></th>
            <th style="text-align: right;"><b><?= $simbolo . number_format($gran_total_libro, 2) ?></b></th>
        </tr>
    </table>
</div>
<?php if ($tipo_reporte == 'excel' && $sig_emp == 'isdemu' ) {
    ?>
    <div class="clear"><br></div>
    <table border="0">
        <tr>
            <td colspan="3" align="center">F:________________________________________________</td>
            <td></td>
            <td colspan="3" align="center"><?= (false && $sig_emp != "isdemu") ? 'F:________________________________________________' : ''; ?></td>
        </tr>
        <tr>
            <?php
            $f1 = $this->gsatelite->get_parametro_emp('SYS_TESORERO_EMPRESA');
            $firma1 = explode(',', $f1);
            $nombre1 = (isset($firma1[0])) ? $firma1[0] : "";
            $cargo1  = (isset($firma1[1])) ? $firma1[1] : "";
            $f2 = $this->gsatelite->get_parametro('SYS_ENCARGADO_ACTIVO_FIJO');
            $firma2 = explode(',', $f2);
            $nombre2 = (isset($firma2[0])) ? $firma2[0] : "";
            $cargo2  = (isset($firma2[1])) ? $firma2[1] : "";
            ?>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre1 : $nombre2; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo1 : $cargo2; ?></td>
            <td></td>
            <td colspan="3" align="center"><b><?= ($sig_emp != "isdemu") ? $nombre2 : ''; ?></b><br /><?= ($sig_emp != "isdemu") ? $cargo2 : ''; ?></td>
        </tr>
    </table>
    <?php 
} ?>