<?php 
if (isset($filtro['activo_selected'])) {
	$id = $filtro['activo_selected']->act_id;
	$name = $filtro['activo_selected']->act_codigo . " - " . $filtro['activo_selected']->act_nombre;
} else {
	$id = $name = "";
}
?>
<div class="row-fluid">
	<div class="span12">
		<div class="box">
			<div class="title">
				<h4><span>Filtros</span></h4>
				<a href="#" class="minimize">Minimize</a>
			</div>
			<div class="content">
				<form class="horizontal" method="POST">
					<div class="form-row row-fluid">
						<div class="span12">
							<div class="span6">
								<div class="row-fluid">
									<label class="form-label span3">Desde:</label>
									<div class="span7 controls labels-info">
										<input type="text" class="dia" name="fecha_ini" id="fecha_ini" placeholder="dd-mm-yyyy" value="<?= ($filtro['fecha_ini'] != '') ? formatear_fecha('d-m-Y', $filtro['fecha_ini']) : ''; ?>">
									</div>
								</div>
							</div>
							<div class="span6">
								<div class="row-fluid">
									<label class="form-label span3">Hasta:</label>
									<div class="span7 controls labels-info">
										<input type="text" class="dia" name="fecha_fin" id="fecha_fin" placeholder="dd-mm-yyyy" value="<?= ($filtro['fecha_fin'] != '') ? formatear_fecha('d-m-Y', $filtro['fecha_fin']) : ''; ?>">
									</div>
								</div>
							</div>
						</div>
						<div class="span12">
							<div class="span6">
								<div class="row-fluid">
									<label class="form-label span3">Tipo:</label>
									<div class="span7 controls labels-info">
										<select id="tipo_activo" name="tipo_activo" class="nostyle" placeholder="Seleccione">
											<?php echo $tipo_activo; ?>
										</select>
									</div>
								</div>
							</div>
							<div class="span6">
								<div class="row-fluid">
									<label class="form-label span3">Grupo:</label>
									<div class="span7 controls">
										<select id="grupo" name="grupo" class="nostyle" placeholder="Seleccione">
											<?php echo $grupo; ?>
										</select>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="form-row row-fluid">
						<div class="span12">
							<div class="span6">
								<div class="row-fluid">
									<button type="submit" class="btn btn-default" onclick="return valida_fechas();">
										<strong><span class=" icomoon-icon-search-3"></span>Filtrar Activos</strong>
									</button>
								</div>
							</div>
							<div class="span6">
								<div class="row-fluid">
									<label class="form-label span3">Código:</label>
									<div class="span7 controls labels-info">
										<input type="hidden" id="codigo" name="codigo" data-nombre="<?= $name ?>" value="<?= $id ?>" />
									</div>
								</div>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
		<div class="box">
			<div class="title">
				<h4>
					<span></span>
				</h4>
			</div>
			<div class="content noPad clearfix">
				<table id="table" class="responsive display table table-bordered">
					<thead>
						<tr>
							<th width="50%"><span>Activo</span></th>
							<th  width="10%"><span>Fecha Adquisici&oacute;n</span></th>
							<th  width="30%"><span>Informaci&oacute;n</span></th>
							<th  width="10%"><span>Acciones</span></th>
						</tr>
					</thead>
					<tbody class="listado">
						<?php
						if (is_object( $act_opciones ) && $act_opciones->num_rows() > 0 ){
							foreach ( $act_opciones->result() as $row ){
								?>
								<tr>
									<td><?php echo $row->nombre_activo; ?></td>
									<td><span style="display: none;visibility: hidden;"><?= formatear_fecha("Ymd", $row->fecha_adquisicion)?></span><?= formatear_fecha("d-m-Y", $row->fecha_adquisicion) ?></td>
									<td>
										<ul>
											<li><?php echo "<strong>Costo:</strong> $". number_format( $row->costo, 2 ); ?></li>
											<li><?php echo "<strong>Acumulado:</strong> $". number_format( $row->depreciacion_acumulada, 2); ?></li>
											<li><?php echo "<strong>Valor en Libro:</strong> $". number_format( ($row->costo - $row->depreciacion_acumulada), 2); ?></li>
											<li><?php echo "<strong>Meses Depreciados:</strong> ". $row->meses_depreciados; ?></li>
										</ul>
									</td>
									<td>
										<!-- TODO: pantalla que muestra todos los detalles del activo seleccionado -->
										<a class="btn btn-default detalles" href="<?= base_url('activo/nuevo/generar'); ?>?id=<?= $row->act_id ?>">Consultar Simulaci&oacute;n</a><br /><br />
										<a class="btn btn-default detalles" target="_blank" href="<?= base_url('activo/nuevo/iniciar_simulacion_real'); ?>/<?= $row->act_id?>/1">Simulación PDF</a>
									</td>
								</tr>
								<?php 
							}
						} else {
							?>
							<!-- No hay registros -->
							<?php 
						} ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<script src="<?php echo base_url('js/activo_fijo/listado_activos.js');?>"></script>
<script type="text/javascript">
	$(document).ready(function($) {
		$(".dia").datepicker({
			showButtonPanel: true,
			changeMonth: true,
			changeYear: true,
			dateFormat: 'dd-mm-yy',
			monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
			dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
			nextText: "Siguiente",
			prevText: "Anterior",
			closeText: 'Cerrar',
			currentText: 'Hoy'
		});
		$(".dia").mask('99-99-9999');

		$("#codigo").select2({
			placeholder: "Buscar Activo Fijo",
			minimumInputLength: 3,
			ajax: {
				url: window.gSateliteWhite.baseUrl('activo/reportes/get_activo_like'),
				dataType: 'json',
				type: 'POST',
				delay: 250,
				data: function (activo) {
					return {
						producto: activo
					};
				},
				results: function (data) {
					var myResults = [];
					$.each(data, function (index, item) {
						myResults.push({
							'id': item.act_id,
							'text': (item.act_codigo + " " + item.act_nombre)
						});
					});
					return {
						results: myResults
					};
				}
			},
			initSelection: function (element, callback) {
				var idElemento = element[0].id;
				var valor = $("#" + idElemento).val();
				if (valor !== "") {
					var texto = $("#" + idElemento).data('nombre');
					callback({id: valor, text: texto});
				}
			}
		});
	});

	function valida_fechas() {
		fecha_ini = $("#fecha_ini").val();
		fecha_fin = $("#fecha_fin").val();
		if (fecha_ini != "" && fecha_fin != "") {
			var start = fecha_ini.split("-").reverse().join("-");
			var final = fecha_fin.split("-").reverse().join("-");
			if (Date.parse(start) > Date.parse(final)) {
				crear_alerta('error', 'Verifique las fechas del período', '');
				return false;
			} else {
				wait.start();
				return true;
			}    
		} else {
			wait.start();
			return true;
		}
	}
</script>