<?php 
	if ( is_object( $act_opciones ) && $act_opciones->num_rows() > 0 ):
		foreach ( $act_opciones->result() as $row ):		?>
			<tr>
				<td><?php echo $row->act_codigo; ?></td>
				<td><?php echo $row->act_nombre; ?></td>
				<td><?php echo formatear_fecha('d-m-Y', $row->fecha_adquisicion); ?></td>
				<td>$ <?php echo number_format( $row->act_valor_compra, 2 ); ?></td>
				<td><?php echo $row->meses_depreciados; ?></td>
				<td><?php echo $row->periodo_depreciacion; ?></td>
				<td>$ <?php echo number_format( $row->depreciacion_acumulada, 2); ?></td>
				<td>$ <?php echo number_format( ($row->act_valor_compra - $row->depreciacion_acumulada), 2); ?></td>
				<td>
					<?php
						$estado = ($row->act_estado == -1) ? 
							"Inactivo" : ($row->act_estado == 1) ? "Activo" : "Dado de baja";
						echo $estado;
					?>
				</td>
				<td class="center">
					<a class="detalles tip" target="_blank" title="Ver detalles" href="<?php echo base_url('activo/nuevo/detalles'); ?>?id=<?php echo $row->act_id ?>&u=d">Detalles</a>
				</td>
			</tr>
	<?php endforeach; else: ?>
			<tr>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>
<?php endif; ?>