<?php if (isset($asignaciones) && count($asignaciones) > 0) {
    foreach ($asignaciones as $key => $value) {         
        $estado = '';
        switch ($value['slt_estado']) {
            case 1:
                $estado = 'Creado';
                break;
            case 2:
                $estado = 'Autorizado';
                break;
            case 0:
                $estado = 'Rechazado';
                break;
        }
        ?>
        <tr>
            <td><?= ($value['slt_tipo_solicitud'] > 0) ? "Traslado" : "Asignación"; ?></td>
            <td><?= formatear_fecha('d-m-Y', $value['slt_fecha']) ?></td>
            <td><?= $value['emp_codigo'] ?></td>            
            <td><?= $value['emp_nombre'] . ' ' . $value['emp_apellido']; ?></td>            
            <td><?php echo $estado; ?></td>
            <td>
                <div class="tools">
                    <div class="btn-group">
                        <button class="btn" type="button"><span class="icon16 icomoon-icon-cog-2"></span></button>
                        <button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button>
                        <ul class="dropdown-menu">
                            <li>
                                <a class="ver_accion_modal" href="<?php echo base_url('activo/nuevo/asignacion_pendiente/' . $value['slt_id']); ?>/1"   >
                                    <span aria-hidden="true" class="icomoon-icon-grid-view"> Ver Detalles</span>
                                </a>
                            </li>
                            <?php if ($value['slt_estado'] == 2 && $value['slt_tipo_solicitud'] == 1): ?>
                                <li>
                                    <a target="_blank" href="<?php echo base_url('activo/nuevo/acta_traslado_solicitud/' . $value['slt_id']); ?>"   >
                                        <span aria-hidden="true" class="icomoon-icon-printer"> Form. Traslado</span>
                                    </a>
                                </li>                                
                            <?php endif ?>
                        </ul>
                    </div>
                </div>
            </td>
        </tr>
    <?php }
} ?>
