<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>
                    <span>Tiempo compensatorio del empleada/o: <i><?= ucwords($info_empleado['emp_nombre'])." ".ucwords($info_empleado['emp_apellido']) . " (" . $info_empleado['emp_codigo'] . ")"; ?></i></span>
                </h4>
                <button  url="<?php echo base_url("acciones_personal/principal/empleado_tiempo_compensatorio"); ?>" type="button" onclick="url = $('#regresarlistado').attr('url'); location.href = url;" class="btn btn-info" id="regresarlistado" style="position: absolute;top: 7%;right: 1%;"><span class="icon16 icomoon-icon-undo-2 white"></span>Regresar</button>
            </div>
            <div class="content">
                    <a  href="<?= base_url("acciones_personal/principal/agregar_tiempo_compensatorio/$id_empleado"); ?>" class="btn btn-info" >
                        <span class="icon16 icomoon-icon-plus-3 white"> Agregar Tiempo Compensatorio</span>
                    </a>
                
                <table style="font-size:12px;" class="responsive display table table-bordered" id="datagried" >
                    <thead>
                        <tr>
                            <th>Fecha Inicio</th>
                            <th>Fecha Fin</th>
                            <th>Hora Inicio</th>
                            <th>Hora Fin</th>
                            <th>Motivo</th>
                            <th>Num. Horas</th>
                            <th>Disponibilidad</th>
                            <th>Vigencia de tiempo</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $tce_total_num_hora = 0;
                        $tce_total_disponible = 0;
                        foreach ($tiempos_compensatorios_empleado as $fila) {
                            $tiempo_compensatorio = $fila["tce_id"];

                            $tce_disponible = isset($fila["tce_disponible"]) ? $fila["tce_disponible"]: 0.00;

                            $tce_total_num_hora = $tce_total_num_hora + $fila["tce_num_hora"];
                            $tce_total_disponible = $tce_total_disponible + $tce_disponible;

                            if ($fila["tce_estado"] == 2) {
                                $estado = 'Autorizado';
                            } elseif ($fila["tce_estado"] == 1) {
                                $estado = 'Activo';
                            } else {
                                $estado = 'Rechazado';
                            }
                            ?>
                            <tr>
                                <td><?php echo ($fila["tce_fecha_desde"] != "" ) ? formatear_fecha('d-m-Y', $fila["tce_fecha_desde"]) : ''; ?></td>
                                <td><?php echo ($fila["tce_fecha_hasta"] != "") ? formatear_fecha('d-m-Y', $fila["tce_fecha_hasta"]) : ''; ?></td>
                                <td><?php echo ($fila["tce_hora_inicio"] != "") ? formatear_fecha('H:i', $fila["tce_hora_inicio"]) : ''; ?></td>
                                <td><?php echo ($fila["tce_hora_final"] != "") ? formatear_fecha('H:i', $fila["tce_hora_final"]) : ''; ?></td>
                                <td><?php echo $fila["tce_motivo"]; ?></td>
                                <td><?php echo $fila["tce_num_hora"]; ?></td>
                                <td><?php echo $tce_disponible; ?></td>
                                <td><?php echo $fila["tce_fecha_vencimiento"]; ?></td>
                                <td><?php echo $estado; ?></td>
                                <td style="text-align:center;">
                                    <?php 
                                        if ($fila["tce_estado"] == 1) { 
                                    ?>
                                            <a class="tip" title="Editar registro" href="<?= base_url("auto_gestion/acciones/editar_tiempo_compensatorio/$tiempo_compensatorio"); ?>" >
                                                <span style="font-size:15px;" class="icomoon-icon-pencil-2"></span>
                                            </a>
                                    <?php
                                        }
                                    ?>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                    <?php if (count($tiempos_compensatorios_empleado) > 0) { ?>
                        <tfoot>
                            <tr>
                                <td colspan="5">TOTAL</td>
                                <td><?php echo number_format($tce_total_num_hora, 2, '.', ','); ?></td>
                                <td><?php echo number_format($tce_total_disponible, 2, '.', ','); ?></td>
                                <td colspan="3"></td>
                            </tr>
                        </tfoot>
                    <?php } ?>
                </table>
                <br />
                <br />
                <br />
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function(){
        $.extend( $.fn.dataTableExt.oSort, {
            "date-uk-pre": function ( a ) {
                var svDatea = a.split('-');
                return (svDatea[2] + svDatea[1] + svDatea[0]) * 1;
            },
            "date-uk-asc": function ( a, b ) {
                return ((a < b) ? -1 : ((a > b) ? 1 : 0));
            },
            "date-uk-desc": function ( a, b ) {
                return ((a < b) ? 1 : ((a > b) ? -1 : 0));
            }
        });

        $('#datagried').dataTable({
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "sType": "date-uk" },
                { "sType": "date-uk" },
                null,
                null,
                null,
                null,
                null,
                { "sType": "date-uk" },
                null,
                null
            ]
        });
    });
</script>