<script type="text/javascript">
    $(document).ready(function(){
        var pathArray = window.location.pathname.split( '/' );
        var urlj=url_base_proyecto;
        $('#tabla').dataTable();
        $("body").on('click', '.eliminar', function(event){
            event.preventDefault();
            var url= $(this).attr("href");
            alerta_confirm(url,'Alerta de confirmación','¿Seguro que quieres borrar este registro?');
        });
        $("body").on('click', '.autorizar', function(event){
            event.preventDefault();
            var url= $(this).attr("href");
            alerta_confirm(url,'Alerta de confirmación','¿Seguro que quieres autorizar este registro?');
        });
    });
</script>
<style type="text/css">
.accion_gestion_empleado {
    font-size:16px;
}
</style>
<div class="row-fluid">
    <div class="span12">
        <div class="row-fluid">
            <div class="span4">
                <?php if ($permisos['permite_agregar']) { ?>
                    <button type="submit" id="agregar" class="btn btn-large" dir="<?php echo base_url("$ruta_modulo/agregar_retiro"); ?>"  onclick="url=$('#agregar').attr('dir'); location.href=url;"><b>Agregar retiro</b></button>
                <?php } ?>
            </div>
            <div class="span8" style="text-align: right;">
                <?php if ($permisos['permite_ver']) { ?>
                    <a href="<?= base_url('acciones_personal/principal/exportar_retirados/0') ?>" target="_blank" class="btn btn-large exportacion"><span class="icon16 icomoon-icon-file-excel"></span> Exportar </a>
                    <a href="<?= base_url('acciones_personal/principal/exportar_retirados/1') ?>" target="_blank" class="btn btn-large exportacion"><span class="icon16 entypo-icon-printer"></span> Imprimir </a>
                <?php } ?>
            </div>
        </div>
        <div class="box">
            <div class="title">
                <h4>
                    <span>Seleccionar retiro</span>
                </h4>
            </div>
            <div class="content noPad clearfix">
                <table id="tabla" cellpadding="0" cellspacing="0" border="0" class="responsive table table-bordered" width="100%">
                    <thead>
                        <tr>
                            <th>Codigo</th>
                            <th>Empleada/o</th>
                            <th>¿Recontratable?</th>
                            <th>Categoría de retiro</th>    
                            <th>Fecha de retiro</th>  
                            <th>Autorizado</th>  
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php   if ( count($total_empleados)>0 ):
                            $numero_fila = 1;
                            foreach ( $total_empleados as $emp ) :
                                ?>
                                <tr >
                                    <td><?php echo $emp['emp_codigo']?></td>     
                                    <td><?php echo $emp['emp_nombre'].' '.$emp['emp_apellido']?></td>
                                    <td><?php echo ($emp['rte_recontratable'] ==1) ? 'SI' : 'NO'; ?></td>
                                    <td><?php echo $emp['ctr_nombre']?></td>          
                                    <td><span style="display: none;"><?= formatear_fecha('Ymd', $emp['rte_fecha_retiro']) ?></span><?= formatear_fecha('d-m-Y', $emp['rte_fecha_retiro']); ?></td>
                                    <td><?php echo ($emp['rte_autorizar_ret'] > 0) ? 'SI' : 'NO'; ?></td>
                                    <td>
                                        <div class="tools">
                                            <div class="btn-group">
                                                <button class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>
                                                <button class="btn dropdown-toggle" data-toggle="dropdown">
                                                    <span class="caret"></span>
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <?php if($emp['rte_autorizar_ret'] == 0 && $permisos['permite_editar']){ ?>
                                                        <li> 
                                                            <a class="tip" title="Editar retiro de personal" href="<?=base_url("$ruta_modulo/editar_retiro_personal/".$emp['rte_id'])?>" >
                                                                <span class="icomoon-icon-pencil-5 "></span>Editar
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                    <?php if ($emp['rte_autorizar_ret'] == 0 && $permisos['permite_eliminar']) { ?>
                                                        <li>
                                                            <a class="eliminar" href="<?=base_url("$ruta_modulo/inactivar_retiro/".$emp['rte_id'])?>">
                                                                <span aria-hidden="true" class="icomoon-icon-remove"></span>
                                                                Borrar
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                    <?php if($emp['rte_autorizar_ret'] == 0){ ?>
                                                        <li>
                                                            <a class="autorizar" title="Autorizar retiro de personal" href="<?=base_url("$ruta_modulo/autorizar_retiro/".$emp['rte_id_emp'].'/'.$emp['rte_id'])?>" >
                                                                <span class="icomoon-icon-checkmark "></span>Autorizar
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                    <li>
                                                        <a class="finiquito" title="Finiquito de empleado" target="_blank" href="<?=base_url("$ruta_modulo/finiquito_empleado/".$emp['rte_id_emp'].'/'.$emp['rte_id'])?>" >
                                                            <span class="icomoon-icon-printer-2"></span>Finiquito
                                                        </a>
                                                    </li>
                                                    <?php if($emp['rte_autorizar_ret'] == 1 && isset($emp['rte_id_rxe'])){ ?>
                                                        <li>
                                                            <a class="destitucion" target="_blank" title="Destitucion" href="<?=base_url("$ruta_modulo/notificacion_destitucion/".$emp['rte_id_emp'].'/'.$emp['rte_id'])?>" >
                                                                <span class="icomoon-icon-checkmark "></span>Notificacion destitucion
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach;
                        endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>