<?php

        $this->db->join('plz_plaza', 'plz_id = emp_id_plz', 'left');
        $this->db->join('pto_puesto', 'pto_id = plz_id_pto', 'left');
$datos = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $slc_empleado))[0];

$condiciones_documento_identidad = array(
    'dce_id_tde' => 1,
    'dce_id_emp' => $slc_empleado
);
$documento = $this->gsatelite->get_registro('dce_documento_emp', $condiciones_documento_identidad);

if(!$documento){
    $documento = new stdClass();
    $documento->dce_valor = '';
}

$meses = array('', 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
$dia_sema = array('Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado');

$fecha = explode('-', $fecha_resol);
$dia = (int)$fecha[0];
$mes = (int)$fecha[1];
$anio = (int)$fecha[2];
$nombre_mes = $meses[$mes];
$nombre_dia = $dia_sema[date('w', strtotime($fecha_resol))];

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contratacion</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px 100px;
            line-height: 1.6;
            text-align: justify;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header img {
            max-width: 200px;
        }
        .title {
            font-size: 1.5em;
            font-weight: bold;
            text-align: center;
        }
        .subtitle {
            font-size: 1.2em;
            font-weight: bold;
            text-align: center;
            margin: 10px 0;
        }
        .section {
            margin: 20px 0;
            padding: 10px;
            text-align: justify;
        }
        .bold {
            font-weight: bold;
        }
        .centered {
            text-align: center;
        }
        .signature {
            margin-top: 40px;
            text-align: center;
            border-top: 1px solid #000;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="<?= base_url() ?>media/imagenes/sistema/<?= $this->gsatelite->get_parametro_emp('SYS_LOGOTIPO')?>.png" <?= $this->gsatelite->get_parametro_emp('IMG_LOGO_DIMENSIONES_CONSTANCIAS') ?> >
        <div class="title">REPÚBLICA DE PANAMÁ<br>MINISTERIO DE LA MUJER</div>
        <div class="subtitle">RESOLUCIÓN ADMINISTRATIVA N° <?= $nresolucion ?><br>(<?= $nombre_dia ?> <?= $dia ?> de <?= $nombre_mes ?> de <?= $anio ?>)</div>
    </div>

    <div class="section">
        <p class="bold centered">"POR MEDIO DEL CUAL SE ASIGNA COMO PROMOTOR COMUNAL<br>CENTROS DE ATENCIÓN INTEGRAL DE LA CHORRERA EN EL<br>MINISTERIO DE LA MUJER"</p>
    </div>

    <div class="section">
        <p class="bold centered">LA MINISTRA</p>
        <p class="centered">en uso de sus facultades legales,</p>
        
    </div>

    <div class="section">
        <p>Que según el artículo quince (15), numeral 1,3 y 11 de la Ley 375 del 8 de marzo del 2023, es función de la Ministra de la Mujer, planificar, organizar y coordinar los procesos técnicos y administrativos del Ministerio.</p>
    </div>

    <div class="section">
        <p class="bold centered">CONSIDERANDO:</p>
        <p>Que, para cumplir los objetivos, garantizar que se desarrollen las actividades programadas y se coordine la labor Ministerial que le es propia a esta entidad, es indispensable delegar funciones <span class="bold">COMO PROMOTOR COMUNAL EN EL CENTRO DE ATENCIÓN INTEGRAL DE LA CHORRERA DEL MINISTERIO DE LA MUJER.</span></p>
        <p>Que el señor <span class="bold">DIEGO DE GRACIA</span> estará ejerciendo funciones asignadas <span class="bold">en el Centro de Atención Integral de la Chorrera del Ministerio de la Mujer.</span></p>
    </div>

    <div class="section">
        <p class="bold centered">RESUELVE:</p>
        <p><span class="bold">PRIMERO:</span> Que se asigna el señor <span class="bold"><?= $datos['emp_nombre'].' '.$datos['emp_apellido'] ?></span> con cédula de identidad personal <span class="bold">No <?= $documento->dce_valor ?></span>, Seguro Social <span class="bold">No. <?= $datos['emp_seguro'] ?></span>, a ejercer funciones <span class="bold">COMO PROMOTOR COMUNAL EN EL CENTRO DE ATENCIÓN INTEGRAL DE LA CHORRERA DEL MINISTERIO DE LA MUJER.</span></p>
        <p><span class="bold">SEGUNDO:</span> Que el señor <?= $datos['emp_nombre'].' '.$datos['emp_apellido'] ?> está autorizado para realizar trámites concernientes a su designación a partir de su notificación.</p>
        <p>Dado en la ciudad de Panamá, a los <?= $dia ?> (<?= $dia ?>) días del mes de <?= $nombre_mes ?> de <?= $anio ?>.</p>
    </div>

    <div class="section">
        <p class="bold centered">COMUNÍQUESE Y CÚMPLASE</p>
    </div>

    <div class="signature">
        <p>______________________________</p>
        <p class="bold">Nombre</p>
        <p class="bold">Ministra</p>
        <p class="bold">Ministerio de la Mujer</p>
    </div>
</body>
</html>