<div class="row-fluid">
    <div class="span12" style="text-align: right;">
        <a href="<?php echo base_url('acciones_personal/principal/incapacidad_empleado'); ?>" class="btn btn-info"><span class="silk-icon-undo white"> Regresar</span></a>
    </div>
</div>
<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div>
                <a href="<?php echo base_url('acciones_personal/principal/agregar_incapacidad/' . $emp['emp_id']); ?>" class="btn btn-large" title="Agregar Incapacidad">
                    <strong>Agregar Gestion de Incapacidad</strong>
                </a>
            </div>
            <div class="title">
                <h4><span>Registros para <?= $emp['emp_nombre'] ?> <?= $emp['emp_apellido'] ?></span></h4>
            </div>
            <div class="noPad content">
                <div class="row-fluid">
                    <div class="span12" >
                        <div class="noPad clearfix" id="dv_contenedor_listado" style="overflow: auto;height:100%;">                        
                            <table id="tabla_ordenes" class="dynamicTable responsive display table table-bordered" >
                                <thead>
                                    <tr>
                                        <th>Fecha Inicio</th>
                                        <th>Duración</th>
                                        <th>Observaciones</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="tbActions">
                                    <?php if (count($incapacidades) > 0): ?>
                                        <?php foreach ($incapacidades as $key => $value): ?>
                                            <tr>
                                                <td>
                                                    <span style="display: none;"><?= formatear_fecha('Ymd', $value['inc_fecha_inicio']) ?></span>
                                                    <span><?= formatear_fecha('d-m-Y', $value['inc_fecha_inicio']) ?></span>
                                                </td>
                                                <td><?= number_format($value['inc_dias']) . ' Días' ?></td>
                                                <td><?= $value['inc_observacion'] ?></td>
                                                <td>
                                                    <div class="tools">
                                                        <div class="btn-group">
                                                            <button class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>
                                                            <button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button>
                                                            <ul class="dropdown-menu">
                                                                <li>
                                                                    <a title="Ver" href="<?= base_url('acciones_personal/principal/ver_incapacidad/'.$emp['emp_id'].'/'.$value['inc_id']) ?>">
                                                                        <span aria-hidden="true" class="icomoon-icon-search-5"> Ver</span>
                                                                    </a>
                                                                </li>
                                                                <?php if ($value['pla_estado'] != 3 && $value['inc_estado'] > 0 && $permisos['permite_editar']) { ?>
                                                                    <li>
                                                                        <a title="Editar" href="<?= base_url('acciones_personal/principal/edit_incapacidad/'.$emp['emp_id'].'/'.$value['inc_id']) ?>">
                                                                            <span aria-hidden="true" class="icomoon-icon-pencil-5"> Editar</span>
                                                                        </a>
                                                                    </li>
                                                                <?php }
                                                                if ($value['pla_estado'] != 3 && $value['inc_estado'] > 0 && $permisos['permite_eliminar']) { ?>
                                                                    <li>
                                                                        <a title="Eliminar" class="dlt" href="<?= base_url('acciones_personal/principal/del_inc/'.$emp['emp_id'].'/'.$value['inc_id']) ?>">
                                                                            <span aria-hidden="true" class="cut-icon-trashcan"> Eliminar</span>
                                                                        </a>
                                                                    </li>
                                                                <?php } ?>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach ?>                                        
                                    <?php endif ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function(){  
        $('body').on('click', '.dlt', function(e){
            e.preventDefault();
            var url = $(this).attr('href');
            alerta_confirm_ajax(anular_inc, url, "Alerta confirmación", '¿Está seguro que desea anular esta Incapacidad?<br>Esta acción no se puede deshacer.'); 
        });
    });
    function anular_inc(url = "") {
        if (url != "") {
            window.open(url, '_self');
        }
    }
</script>