<script type="text/javascript">
	jQuery(document).ready(function($) {
        $(".contenedor_input").attr('style', 'width:70% !important;');
        window.gSateliteWhite.jsSelect();
        $("#periodo_vaca").change(function(event) {
            cargarDatosPeriodo($(this).val());
        });

        $("#generar").click(function(event) {
            if($("#periodo_vaca").valid()) {
                cargarDatosEmpleado($("#periodo_vaca").val(), $("#slc_sucursal").val(), $("#slc_area").val());
            }
        });

        //VALIDACION VALIDATE
        $('#genera_vacacion').validate({
            ignore: null, ignore: 'input[type="hidden"]',
            rules: {  } ,
            errorPlacement: function (error, element) {
                if($(element).is("select")){ $(element).next().append(error); }
                else {
                    error.insertAfter(element);
                }
            } 
        }); 

    });

    function cargarDatosPeriodo(id) {
        if(id>0){
            $.ajax({
                url: window.gSateliteWhite.baseUrl('acciones_personal/principal/datos_periodo_vacacion'),
                type: 'post',
                dataType: 'json',
                data: {
                    'id': id
                },
                beforeSend: function () {
                    $("#fecha_desde, #fecha_hasta, #dias").val('procesando...');
                },
                success: function(data) {
                    $("#fecha_desde").val(data.prv_desde);
                    $("#fecha_hasta").val(data.prv_hasta);
                    $("#dias").val(data.ndias);
                }
            });
        }
        else {
            $("#fecha_desde, #fecha_hasta, #dias").val('');
            $('#slc_area, #slc_sucursal').val(null).trigger('change');
            $('#slc_area, #slc_sucursal').select2();
            $("#contenedor_tabla_generar").hide('slow');
            $("#registrar").hide('slow');
        }
    }

    function cargarDatosEmpleado(id, suc, are) {
        wait.start();
        $("#contenedor_tabla_generar").hide();
        $("#registrar").hide();
        if(id>0){
            $.ajax({
                url: window.gSateliteWhite.baseUrl('acciones_personal/principal/datos_empleados'),
                type: 'post',
                dataType: 'json',
                data: {
                    'f1': $("#fecha_desde").val(),
                    'f2': $("#fecha_hasta").val(),
                    'nd': $("#dias").val(),
                    'ar': (are > 0) ? are : 0,
                    'sc': (suc > 0) ? suc : 0,
                    'id_p': $("#periodo_vaca").val()
                },
                success: function(data) {
                    wait.close();
                    $("#contenedor_tabla_generar").html(data.html);
                    $("#contenedor_tabla_generar").show('slow');
                    $("#registrar").show('slow');
                }
            });
        } else {
            $("#fecha_desde, #fecha_hasta, #dias").val('');
            $('#slc_area').val(null).trigger('change');
            $('#slc_sucursal').val(null).trigger('change');
            $('#slc_area, #slc_sucursal').select2();
            $("#contenedor_tabla_generar").hide('slow');
            $("#registrar").hide('slow');
        }
    }
</script>
<style type="text/css">
    .es_select label.error { margin-top: -8px !important; }
    .form-label{max-width: 150px; min-width: 150px;}
</style>
<div class="row-fluid">
	<div class="span12">
		<div class="box">
			<div class="title">
                <h4><span>Generar vacación</span></h4>
            </div>
            <div class="content">
                <form method="post" name="genera_vacacion"  id="genera_vacacion" autocomplete="off" >
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Periodo: <b style="color:red">*</b></label> 
                                <div class="span8 controls contenedor_input es_select">
                                    <select name="periodo_vaca" required id="periodo_vaca" class="nostyle" placeholder="Seleccione">
                                        <option value=""></option>
                                        <?php echo str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select_periodo_vaca); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Sucursal / Oficina:</label> 
                                <div class="span8 controls contenedor_input es_select">
                                    <select name="slc_sucursal" id="slc_sucursal" class="nostyle" placeholder="Seleccione">
                                        <option value=""></option>
                                        <?php echo str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slc_sucsl); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Área / Unidad Organizativa:</label> 
                                <div class="span8 controls contenedor_input es_select">
                                    <select name="slc_area" id="slc_area" class="nostyle" placeholder="Seleccione">
                                        <option value=""></option>
                                        <?php echo str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slc_areas); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Desde</label>
                                <div class="span8 controls contenedor_input">
                                    <input type="text" id="fecha_desde" required readonly name="fecha_desde" maxlength="15" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Hasta</label>
                                <div class="span8 controls contenedor_input">
                                    <input type="text" id="fecha_hasta" required readonly name="fecha_hasta" maxlength="15" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Días</label>
                                <div class="span8 controls contenedor_input">
                                    <input type="text" id="dias" style="width:70% !important;" required readonly name="dias" maxlength="15" />
                                    <button style="float:right;" type="button" id="generar" class="btn btn-success">
                                        <span class="icon16 icomoon-icon-checkmark white"> Consultar Empleadas/os</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid" id="contenedor_tabla_generar" style="overflow: auto; overflow-y:auto;padding-top:1px;padding-left:1px;height: 450px; display:none;">
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">&nbsp;</label>
                                <div class="span8 controls contenedor_input">
                                    <button style="float:right; display:none;" id="registrar" onclick="wait.start();" type="submit" class="btn btn-success">
                                        <span class="icon16 icomoon-icon-checkmark white"> Registrar Vacaciones</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
