<?php
$n_dias = $registro['gva_dias'];
$dias_trabajados_mes = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES');
$param_tipo_desc_vac = $this->gsatelite->get_parametro('ID_TDC_VACACION');
$calculo_monto1 = (($base_calculo_vacacion / $dias_trabajados_mes ) * $n_dias);//monto del descuento tambien
$calculo_monto2 = ($calculo_monto1 * $factor_calculo_vacacion);
$apply_des = (trim($param_tipo_desc_vac) != "") ? "" : 'style="display: none;"';
?>
<form id="form_fecha" action="<?php base_url("acciones_personal/principal/editar_detalle_vacacion/".$registro['gva_id']) ?>" method="POST">
    <div class="row-fluid">
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4>
                        <span>VACACIÓN EMPLEADO:  <?php echo ' '.$registro['emp_codigo']. " - ".ucwords($registro['emp_nombre'])." ".ucwords($registro['emp_apellido']); ?></span>
                    </h4>
                    <input type="hidden" id="salario_empleado" name="salario_empleado" value="<?php echo $base_calculo_vacacion;  ?>" />
                    <input type="hidden" id="factor_calculo_vacacion" value="<?php echo $factor_calculo_vacacion;  ?>" />
                    <input type="hidden" id="emp_id" name="emp_id" value="<?php echo $registro['emp_id']; ?>" >
                    <input type="hidden" id="id_gva_actual" value="<?= $registro['gva_id'];  ?>" />
                    <button  type="button" class="btn btn-info" id="regresar" style="position: absolute;top: 7%;right: 1%;">
                        <span class="icon16 icomoon-icon-undo-2 white"> Regresar</span>
                    </button>
                </div>
                <div class="content">
                    <div class="page-header">
                        <h4 style="font-size: 18px;">Goce de Vacación</h4>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div align="center" style="text-align:center; width:80% !important;"   class="row-fluid" id="contenedor_periodos">
                                <div style="margin-left:10%;" class="span8 controls">
                                    <table  style="font-size:12px;" align="center" class="responsive table table-bordered" id="tabla_consulta" >
                                        <thead>
                                            <tr>
                                                <th> Periodos </th>
                                                <th> Detalle </th>
                                                <th> Dias Disponibles </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                            $suma = 0;
                                            foreach ($vacaciones as $fila) {
                                                $n_dias_dis = $fila["vac_dia_ganado"] - $fila["vac_dia_gozado"];
                                                $suma += $n_dias_dis;
                                                ?>
                                                <tr>
                                                    <td><?php echo $fila["prv_nombre"]; ?></td>
                                                    <td><?php echo $fila["prv_desde"] . " / " . $fila["prv_hasta"]; ?></td>
                                                    <td><?php echo $n_dias_dis; ?></td>
                                                </tr>
                                                <?php 
                                            }
                                            ?>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="2">TOTAL</td>
                                                <td><?php echo $suma; ?></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php 
                    $desde = formatear_fecha('d-m-Y', $vacaciones[0]['prv_desde']);
                    $hasta = formatear_fecha('d-m-Y', $vacaciones[0]['prv_hasta']); 
                    $dia_total = intval($vacaciones[0]['vac_dia_ganado']);
                    $dias_used = intval($vacaciones[0]['vac_dia_gozado']);
                    $este_prdo = intval($registro['gva_dias']);
                    $otros_pdo = $dias_used - $este_prdo;
                    $dias_maxm = $este_prdo + ($dia_total - $dias_used);
                    ?>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Periodo: </label>
                                <div class="span8 controls contenedor_input">
                                    <input type="hidden" id="vac_f1" value="<?= $vacaciones[0]['prv_desde'];?>" />
                                    <input type="hidden" id="vac_f2" value="<?= $vacaciones[0]['prv_hasta'];?>" />
                                    <input type="hidden" id="actualmente" value="<?= $este_prdo ?>" />
                                    <input type="hidden" id="dias_dis_periodo" value="<?= ($vacaciones[0]['vac_dia_ganado'] - $vacaciones[0]['vac_dia_gozado']); ?>" />
                                    <input type="hidden" name="id_vac" id="id_vac" value="<?= $vacaciones[0]['vac_id']; ?>" />
                                    <input type="text" name="periodo_vac" id="periodo_vac" value="<?= $desde.' / '.$hasta.' (Máximo disponible: '.$dias_maxm.' día)'; ?>" readonly />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Vacación Desde: </label>
                                <div class="span8 controls contenedor_input">
                                    <input type="text" id="fecha_desde" name="fecha_desde" class="datepicker" onchange="$('#fecha_desde_error').html('')" value="<?= formatear_fecha('d-m-Y',$registro['gva_desde']); ?>"/>
                                    <input type="hidden" id="fecha_desde_org" value="<?= formatear_fecha('d-m-Y',$registro['gva_desde']); ?>">
                                    <div id="fecha_desde_error" style="color: red;"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Vacación Hasta: </label>
                                <div class="span8 controls contenedor_input">
                                    <input type="text" id="fecha_hasta" name="fecha_hasta" class="datepicker" onchange="$('#fecha_hasta_error').html('')" value="<?= formatear_fecha('d-m-Y',$registro['gva_hasta']); ?>" />
                                    <input type="hidden" id="fecha_hasta_org" value="<?= formatear_fecha('d-m-Y',$registro['gva_hasta']); ?>">
                                    <div id="fecha_hasta_error" style="color: red;"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="form-label span3">Dias: </label>
                                <div class="span8 controls contenedor_input">
                                    <input type="text" id="n_dias" name="n_dias" value="<?= $registro['gva_dias']; ?>" readonly/>
                                    <input type="hidden" id="monto" name="monto" value="<?= number_format($calculo_monto1,2,'.','') ?>" />
                                    <input type="hidden" id="monto_orig" name="monto_orig" value="<?= number_format($calculo_monto1,2,'.','') ?>" />
                                    <input type="hidden" id="monto_factor" name="monto_factor" value="<?= number_format($calculo_monto2,2,'.','') ?>" />
                                    <input type="hidden" id="monto_factor_orig" name="monto_factor_orig" value="<?= number_format($calculo_monto2,2,'.','') ?>" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <br />
                    <div class="form-actions" style="text-align: -webkit-center;">
                        <button type="submit" class="btn btn-success" id="enviar_form">
                            <span class="icon16 icomoon-icon-checkmark white"> Guardar y Regresar a la Lista</span>
                        </button>
                        <a href="<?= base_url("acciones_personal/principal/gestion_vacaciones_empleado/".$registro['emp_id']); ?>" class="btn btn-danger btn-cancelar">
                            <span class="icon16 icomoon-icon-cancel"> Cancelar </span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<script type="text/javascript">
    $(document).ready(function($) {
        $(".datepicker").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
        $(".datepicker").mask('99-99-9999');
        $('#regresar').click(function(event) {
            window.location.href = "<?= base_url("acciones_personal/principal/gestion_vacaciones_empleado/".$registro['emp_id']); ?>";
        });
        $("#fecha_desde, #fecha_hasta").change(function(event) {
            ndias_entre_fechas($("#fecha_desde").val(),$("#fecha_hasta").val());
        });
        $("#enviar_form").mouseover(function(event) {
            ndias_entre_fechas($("#fecha_desde").val(),$("#fecha_hasta").val());
        });
        $("#form_fecha").validate({
            rules: {
                fecha_desde: {required: true},
                fecha_hasta: {required: true}
            },
            errorPlacement: function (error, element) {
                var nombre = $(element).attr("id");
                $('#'+nombre+'_error').text('Campo requerido');
            },
            submitHandler: function (form){
                var dias = $("#n_dias").val();
                if ( $.trim(dias) != "") {
                    form.submit();
                } else {
                    crear_alerta('error', 'Atención', 'Verifique la información ingresada.');
                    return false;
                }
            }
        });
    });
    function ndias_entre_fechas(fecha1,fecha2) {
        var dias_trabajados_mes = <?= $dias_trabajados_mes ?>;
        if(fecha1 != "" && fecha2!="" ) {
            $.ajax({
                url: window.gSateliteWhite.baseUrl('acciones_personal/principal/n_dias_fechas'),
                type: 'post',
                dataType: 'json',
                data: {
                    'f1': fecha1,
                    'f2': fecha2,
                    'id_empleado': $("#emp_id").val(),
                    'editar_gvas': $("#id_gva_actual").val()
                },
                success: function(data) {
                    if(data.num_dias > 0) {
                        ahora = parseFloat($("#actualmente").val());
                        adicc = parseFloat($("#dias_dis_periodo").val());
                        dis_p = ahora + adicc;
                        if(parseFloat(dis_p) < parseFloat(data.num_dias)) {
                            crear_alerta('error', data.num_dias+' Dias','La diferencia de dias entre fechas no debe sobrepasar la disponibilidad (<b>'+dis_p+' Dias</b>)');
                            $("#n_dias, #fecha_hasta").val('');
                            return false;
                        } else if(data.error_per) {
                            crear_alerta('error', 'Periodos erroneos','Ya existen otros registros con esas fechas incluidas');
                            $("#n_dias, #fecha_desde, #fecha_hasta").val('');
                            return false;
                        } else {
                            calculo_monto1 = ((parseFloat($("#salario_empleado").val()) / dias_trabajados_mes ) * parseInt(data.num_dias));
                            calculo_monto2 = calculo_monto1 *  parseFloat($("#factor_calculo_vacacion").val());
                            $("#monto").val(calculo_monto1.toFixed(2));  
                            $("#monto_factor").val(calculo_monto2.toFixed(2));
                            $("#n_dias").val(data.num_dias);
                        }
                    } else {
                        crear_alerta('error','Período de Fechas','Verifique que las fechas ingresadas sean validas');
                        $("#n_dias").val('');
                    }
                }
            });
        } else {
            $("#n_dias").val('');
        }
    }
</script>