<?php
if ($tipo > 0) {
    $p = true;
} else {
    $p = false;
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=empleados_retirados.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table border="1">
            <tr>
                <td align="center" colspan="5" >
                    <h4><?= mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br />
                        Reporte de empleados retirados
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <?php
}
?>
<table cellpadding="2" cellspacing="0" border="1" class="table" width="100%">
    <thead>
        <tr>
            <th <?= ($p) ? 'width="36%"' : ''; ?>><b>Empleada/o</b></th>
            <th <?= ($p) ? 'width="14%"' : ''; ?>><b>¿Recontratable?</b></th>
            <th <?= ($p) ? 'width="26%"' : ''; ?>><b>Categoría de retiro</b></th>    
            <th <?= ($p) ? 'width="14%"' : ''; ?>><b>Fecha de retiro</b></th>  
            <th <?= ($p) ? 'width="10%"' : ''; ?>><b>Autorizado</b></th>  
        </tr>
    </thead>
    <tbody>
        <?php 
        if (count($total_empleados) > 0) {
            foreach ($total_empleados as $k => $emp) {
                ?>
                <tr nobr="true">
                    <td <?= ($p) ? 'width="36%"' : ''; ?>><?= $emp['emp_nombre'] . ' ' . $emp['emp_apellido']?></td>
                    <td <?= ($p) ? 'width="14%"' : ''; ?>><?= ($emp['rte_recontratable'] == 1) ? 'SI' : 'NO'; ?></td>
                    <td <?= ($p) ? 'width="26%"' : ''; ?>><?= $emp['ctr_nombre']?></td>
                    <td <?= ($p) ? 'width="14%"' : ''; ?>><?= formatear_fecha('d-m-Y', $emp['rte_fecha_retiro']); ?></td>
                    <td <?= ($p) ? 'width="10%"' : ''; ?>><?= ($emp['rte_autorizar_ret'] > 0) ? 'SI' : 'NO'; ?></td>
                </tr>
                <?php
            }
        } else {
            ?>
            <tr>
                <td colspan="5" style="font-weight: bold; text-align: center;">No se encontraron registros</td>
            </tr>
            <?php
        }
        ?>
    </tbody>
</table>