<?php if (isset($permisos_empleado) && count($permisos_empleado) > 0) {
    $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
    foreach ($permisos_empleado as $key => $value) {         
        $estado = '';
        switch ($value['estado_actual']) {
            case 1:
                $estado = 'Creado';
                break;
            case 2:
                $estado = ($value['hxe_enterado_rrhh'] == 1) ? 'Enterado' :  'Autorizado';
                break;
            case 0:
                $estado = 'Rechazado';
                break;
        }
        ?>
        <tr>
            <td><?php echo $value['tipo_permiso']; ?></td>
            <td><?php echo $value['nombre_completo']; ?></td>
            <td><?php echo formatear_fecha('d-m-Y', $value['periodo_desde']); ?></td>
            <td><?php echo formatear_fecha('d-m-Y', $value['periodo_hasta']); ?></td>
            <td><?php echo $value['jornada_desde']; ?></td>
            <td><?php echo $value['jornada_hasta']; ?></td>            
            <td><?php echo $value['observacion']; ?></td>            
            <td><?php echo $estado; ?></td>
            <td>
                <div class="tools">
                    <div class="btn-group">
                        <button class="btn" type="button"><span class="icon16 icomoon-icon-cog-2"></span></button>
                        <button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button>
                        <ul class="dropdown-menu">
                            <li>
                                <a class="ver_accion_modal" href="<?php echo base_url('acciones_personal/principal/estado_aprobacion_permiso/' . $value['hxe_id']); ?>/1"   >
                                    <span aria-hidden="true" class="icomoon-icon-grid-view"> Detalle del permiso</span>
                                </a>
                            </li>
                            <?php
                            if ($empresa == 'midem' && $value['estado_actual'] == 2 && $value['hxe_enterado_rrhh'] != 1) {
                                ?>
                                <li>
                                    <a class="ver_accion_modal" href="<?php echo base_url('acciones_personal/principal/vistobueno/' . $value['hxe_id']); ?>/2">
                                        <span aria-hidden="true" class="icomoon-icon-checkbox-2">Validar Aprobación</span>
                                    </a>
                                </li>
                                <?php 
                            } ?>
                            <?php if ($value['estado_actual'] > 0) { ?>
                                <li>
                                    <a class="ver_accion_modal" href="<?php echo base_url('acciones_personal/principal/estado_aprobacion_permiso/' . $value['hxe_id']); ?>/2">
                                        <span aria-hidden="true" class="icomoon-icon-checkmark"> <?= ($value['estado_actual'] == 2) ? "Revocación" : "Aprobación"; ?></span>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
            </td>
        </tr>
    <?php }
} ?>
