<?php if (isset($permisos_empleado) && count($permisos_empleado) > 0) {
    foreach ($permisos_empleado as $key => $value) {         
        $estado = '';
        switch ($value['tce_estado']) {
            case 1:
                $estado = 'Creado';
                break;
            case 2:
                $estado = 'Autorizado';
                break;
            case 0:
                $estado = 'Rechazado';
                break;
        }
        ?>
        <tr>
            <td><?php echo $value['emp_codigo'] . " - " . $value['emp_nombre'] . " " . $value['emp_apellido']; ?></td>
            <td><span style="display:none;"><?= formatear_fecha('YmdHis',$value['tce_fecha_registro']) ?></span><?= formatear_fecha('d-m-Y', $value['tce_fecha_registro']) ?></td>
            <td><span style="display:none;"><?= formatear_fecha('Ymd', $value['tce_fecha_desde']); ?></span><?php echo formatear_fecha('d-m-Y', $value['tce_fecha_desde']); ?></td>
            <td><span style="display:none;"><?= formatear_fecha('Ymd', $value['tce_fecha_hasta']); ?></span><?php echo formatear_fecha('d-m-Y', $value['tce_fecha_hasta']); ?></td>
            <td><span style="display:none;"><?= formatear_fecha('His', $value['tce_hora_inicio']); ?></span><?php echo formatear_fecha('H:i', $value['tce_hora_inicio']); ?></td>
            <td><span style="display:none;"><?= formatear_fecha('His', $value['tce_hora_final']); ?></span><?php echo formatear_fecha('H:i', $value['tce_hora_final']); ?></td>
            <td><?php echo $value['tce_motivo']; ?></td>            
            <td><?php echo $estado; ?></td>
            <td>
                <div class="tools">
                    <div class="btn-group">
                        <button class="btn" type="button"><span class="icon16 icomoon-icon-cog-2"></span></button>
                        <button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button>
                        <ul class="dropdown-menu">
                            <li>
                                <a class="ver_accion_modal" href="<?php echo base_url('acciones_personal/principal/estado_aprobacion_compensatorio/' . $value['tce_id']); ?>/1"   >
                                    <span aria-hidden="true" class="icomoon-icon-grid-view"> Ver Detalle</span>
                                </a>
                            </li>
                            <?php if ($value['tce_estado'] == 1) { ?>
                                <li>
                                    <a class="ver_accion_modal" href="<?php echo base_url('acciones_personal/principal/estado_aprobacion_compensatorio/' . $value['tce_id']); ?>">
                                        <span aria-hidden="true" class="icomoon-icon-checkmark"> Aprobar | Rechazar</span>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
            </td>
        </tr>
    <?php }
} ?>
