<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }

        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                       Reporte de retiro de personal
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>



<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {
    ?>
    
    <table class="">
        <tr><td colspan="4"></td></tr>
        <tr>
            <td style="width: 20%; text-align: left;"><b>Desde:</b></td>
            <td style="text-align: left;"><?php echo formatear_fecha('Y-m-d',$fecha_inicio); ?></td>       
            <td style="width: 20%; text-align: left;"><b>Hasta:</b></td>
            <td style="text-align: left;"><?php echo formatear_fecha('Y-m-d',$fecha_fin); ?></td>             
        </tr>
        <tr>
            <td style="width: 20%; text-align: left;"><b>Área:</b></td>
            <td style="text-align: left;"><?php echo $area_nombre; ?></td>            
        </tr>
        <tr><td colspan="4"></td></tr>
    </table>
    <div></div>
    <table class="tabla">
        <thead>
            <tr>
                <th>Código empleado</th>
                <th>Nombre</th>
                <th>Apellido</th>
                <th>Fecha retiro</th>
                <th>Puesto</th>
                <th>Área</th>
                <th>Motivo de retiro</th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>

        <?php
        $i      = 1;
        $total  = 0;
        foreach ($reporte as $row):
            $total = $total + $row['emp_salario'];
        ?>
            <tr class="dato">
                <td><?php echo $row['emp_codigo']; ?></td>
                <td><?php echo $row['emp_nombre']; ?></td>
                <td><?php echo $row['emp_apellido']; ?></td>
                <td><?php echo formatear_fecha('Y-m-d',$row['rte_fecha_retiro']); ?></td>
                <td></td>
                <td><?php echo $row['are_nombre']; ?></td>
                <td><?php echo $row['rte_motivo_retiro']; ?></td>
            </tr>
            <?php
            $i++;
        endforeach;
        ?>
        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
            ?>
        </tbody> 
    </table>
<?php } ?>

