<div class="row-fluid">
    <div class="span12">
        <div class="box gradient">
            <div class="title">
                <h4>
                    <span>Consulta Permisos</span>
                </h4>
            </div>
            <div class="content">
                <div class="form-row row-fluid">
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span4">Desde: <b class="red">*</b></label>
                                <div class="span7 controls">
                                    <input type="text" class="fecha_rep" name="fecha_ini" id="fecha_ini" placeholder="dd-mm-yyyy" value="<?= date('01-m-Y') ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span4">Hasta: <b class="red">*</b></label>
                                <div class="span7 controls">
                                    <input type="text" class="fecha_rep" name="fecha_fin" id="fecha_fin" placeholder="dd-mm-yyyy" value="<?= date('t-m-Y') ?>"/>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span4" >Empleada/o:</label>
                                <div class="span7 controls">
                                    <select name="empleado" id="empleado" class="nostyle" placeholder="Seleccione">
                                        <option value=""></option>
                                        <?= str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $empleados) ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span4" >Estado:</label>
                                <div class="span7 controls">
                                    <select name="estado" id="estado" class="nostyle" placeholder="Seleccione">
                                        <option value=""></option>
                                        <option value="2">Aprobado</option>
                                        <option value="1">Creado</option>
                                        <option value="0">Rechazado</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-row row-fluid">
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <button type="button" id="buscar" class="btn btn-info  icomoon-icon-search-3 white"><b> Consultar</b></button>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid" style="text-align: right;">
                                <form target="_blank" id="frm-descarga" method="POST" action="<?= base_url('acciones_personal/consultas/horas_permisos') ?>">
                                    <input type="hidden" name="txt_fecha_ini" id="txt_fecha_ini" value="">
                                    <input type="hidden" name="txt_fecha_fin" id="txt_fecha_fin" value="">
                                    <input type="hidden" name="txt_empleado" id="txt_empleado" value="">
                                    <input type="hidden" name="txt_estado" id="txt_estado" value="">
                                    <button type="submit" name="reporte" class="btn btn-info botones_export_print" style="display: none;" value="excel" title="Exportar a excel">
                                        <strong><span class="icomoon-icon-file-excel white"></span>Exportar a Excel</strong>
                                    </button>
                                    <button type="submit" name="reporte" class="btn btn-info botones_export_print" style="display: none;" value="pdf" title="Exportar a PDF" >
                                        <strong><span class="icomoon-icon-file-pdf white"></span>Exportar PDF</strong>
                                    </button>
                                </form>
                            </div>
                        </div> 
                    </div>
                </div>
            </div>
        </div>
        <div class="clear"></div>
        <div class="box gradient">
            <div class="title">
                <h4>
                    <span class="icon16 icomoon-icon-equalizer-2"></span>
                    <span>Permisos</span>
                </h4>
            </div>
            <div class="content noPad clearfix">
                <input type="hidden"  name="rpt_prv" id="rpt_prv" />
                <div id="contenido">
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function($){
        $(".fecha_rep").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
        $(".fecha_rep").mask("99-99-9999");
        $("select").select2();
        $("#buscar").click(function(event){
            $(".botones_export_print").hide();
            var fecha_ini = $("#fecha_ini").val();
            var fecha_fin = $("#fecha_fin").val();
            var empleado = $("#empleado").val();
            var estado = $("#estado").val();
            if (fecha_ini == "" || fecha_fin == "") {
                crear_alerta('warning', 'Período de Fechas', 'Ambas fechas son requeridas.');
                return false;
            }
            if (verifica_fecha(fecha_ini,fecha_fin)) {
                $.ajax({
                    dataType: 'json',
                    type: 'POST',
                    url: urlj + 'acciones_personal/consultas/horas_permisos/1',
                    data: {
                        txt_fecha_ini: fecha_ini,
                        txt_fecha_fin: fecha_fin,
                        txt_empleado: empleado,
                        txt_estado: estado,
                        reporte: ''
                    },
                    beforeSend: function(){
                        wait.start();
                    },
                    success: function(data){
                        $("#contenido").html(data.tabla);
                        $('#tabla').dataTable();
                        if(data.filas > 0){
                            $("#txt_fecha_ini").val(fecha_ini);
                            $("#txt_fecha_fin").val(fecha_fin);
                            $("#txt_empleado").val(empleado);
                            $("#txt_estado").val(estado);
                            $(".botones_export_print").show();
                        }
                        wait.close();
                    }
                });
            }
        });
    });

    function verifica_fecha(fecha_ini, fecha_fin){
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
            crear_alerta('error', 'Período de Fechas', 'Verifique las fechas del período.');
            return false;
        } else {
            return true;
        }        
    }
</script>