<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("Content-Disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte): ?>
<table border="0" width="100%" cellpadding="4" cellspacing="3">
  <tr><td colspan="9" align="right">Formulario No.AJ-PER-03</td></tr>
  <tr><td colspan="9" align="center"><h1><?= mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?></h1></td></tr>
  <tr><td colspan="9" align="center"><h2>Oficina Institucional de Recursos Humanos</h2></td></tr>
  <tr><td colspan="9" align="center"><h3>CONTROL DE TIEMPO DE PERMISOS</h3></td></tr>
  <tr><td colspan="9" style="height:10px;"></td></tr>
  <tr><td colspan="3"><h4>Nombre del servidor público:</h4></td><td colspan="9" style="border-bottom:solid 1px black;"></td></tr>
  <tr><td colspan="3"><h4>Puesto Desempeñado:</h4></td><td colspan="9" style="border-bottom:solid 1px black;"></td></tr>
  <tr><td colspan="3"><h4>Unidad Administrativa:</h4></td><td colspan="9" style="border-bottom:solid 1px black;"></td></tr>
  <tr><td colspan="4"><strong>Posición No.:</strong> _____________</td><td colspan="5"><strong>Mes:</strong> _____________</td></tr>
</table>
<br><br>
<?php endif; ?>

<table border="1" cellspacing="0" cellpadding="4">
  <?php if ($tipo_reporte): ?>
  <thead>
    <tr>
      <th rowspan="2">No.</th>
      <th rowspan="2">Motivo</th>
      <th colspan="2">Desde</th>
      <th colspan="2">Hasta</th>
      <th colspan="3">Tiempo Utilizado</th>
    </tr>
    <tr>
      <th>Hora</th>
      <th>Fecha</th>
      <th>Hora</th>
      <th>Fecha</th>
      <th>Días</th>
      <th>Horas</th>
      <th>Min.</th>
    </tr>
  </thead>
  <?php endif; ?>
  <tbody>
<?php
$total_horas = 0.0;

$i = 0;

foreach ($reporte as $r) {
    $i++;
    $horas = floatval($r['horas_utilizadas']);
    $total_horas += $horas;

    echo "<tr>";
    echo "<td>{$i}</td>";
    echo "<td>{$r['tce_motivo']}</td>";
    echo "<td>" . substr($r['desde_hora'], 0, 5) . "</td>";
    echo "<td>" . date('d/m/Y', strtotime($r['desde_fecha'])) . "</td>";
    echo "<td>" . substr($r['hasta_hora'], 0, 5) . "</td>";
    echo "<td>" . date('d/m/Y', strtotime($r['hasta_fecha'])) . "</td>";
    echo "<td></td>"; // Días
    echo "<td>" . number_format($horas, 2) . "</td>"; // Horas
    echo "<td></td>"; // Minutos
    echo "</tr>";
}

echo "<tr style='font-weight:bold; background:#eee;'>";
echo "<td></td>"; // No.
echo "<td align='right'>Total Horas Utilizadas:</td>"; // Motivo
echo "<td></td>"; // Desde Hora
echo "<td></td>"; // Desde Fecha
echo "<td></td>"; // Hasta Hora
echo "<td></td>"; // Hasta Fecha
echo "<td></td>"; // Días
echo "<td>" . number_format($total_horas, 2) . "</td>"; // Total Horas
echo "<td></td>"; // Minutos
echo "</tr>";
?>
  </tbody>
</table>


<?php if ($tipo_reporte): ?>

  <br><br>

    <!-- Fila Total Anual -->
    <table width="100%" cellpadding="4" cellspacing="0">
      <tr>
        <td colspan="6"></td>
        <td colspan="2" align="right"><strong>Total Anual</strong></td>
        <td style="border: 1px solid #000; width: 20px; height: 20px;"></td>
        <td style="border: 1px solid #000; width: 20px; height: 20px;"></td>
        <td style="border: 1px solid #000; width: 20px; height: 20px;"></td>
      </tr>
    </table>

    <br>
    <br>
    <br>

    <table width="100%" cellpadding="4" cellspacing="0">
      <tr>
        <!-- <td colspan="6"></td> -->
        <td colspan="8" align="right"><strong>Sobre giro el uso del tiempo por: </strong></td>
        <td style="border: 1px solid #000; width: 20px; height: 20px;"></td>
        <td style="border: 1px solid #000; width: 20px; height: 20px;"></td>
        <td style="border: 1px solid #000; width: 20px; height: 20px;"></td>
      </tr>
    </table>

    <br>

    <!-- Sección de Sobregiro -->
    <table width="100%" cellpadding="4" cellspacing="4">
      <tr>
        <td>Los pagará por</td>
        <td style="border: 1px solid #000; width: 20px; height: 20px;"></td>
        <td nowrap>Horas Extraordinarias</td>
        <td style="border: none"></td>
        <td nowrap></td>
      </tr>
      <tr>
        <td></td>
        <td style="border: 1px solid #000; width: 20px; height: 20px;"></td>
        <td nowrap>Vacaciones</td>
        <td style="none"></td>
        <td nowrap></td>
      </tr>
    </table>

    <br><br><br><br>

    <!-- Firmas -->
    <table width="100%" cellpadding="4" cellspacing="0">
      <tr>
        <td style="border-top: 1px solid #000;" align="center" width="40%">
          Firma del Analista de Recursos Humanos
        </td>
        <td  align="center" width="20%">
        </td>
        <td style="border-top: 1px solid #000;" align="center" width="40%">
          Firma del Jefe de la OIRH
        </td>
      </tr>
    </table>

  
<?php endif ?>
