<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("Content-Disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte): ?>
<table border="0" width="100%" cellpadding="4" cellspacing="3">
  <tr><td colspan="12" align="right">Formulario No.AJ-TC-06</td></tr>
  <tr><td colspan="12" align="center"><h1><?= mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?></h1></td></tr>
  <tr><td colspan="12" align="center"><h2>Oficina Institucional de Recursos Humanos</h2></td></tr>
  <tr><td colspan="12" align="center"><h3>CONTROL DEL USO DEL TIEMPO COMPENSATORIO</h3></td></tr>
  <tr><td colspan="12" style="height:10px;"></td></tr>
  <tr><td colspan="6"><h4>Nombre del servidor público:</h4></td><td colspan="6" style="border-bottom:solid 1px black"></td></tr>
  <tr><td colspan="6"><h4>Puesto Desempeñado:</h4></td><td colspan="6" style="border-bottom:solid 1px black"></td></tr>
  <tr><td colspan="6"><h4>Unidad Administrativa:</h4></td><td colspan="6" style="border-bottom:solid 1px black"></td></tr>
  <tr><td colspan="6"><strong>Posición No.:</strong> _____________</td><td colspan="6"><strong>Mes:</strong> _____________</td></tr>
</table>
<br><br>
<?php endif; ?>

<table border="1" cellspacing="0" cellpadding="4">
<?php if ($tipo_reporte): ?>
  <thead>
    <tr>
      <th rowspan="2">No.</th>
      <th rowspan="2">Fecha</th>
      <th colspan="2">Horas Extraordinarias Laboradas</th>
      <th colspan="2">Cantidad</th>
      <th colspan="2">Acumulado</th>
      <th rowspan="2">Fecha</th>
      <th colspan="2">Tiempo Utilizado</th>
      <th rowspan="2">Saldo</th>
    </tr>
    <tr>
      <th>Desde</th>
      <th>Hasta</th>
      <th>Horas</th>
      <th>Min.</th>
      <th>Horas</th>
      <th>Min.</th>
      <th>Horas</th>
      <th>Min.</th>
    </tr>
  </thead>
<?php endif; ?>

<tbody>
<?php
$acumulado = 0.0;
$contador = 1;
$seen = [];

$total_cantidad = 0.0;
$total_utilizado = 0.0;
$seen_ids_para_total = [];

foreach ($reporte as $r) {
    $tce_id = $r['tce_id'];
    $cantidad = floatval($r['cantidad_horas']);
    $utilizado = floatval($r['horas_utilizadas']);
    $saldo = floatval($r['saldo']);

    $mostrar = !in_array($tce_id, $seen);
    if ($mostrar) {
        $acumulado += $cantidad;
        $seen[] = $tce_id;
        $contador++;
    }

    echo "<tr>";
    echo $mostrar ? "<td>" . ($contador - 1) . "</td>" : "<td></td>";
    echo $mostrar ? "<td>" . date('d/m/Y', strtotime($r['fecha_compensada'])) . "</td>" : "<td></td>";
    echo $mostrar ? "<td>" . substr($r['hora_desde'], 0, 5) . "</td>" : "<td></td>";
    echo $mostrar ? "<td>" . substr($r['hora_hasta'], 0, 5) . "</td>" : "<td></td>";
    echo $mostrar ? "<td>{$cantidad}</td>" : "<td></td>";
    echo "<td></td>"; // Minutos vacíos
    echo $mostrar ? "<td>{$acumulado}</td>" : "<td></td>";
    echo "<td></td>"; // Minutos vacíos acumulado
    echo "<td>" . formatear_fecha('d/m/Y', $r['fecha_uso']) . "</td>";
    echo "<td>{$utilizado}</td><td></td>";
    echo "<td>{$saldo}</td>";
    echo "</tr>";

    if (!in_array($tce_id, $seen_ids_para_total)) {
        $total_cantidad += $cantidad;
        $seen_ids_para_total[] = $tce_id;
    }
    $total_utilizado += $utilizado;
}

$total_saldo = $total_cantidad - $total_utilizado;
?>

<tr style="font-weight:bold; background:#eee;">
  <td colspan="4" align="right">Totales</td>
  <td><?= number_format($total_cantidad, 2) ?></td>
  <td></td>
  <td><?= number_format($total_cantidad, 2) ?></td>
  <td></td>
  <td></td>
  <td><?= number_format($total_utilizado, 2) ?></td>
  <td></td>
  <td><?= number_format($total_saldo, 2) ?></td>
</tr>
</tbody>
</table>
