<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte Incapacidades
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>



<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {
?>

    <table class="">
        <tr>
            <td colspan="4"></td>
        </tr>
        <tr>
            <td style="width: 20%; text-align: left;"><b>Desde:</b></td>
            <td style="text-align: left;"><?php echo formatear_fecha('Y-m-d', $fecha_inicio); ?></td>
            <td style="width: 20%; text-align: left;"><b>Hasta:</b></td>
            <td style="text-align: left;"><?php echo formatear_fecha('Y-m-d', $fecha_fin); ?></td>
        </tr>
        <tr>
            <td colspan="4"></td>
        </tr>
    </table>
    <div></div>
    <table class="tabla">
        <thead>
            <tr>
                <th <?= ($tipo_reporte == 'pdf') ? 'width="2%"' : ""; ?>><b>#</b></th>
                <th <?= ($tipo_reporte == 'pdf') ? 'width="5%"' : ""; ?>><b>Codigo</b></th>
                <th <?= ($tipo_reporte == 'pdf') ? 'width="18%"' : ""; ?>><b>Empleada/o</b></th>
                <th <?= ($tipo_reporte == 'pdf') ? 'width="15%"' : ""; ?>><b>Tipo incapacidad</b></th>
                <th <?= ($tipo_reporte == 'pdf') ? 'width="13%"' : ""; ?>><b>Periodo</b></th>
                <th <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ""; ?>><b>Numero de dias</b></th>
                <th <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ""; ?>><b>Fecha inicio</b></th>
                <th <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ""; ?>><b>Monto empresa</b></th>
                <th <?= ($tipo_reporte == 'pdf') ? 'width="20%"' : ""; ?>><b>Concepto</b></th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>

        <?php foreach ($reporte as $key => $row) : ?>
            <?php
            if ($row['pla_fecha_inicio'] != "" && $row['pla_fecha_fin'] != "") {
                $periodo = formatear_fecha('d-m-Y', $row['pla_fecha_inicio']) . " hasta " . formatear_fecha('d-m-Y', $row['pla_fecha_fin']);
            } else {
                $periodo = "--";
            }
            ?>
            <tr>
                <td <?= ($tipo_reporte == 'pdf') ? 'width="2%"' : ""; ?>><?php echo ($key + 1); ?></td>
                <td <?= ($tipo_reporte == 'pdf') ? 'width="5%"' : ""; ?>><?php echo $row['emp_codigo']; ?></td>
                <td <?= ($tipo_reporte == 'pdf') ? 'width="18%"' : ""; ?>><?php echo $row['emp_nombre'] . " " . $row['emp_apellido']; ?></td>
                <td <?= ($tipo_reporte == 'pdf') ? 'width="15%"' : ""; ?>><?php echo $row['tnc_nombre']; ?></td>
                <td <?= ($tipo_reporte == 'pdf') ? 'width="13%"' : ""; ?>><?php echo $periodo; ?></td>
                <td <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ""; ?> style="text-align: right;"><?php echo $row['inc_dias']; ?></td>
                <td <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ""; ?>><?php echo formatear_fecha('d-m-Y', $row['inc_fecha_inicio']); ?></td>
                <td <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ""; ?> style="text-align: right;"><?= $simbolo ?><?php echo number_format($row['inc_monto_empresa'], 2) ?></td>
                <td <?= ($tipo_reporte == 'pdf') ? 'width="20%"' : ""; ?>><?php echo $row['inc_concepto']; ?></td>
            </tr>
        <?php
        endforeach;
        ?>
        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
        ?>
        </tbody>
    </table>
<?php } ?>