<?php
$dia_lab = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA', 8);
if ($tipo_reporte == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=resumen_permisos_empleados.xls");
}
if (count($empleados) > 0) {
    foreach ($empleados as $ke => $employee) {
?>
        <table style="font-size:10px;" class="responsive table table-bordered" border="1">
            <thead>
                <tr>
                    <th><b><?php echo $employee['emp_codigo'] . ' - ' . $employee['emp_nombre'] . ' ' . $employee['emp_apellido']; ?></b></th>
                    <th colspan="12"><b>Horas Acumuladas de Permisos Solicitados</b></th>
                    <th colspan="3"><b>Resumen en Horas</b></th>
                    <th colspan="4"><b>Resumen en Días</b></th>
                </tr>
                <tr>
                    <th><b>Año <?php echo $anio; ?></b></th>
                    <th><b>Ene</b></th>
                    <th><b>Feb</b></th>
                    <th><b>Mar</b></th>
                    <th><b>Abr</b></th>
                    <th><b>May</b></th>
                    <th><b>Jun</b></th>
                    <th><b>Jul</b></th>
                    <th><b>Ago</b></th>
                    <th><b>Sep</b></th>
                    <th><b>Oct</b></th>
                    <th><b>Nov</b></th>
                    <th><b>Dic</b></th>
                    <th>Total Horas usadas</th>
                    <th>Horas Asignadas</th>
                    <th>Total Horas sin usar</th>
                    <th>Días Asignados</th>
                    <th>Días Disponibles</th>
                    <th>Días Utilizados</th>
                    <th>Días Excedentes</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $usado = $asignado = $restante = array();
                //PERMISOS
                foreach ($permisos as $kp => $valper) {
                    $usado[$kp] = 0;
                    /*
                    $asignado[$kp] = number_format($valper['thf_horas_ley'], 2, '.', '');
                    */
                    if (is_null($valper['thf_horas_ley'])) {
                        $suma = $this->gsatelite->get_campo("hpe_hora_permiso_x_empleado", "hpe_horas_limite", array("hpe_id_emp" => $employee['emp_id'], "hpe_id_thf" => $valper['thf_id']));
                        $asignado[$kp] = ($suma) ? number_format($suma, 2, '.', '') : number_format(0, 2);
                    } else {
                        $asignado[$kp] = number_format($valper['thf_horas_ley'], 2, '.', '');
                    }                    
                    $llave = '1_' . $employee['emp_id'] . '_' . $valper['thf_id']; ?>
                    <tr>
                        <td><?php echo $valper['thf_nombre'] ?></td>
                        <?php
                        for ($i = 1; $i <= 12; $i++) {
                            $existe = false;
                            $valor = 0;
                            foreach ($detalles as $key => $val) {
                                if ($val['empl'] == $employee['emp_id'] && $val['llave'] == $llave) {
                                    if (intval($i) == intval($val['mes'])) {
                                        $valor = $val['horas'];
                                        $usado[$kp] += $valor;
                                        $existe = true;
                                    }
                                }
                            }
                            if ($existe) {
                                ?>
                                <td style="text-align: right;"><?php echo number_format($valor, 2) ?></td>
                                <?php
                            } else {
                                ?>
                                <td style="text-align: right;"><?php echo number_format(0, 2); ?></td>
                                <?php
                            }
                        }
                        $restante[$kp] = (($asignado[$kp] - $usado[$kp]) < 0) ? 0 : ($asignado[$kp] - $usado[$kp]);
                        $days_asigned = ($asignado[$kp] / $dia_lab);
                        $days_dispnbl = ($restante[$kp] / $dia_lab);
                        $days_utiliza = ($days_asigned - $days_dispnbl);
                        $days_execedt = ($days_utiliza > $days_asigned) ? abs(($days_asigned - $days_utiliza)) : 0;
                        ?>
                        <td style="text-align: right;"><?php echo number_format($usado[$kp], 2); ?></td>
                        <td style="text-align: right;"><?php echo number_format($asignado[$kp], 2); ?></td>
                        <td style="text-align: right;"><?php echo number_format($restante[$kp], 2); ?></td>
                        <td style="text-align: right;"><?php echo number_format($days_asigned, 2); ?></td>
                        <td style="text-align: right;"><?php echo number_format($days_dispnbl, 2); ?></td>
                        <td style="text-align: right;"><?php echo number_format($days_utiliza, 2); ?></td>
                        <td style="text-align: right;"><?php echo number_format($days_execedt, 2); ?></td>
                    </tr>
                <?php
                }
                //INCAPACIDADES
                $usado = $asignado = $restante = array();
                foreach ($incapacidad as $ki => $valinc) {
                    $usado[$ki] = 0;
                    $asignado[$ki] = number_format($valinc['tnc_horas_ley'], 2, '.', '');
                    $llave = '2_' . $employee['emp_id'] . '_' . $valinc['tnc_id']; ?>
                    <tr>
                        <td><?php echo $valinc['tnc_nombre'] ?></td>
                        <?php
                        for ($i = 1; $i <= 12; $i++) {
                            $existe = false;
                            $valor = 0;
                            foreach ($detalles as $key => $val) {
                                if ($val['empl'] == $employee['emp_id'] && $val['llave'] == $llave) {
                                    if (intval($i) == intval($val['mes'])) {
                                        $valor = $val['horas'];
                                        $usado[$ki] += $valor;
                                        $existe = true;
                                    }
                                }
                            }
                            if ($existe) {
                        ?>
                                <td style="text-align: right;"><?php echo number_format($valor, 2) ?></td>
                            <?php
                            } else {
                            ?>
                                <td style="text-align: right;"><?php echo number_format(0, 2); ?></td>
                        <?php
                            }
                        }
                        $restante[$ki] = ($asignado[$ki] - $usado[$ki]);
                        $days_asigned = ($asignado[$ki] / $dia_lab);
                        $days_dispnbl = ($restante[$ki] / $dia_lab);
                        $days_utiliza = ($days_asigned - $days_dispnbl);
                        $days_execedt = ($days_utiliza > $days_asigned) ? abs(($days_asigned - $days_utiliza)) : 0;
                        ?>
                        <td style="text-align: right;"><?php echo number_format($usado[$ki], 2); ?></td>
                        <td style="text-align: right;"><?php echo number_format($asignado[$ki], 2); ?></td>
                        <td style="text-align: right;"><?php echo number_format($restante[$ki], 2); ?></td>
                        <td style="text-align: right;"><?php echo number_format($days_asigned, 2); ?></td>
                        <td style="text-align: right;"><?php echo number_format($days_dispnbl, 2); ?></td>
                        <td style="text-align: right;"><?php echo number_format($days_utiliza, 2); ?></td>
                        <td style="text-align: right;"><?php echo number_format($days_execedt, 2); ?></td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
        <br>
    <?php
    }
} else {
    ?>
    <table width="100%">
        <tr>
            <th style="text-align: center;">
                <h3>No se encontraron empleados activos</h3>
            </th>
        </tr>
    </table>
<?php
}
?>