<?php
if ($tipo_reporte == 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment; filename=rpt_goce_vacacion.xls");
}
$p = ($tipo_reporte == 'pdf') ? true : false;
if ($tipo_reporte == 'excel') {
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Goce de Vacaciones
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <br>
<?php
}
if ($tipo_reporte == 'pdf') {
?>
    <table width="100%" cellpadding="1" border="0">
        <tr>
            <td width="12%"><b>Período Desde :</b></td>
            <td width="13%"><?php echo $fecha_inicio; ?></td>
            <td width="6%"><b>Hasta :</b></td>
            <td width="14%"><?php echo $fecha_final; ?></td>
            <td width="55%"></td>
        </tr>
    </table>
<?php
}
?>
<table id="tabla_vacaciones" cellpadding="1" class="dynamicTable responsive table table-bordered" border="<?= ($tipo_reporte != "") ? 1 : 0; ?>" <?= ($p) ? 'style="font-size:9pt;"' : ""; ?>>
    <thead>
        <tr style="text-align: center;">
            <th <?php echo ($p) ? 'width="4%"' : ''; ?>><b>#</b></th>
            <th <?php echo ($p) ? 'width="9%"' : ''; ?>><b>C&oacute;digo</b></th>
            <th <?php echo ($p) ? 'width="31%"' : ''; ?>><b>Empleada/o</b></th>
            <th <?php echo ($p) ? 'width="26%"' : ''; ?>><b>Plaza / Cargo Funcional</b></th>
            <th <?php echo ($p) ? 'width="18%"' : ''; ?>><b>Período Vacación</b></th>
            <th <?php echo ($p) ? 'width="12%"' : ''; ?>><b>Dias Disponibles</b></th>
        </tr>
    </thead>
    <tbody>
        <?php
        $i = 1;
        if (count($detalles) > 0) {
            foreach ($detalles as $key => $val) {
                $ddisp = number_format(($val["vac_dia_ganado"] - $val['vac_dia_gozado']), 2, '.', '');
        ?>
                <tr nobr="true">
                    <td <?php echo ($p) ? 'width="4%"' : ''; ?> style="text-align: center;"><?php echo $i; ?></td>
                    <td <?php echo ($p) ? 'width="9%"' : ''; ?>><?php echo $val["emp_codigo"]; ?></td>
                    <td <?php echo ($p) ? 'width="31%"' : ''; ?>><?php echo $val["emp_nombre"] . ' ' . $val["emp_apellido"]; ?></td>
                    <td <?php echo ($p) ? 'width="26%"' : ''; ?>><?php echo $val["plz_nombre"]; ?></td>
                    <td <?php echo ($p) ? 'width="18%"' : ''; ?>>
                        <span style="display: none;"><?php echo ($tipo_reporte != "") ? "" : formatear_fecha('Ymd', $val["prv_desde"]); ?></span>
                        <span><?php echo formatear_fecha('d-m-Y', $val["prv_desde"]) . ' / ' . formatear_fecha('d-m-Y', $val["prv_hasta"]); ?></span>
                    </td>
                    <td <?php echo ($p) ? 'width="12%"' : ''; ?> style="text-align: right;"><?php echo round($ddisp, 2); ?></td>
                </tr>
            <?php
                $i++;
            }
        } else {
            ?>
        <?php
        }
        ?>
    </tbody>
</table>