<?php
$pdf = ($tipo > 0) ? false : true;
$dias_antg = ($this->gsatelite->get_intervalo_dias($datos_retiro['retiro']['emp_fecha_contrato'], $datos_retiro['retiro']['rte_fecha_retiro']) + 1);
$total_ingresos = $total_descuento = 0;
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo > 0) {
    header("Content-type: application/vnd.ms-excel; name='Reporte_horas_extras'");
    header("Content-Disposition: filename=Rpt_calculos_liquidac.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6">
                    <h4>
                        <?= mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') ?>
                        <br />
                        <span>Reporte de Cálculo de Liquidación</span>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <br>
<?php
}
if ($pdf) {
?>
    <style type="text/css">
        table th {
            text-align: center;
            font-weight: bold;
        }
    </style>
<?php
}
?>
<table id="generales" cellpadding="1.5" border="1" class="table table-bordered" width="100%">
    <tr>
        <th colspan="6" style="text-align: center;"><b>Datos Generales</b></th>
    </tr>
    <tr>
        <td <?= ($pdf) ? 'width="10%"' : ""; ?>><b>Nombre:</b></td>
        <td <?= ($pdf) ? 'width="40%"' : ""; ?> colspan="2"><?= $datos_retiro['retiro']['emp_nombre'] . ' ' . $datos_retiro['retiro']['emp_apellido'] ?></td>
        <td <?= ($pdf) ? 'width="13%"' : ""; ?>><b>Empresa:</b></td>
        <td <?= ($pdf) ? 'width="37%"' : ""; ?> colspan="2"><?= $this->gsatelite->get_parametro('SYS_EMPRESA') ?></td>
    </tr>
    <tr>
        <td><b>Plaza:</b></td>
        <td colspan="2"><?= $datos_retiro['retiro']['plz_nombre'] ?></td>
        <td><b>Motivo Retiro:</b></td>
        <td colspan="2"><?= $datos_retiro['retiro']['rte_motivo_retiro'] ?></td>
    </tr>
    <tr>
        <td><b>Salario: ($)</b></td>
        <td colspan="2"><?= number_format($datos_retiro['retiro']['emp_salario'], 2) ?></td>
        <td><b>Estado Retiro:</b></td>
        <td colspan="2"><?= ($datos_retiro['retiro']['rte_autorizar_ret'] > 0) ? 'Autorizado' : 'En proceso'; ?></td>
    </tr>
</table>
<br><br>
<table id="fechas" cellpadding="1.5" border="1" class="table table-bordered" width="100%">
    <tr>
        <th colspan="6" style="text-align: center;"><b>Cálculo de Fechas</b></th>
    </tr>
    <tr>
        <td><b>Fecha de Ingreso:</b></td>
        <td><?= formatear_fecha('d-m-Y', $datos_retiro['retiro']['emp_fecha_contrato']) ?></td>
        <td><b>Fecha de Retiro:</b></td>
        <td><?= formatear_fecha('d-m-Y', $datos_retiro['retiro']['rte_fecha_retiro']) ?></td>
        <td><b>Días Antigüedad:</b></td>
        <td><?= $dias_antg ?> <?= ($dias_antg > 1) ? 'días' : 'día'; ?></td>
    </tr>
    <tr>
        <td><b>Pago Ult. Vacación:</b></td>
        <td><?= formatear_fecha('d-m-Y', $datos_retiro['retiro']['emp_fecha_ult_vacacion']) ?></td>
        <td><b>Ult. Liquidación:</b></td>
        <td><?= formatear_fecha('d-m-Y', $datos_retiro['retiro']['emp_fecha_ult_liquidacion']) ?></td>
        <td><b>Ult. Aguinaldo:</b></td>
        <td><?= formatear_fecha('d-m-Y', $datos_retiro['retiro']['emp_fecha_ult_aguinaldo']) ?></td>
    </tr>
</table>
<br><br>
<table id="detalles" cellpadding="2" border="0" class="table table-bordered" width="100%">
    <tr>
        <th colspan="6" style="text-align: center; border-bottom: solid 1px black;"><b>Detalles de la Liquidación</b></th>
    </tr>
    <tr>
        <td colspan="3">
            <table border="1" cellpadding="1">
                <tr>
                    <th colspan="3">Ingresos</th>
                </tr>
                <?php
                if (count($datos_retiro['ingresos_lqe']) > 0) {
                    foreach ($datos_retiro['ingresos_lqe'] as $k => $inglqe) {
                        $total_ingresos += number_format($inglqe['inn_valor'], 2, '.', '');
                ?>
                        <tr>
                            <td width="75%" colspan="2"><?php echo $inglqe['tig_nombre'] ?></td>
                            <td width="25%" style="text-align: right;"><?= $simbolo ?><?php echo number_format($inglqe['inn_valor'], 2) ?></td>
                        </tr>
                    <?php
                    }
                }
                if (count($datos_retiro['otros_ingresos']) > 0) {
                    foreach ($datos_retiro['otros_ingresos'] as $key => $otring) {
                        $total_ingresos += number_format($otring['inn_valor'], 2, '.', '');
                    ?>
                        <tr>
                            <td width="75%" colspan="2"><?php echo $otring['tig_nombre'] ?></td>
                            <td width="25%" style="text-align: right;"><?= $simbolo ?><?php echo number_format($otring['inn_valor'], 2) ?></td>
                        </tr>
                <?php
                    }
                }
                ?>
            </table>
        </td>
        <td colspan="3">
            <table border="1">
                <tr>
                    <th colspan="3">Deducciones</th>
                </tr>
                <?php
                if (count($datos_retiro['descuentos_lqe']) > 0) {
                    foreach ($datos_retiro['descuentos_lqe'] as $k => $deslqe) {
                        $total_descuento += number_format($deslqe['dss_valor'], 2, '.', '');
                ?>
                        <tr>
                            <td width="75%" colspan="2"><?php echo $deslqe['tdc_nombre'] ?></td>
                            <td width="25%" style="text-align: right;"><?= $simbolo ?><?php echo number_format($deslqe['dss_valor'], 2) ?></td>
                        </tr>
                    <?php
                    }
                }
                if (count($datos_retiro['otros_descuentos']) > 0) {
                    foreach ($datos_retiro['otros_descuentos'] as $key => $otrdes) {
                        $total_descuento += number_format($otrdes['dss_valor'], 2, '.', '');
                    ?>
                        <tr>
                            <td width="75%" colspan="2"><?php echo $otrdes['tdc_nombre'] ?></td>
                            <td width="25%" style="text-align: right;"><?= $simbolo ?><?php echo number_format($otrdes['dss_valor'], 2) ?></td>
                        </tr>
                <?php
                    }
                }
                ?>
            </table>
        </td>
    </tr>
    <tr>
        <td colspan="3">
            <table border="1" cellpadding="1">
                <tr>
                    <td width="75%" style="text-align: right;" colspan="2"><b>Total Ingresos</b></td>
                    <td width="25%" style="text-align: right;"><b><?= $simbolo ?><?php echo number_format($total_ingresos, 2) ?></b></td>
                </tr>
            </table>
        </td>
        <td colspan="3">
            <table border="1" cellpadding="1">
                <tr>
                    <td width="75%" style="text-align: right;" colspan="2"><b>Total Deducciones</b></td>
                    <td width="25%" style="text-align: right;"><b><?= $simbolo ?><?php echo number_format($total_descuento, 2) ?></b></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <th colspan="6" style="border-bottom: solid 1px black;"></th>
    </tr>
    <tr>
        <td colspan="5" style=" text-align: right;"><b>Total a Pagar</b></td>
        <td style=" text-align: right;"><b><?= $simbolo ?><?php echo number_format(($total_ingresos - $total_descuento), 2) ?></b></td>
    </tr>
</table>
<br><br>
<table id="generales" cellpadding="1.5" border="0" class="table table-bordered" width="100%">
    <tr>
        <th colspan="6" style="border-bottom: solid 1px black;"><b>Observaciones</b></th>
    </tr>
    <tr>
        <td colspan="6"><?= $datos_retiro['retiro']['lqe_observaciones']; ?></td>
    </tr>
</table>
<?php if ($pdf) {
?>
    <br><br><br><br><br><br>
    <br><br><br><br><br><br>
    <table border="0" width="100%">
        <tr>
            <td width="30%" style="border-bottom: solid black 1px;"></td>
            <td width="5%"></td>
            <td width="30%" style="border-bottom: solid black 1px;"></td>
            <td width="5%"></td>
            <td width="30%" style="border-bottom: solid black 1px;"></td>
        </tr>
        <tr>
            <td style="text-align: center;">ELABORADO POR</td>
            <td></td>
            <td style="text-align: center;">REVISADO POR</td>
            <td></td>
            <td style="text-align: center;">AUTORIZADO POR</td>
        </tr>
    </table>
<?php
} ?>