<?php
$p = ($reporte == 'pdf') ? true : false;
$dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
if ($reporte == 'excel') {
    header("Content-type: application/vnd.ms-excel; name='Reporte_horas'");
    header("Content-Disposition: filename=Reporte_horas_permisos.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6" >
                    <h4>
                        <?= mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') ?>
                        <br />
                        <span>Reporte de Tiempo de Permiso</span>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <br>
    <?php
}
?>
<table id="tabla" cellpadding="1" cellspacing="0" border="<?=($reporte != '') ? 1 : 0; ?>" class="responsive display table table-bordered" width="100%">
    <thead>
        <tr style="text-align: center; font-weight: bold;">
            <th <?= ($p) ? 'width="5%"' : '';?>>#</th>
            <th <?= ($p) ? 'width="10%"' : '';?>>Código</th> 
            <th <?= ($p) ? 'width="23%"' : '';?>>Empleada/o</th> 
            <th <?= ($p) ? 'width="10%"' : '';?>>Fecha Registro</th>  
            <th <?= ($p) ? 'width="16%"' : '';?>>Tipo Permiso</th>
            <th <?= ($p) ? 'width="16%"' : '';?>>Motivo</th>
            <th <?= ($p) ? 'width="10%"' : '';?>>Estado</th>
            <th <?= ($p) ? 'width="10%"' : '';?>>Nº Horas</th>
        </tr>
    </thead>
    <tbody>
        <?php if (count($registros) > 0) {
            $i = $total_h = 0;
            foreach ($registros as $key => $value) {
                $i++;
                $total_h += $value['hxe_num_hora']; 
                if ($value['hxe_estado'] == 2) {
                    $echo = "Aprobado";
                } elseif ($value['hxe_estado'] == 1) {
                    $echo = "Creado";
                } else {
                    $echo = "Rechazado";
                }
                ?>
                <tr nobr="true">
                    <td <?= ($p) ? 'width="5%"' : '';?>><?= $i; ?></td>
                    <td <?= ($p) ? 'width="10%"' : '';?>><?= $value['emp_codigo']; ?></td>
                    <td <?= ($p) ? 'width="23%"' : '';?>><?= $value['nombre']; ?></td>
                    <td <?= ($p) ? 'width="10%"' : '';?>><?= ($value['hxe_fecha'] != "") ? formatear_fecha('d-m-Y', $value['hxe_fecha']) : ""; ?></td>
                    <td <?= ($p) ? 'width="16%"' : '';?>><?= $value['thf_nombre']; ?></td>
                    <td <?= ($p) ? 'width="16%"' : '';?>><?= $value['mtp_nombre']; ?></td>
                    <td <?= ($p) ? 'width="10%"' : '';?>><?= $echo; ?></td>
                    <td <?= ($p) ? 'width="10%"' : '';?> style="text-align: right;"><?= number_format($value['hxe_num_hora'], $dec, '.', ''); ?></td>
                </tr>
                <?php
            }
        } ?>
    </tbody>
    <?php if (count($registros) > 0) { ?>
        <tfoot>
            <tr>
                <td colspan="7" style="font-weight: bold; text-align: right;">Total</td>
                <td style="font-weight: bold; text-align: right;"><?php echo number_format($total_h, $dec, '.', ''); ?></td>
            </tr>
        </tfoot>
    <?php } ?>
</table>